/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.XMLDocFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import java.util.Set;
import java.util.TreeSet;

@Singleton
public final class MutableGUIDFilter
implements SpamFilter {
    private Set<byte[]> _guids = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
    private final KeywordFilter FILTER;

    MutableGUIDFilter(KeywordFilter keywordFilter) {
        this.FILTER = keywordFilter;
    }

    MutableGUIDFilter() {
        this(new XMLDocFilter());
        this.FILTER.disallowAdult();
    }

    public synchronized void addGUID(byte[] byArray) {
        TreeSet<byte[]> treeSet = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
        treeSet.addAll(this._guids);
        treeSet.add(byArray);
        this._guids = treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGUID(byte[] byArray) {
        if (this._guids.size() == 0) {
            return;
        }
        MutableGUIDFilter mutableGUIDFilter = this;
        synchronized (mutableGUIDFilter) {
            if (this._guids.size() > 0) {
                TreeSet<byte[]> treeSet = new TreeSet<byte[]>(new GUID.GUIDByteComparator());
                treeSet.addAll(this._guids);
                treeSet.remove(byArray);
                this._guids = treeSet;
            }
        }
    }

    public boolean allow(QueryReply queryReply) {
        if (this._guids.contains(queryReply.getGUID())) {
            return this.FILTER.allow(queryReply);
        }
        return true;
    }

    public boolean allow(Message message) {
        if (message instanceof QueryReply) {
            return this.allow((QueryReply)message);
        }
        return true;
    }
}

