/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.util.Objects;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.UrlRemoteFileDescImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteFileDescImpl
implements RemoteFileDesc {
    private static final Log LOG = LogFactory.getLog(RemoteFileDesc.class);
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final boolean _chatEnabled;
    private final int _quality;
    private final boolean _replyToMulticast;
    private final LimeXMLDocument _xmlDoc;
    private final Set<URN> _urns;
    private final boolean _browseHostEnabled;
    private final boolean _firewalled;
    private final String _vendor;
    private boolean _http11;
    private boolean _tlsCapable;
    private final PushEndpoint _pushAddr;
    private IntervalSet _availableRanges = null;
    private int _queueStatus = Integer.MAX_VALUE;
    private int _failedCount = 0;
    private volatile long _earliestRetryTime = 0L;
    private int _hashCode = 0;
    private boolean _THEXFailed = false;
    private RemoteHostData _hostData = null;
    private volatile boolean _isDownloading = false;
    private final long _creationTime;
    private volatile boolean _serializeProxies = false;
    private float _spamRating = 0.0f;
    private int _secureStatus = 0;
    private final long _size;
    private final NetworkInstanceUtils networkInstanceUtils;

    RemoteFileDescImpl(String string, int n, long l, String string2, long l2, byte[] byArray, int n2, boolean bl, int n3, boolean bl2, LimeXMLDocument limeXMLDocument, Set<? extends URN> set, boolean bl3, boolean bl4, String string3, Set<? extends IpPort> set2, long l3, int n4, PushEndpoint pushEndpoint, boolean bl5, boolean bl6, NetworkInstanceUtils networkInstanceUtils) {
        Objects.nonNull(string2, "filename");
        Objects.nonNull(string, "host");
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (((long)n2 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + n2);
        }
        if (string2.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (l2 < 0L || l2 > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("invalid size: " + l2);
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        this._speed = n2;
        this._host = string;
        this._port = n;
        this._index = l;
        this._filename = string2;
        this._size = l2;
        this._firewalled = bl4;
        this._pushAddr = pushEndpoint;
        this._clientGUID = byArray;
        this._chatEnabled = bl;
        this._quality = n3;
        this._browseHostEnabled = bl2;
        this._replyToMulticast = bl3;
        this._vendor = string3;
        this._creationTime = l3;
        this._tlsCapable = bl5;
        this._xmlDoc = limeXMLDocument;
        this._http11 = bl6;
        this._urns = Collections.unmodifiableSet(set);
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void setSerializeProxies() {
        this._serializeProxies = true;
    }

    @Override
    public boolean isTLSCapable() {
        return this._tlsCapable;
    }

    @Override
    public void setTLSCapable(boolean bl) {
        this._tlsCapable = bl;
    }

    @Override
    public boolean isHTTP11() {
        return this._http11;
    }

    @Override
    public void setHTTP11(boolean bl) {
        this._http11 = bl;
    }

    @Override
    public boolean isPartialSource() {
        return this._availableRanges != null;
    }

    @Override
    public boolean isMe(byte[] byArray) {
        return this.needsPush() ? Arrays.equals(this._clientGUID, byArray) : this.networkInstanceUtils.isMe(this.getHost(), this.getPort());
    }

    @Override
    public IntervalSet getAvailableRanges() {
        return this._availableRanges.clone();
    }

    @Override
    public void setAvailableRanges(IntervalSet intervalSet) {
        this._availableRanges = intervalSet;
    }

    @Override
    public int getFailedCount() {
        return this._failedCount;
    }

    @Override
    public void incrementFailedCount() {
        ++this._failedCount;
    }

    @Override
    public void resetFailedCount() {
        this._failedCount = 0;
    }

    @Override
    public boolean isFromAlternateLocation() {
        return "ALT".equals(this._vendor);
    }

    @Override
    public boolean isBusy() {
        return this.isBusy(System.currentTimeMillis());
    }

    @Override
    public boolean isBusy(long l) {
        return l < this._earliestRetryTime;
    }

    @Override
    public int getWaitTime(long l) {
        return this.isBusy(l) ? (int)(this._earliestRetryTime - l) / 1000 + 1 : 0;
    }

    @Override
    public void setRetryAfter(int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting retry after to be [" + n + "] seconds for " + this);
        }
        this._earliestRetryTime = System.currentTimeMillis() + (long)(n * 1000);
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public boolean hasTHEXFailed() {
        return this._THEXFailed;
    }

    @Override
    public void setTHEXFailed() {
        this._THEXFailed = true;
    }

    @Override
    public void setDownloading(boolean bl) {
        this._isDownloading = bl;
    }

    @Override
    public boolean isDownloading() {
        return this._isDownloading;
    }

    @Override
    public final String getHost() {
        return this._host;
    }

    @Override
    public final int getPort() {
        return this._port;
    }

    @Override
    public final long getIndex() {
        return this._index;
    }

    @Override
    public final long getSize() {
        return this._size;
    }

    @Override
    public final long getFileSize() {
        return this._size;
    }

    @Override
    public final String getFileName() {
        return this._filename;
    }

    @Override
    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    @Override
    public final int getSpeed() {
        return this._speed;
    }

    @Override
    public final String getVendor() {
        return this._vendor;
    }

    @Override
    public final boolean isChatEnabled() {
        return this._chatEnabled;
    }

    @Override
    public final boolean isBrowseHostEnabled() {
        return this._browseHostEnabled;
    }

    @Override
    public final int getQuality() {
        return this._quality;
    }

    @Override
    public final LimeXMLDocument getXMLDocument() {
        return this._xmlDoc;
    }

    @Override
    public final Set<URN> getUrns() {
        return this._urns;
    }

    @Override
    public final URN getSHA1Urn() {
        for (URN uRN : this._urns) {
            if (uRN == null || !uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    @Override
    public URL getUrl() {
        try {
            String string = "";
            URN uRN = this.getSHA1Urn();
            string = uRN == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + uRN.httpStringValue();
            return new URL("http", this._host, this._port, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    @Override
    public final boolean isPrivate() {
        return this.networkInstanceUtils.isPrivateAddress(this._host);
    }

    @Override
    public boolean isFirewalled() {
        return this._firewalled;
    }

    @Override
    public final Set<? extends IpPort> getPushProxies() {
        if (this._pushAddr != null) {
            return this._pushAddr.getProxies();
        }
        return Collections.emptySet();
    }

    @Override
    public final boolean supportsFWTransfer() {
        if (this._host.equals("1.1.1.1") || !NetworkUtils.isValidAddress(this._host) || this.networkInstanceUtils.isPrivateAddress(this._host)) {
            return false;
        }
        return this._pushAddr == null ? false : this._pushAddr.supportsFWTVersion() > 0;
    }

    @Override
    public final RemoteHostData getRemoteHostData() {
        if (this._hostData == null) {
            this._hostData = new RemoteHostData(this._host, this._port, this._clientGUID);
        }
        return this._hostData;
    }

    @Override
    public final boolean isAltLocCapable() {
        boolean bl;
        boolean bl2 = bl = this.getSHA1Urn() != null && !this._replyToMulticast;
        bl = this._firewalled ? bl && this._pushAddr != null && this._pushAddr.getProxies().size() > 0 : bl && NetworkUtils.isValidPort(this._port) && !this.networkInstanceUtils.isPrivateAddress(this._host) && NetworkUtils.isValidAddress(this._host);
        return bl;
    }

    @Override
    public boolean needsPush() {
        if (this.isReplyToMulticast()) {
            return true;
        }
        if (this.isPrivate()) {
            return !(this instanceof UrlRemoteFileDescImpl);
        }
        if (!NetworkUtils.isValidPort(this.getPort())) {
            return true;
        }
        return this.isFirewalled();
    }

    @Override
    public PushEndpoint getPushAddr() {
        return this._pushAddr;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)object;
        if (!this.nullEquals(this._host, remoteFileDesc.getHost()) || this._port != remoteFileDesc.getPort()) {
            return false;
        }
        if (this._size != remoteFileDesc.getSize()) {
            return false;
        }
        if (this._clientGUID == null != (remoteFileDesc.getClientGUID() == null)) {
            return false;
        }
        if (this._clientGUID != null && !Arrays.equals(this._clientGUID, remoteFileDesc.getClientGUID())) {
            return false;
        }
        if (this._urns.isEmpty() && remoteFileDesc.getUrns().isEmpty()) {
            return this.nullEquals(this._filename, remoteFileDesc.getFileName());
        }
        return ((Object)this._urns).equals(remoteFileDesc.getUrns());
    }

    private boolean nullEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int n = 17;
            n = 37 * n + this._host.hashCode();
            n = 37 * n + this._port;
            n = (int)((long)(37 * n) + this._size);
            n = 37 * n + ((Object)this._urns).hashCode();
            if (this._clientGUID != null) {
                n = 37 * n + new GUID(this._clientGUID).hashCode();
            }
            this._hashCode = n;
        }
        return this._hashCode;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName().toLowerCase() + ">";
    }

    @Override
    public String getAddress() {
        return this.getHost();
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public void setQueueStatus(int n) {
        this._queueStatus = n;
    }

    @Override
    public int getQueueStatus() {
        return this._queueStatus;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress != null) {
            return new InetSocketAddress(inetAddress, this.getPort());
        }
        return null;
    }

    @Override
    public void setSpamRating(float f) {
        this._spamRating = f;
    }

    @Override
    public float getSpamRating() {
        return this._spamRating;
    }

    @Override
    public int getSecureStatus() {
        return this._secureStatus;
    }

    @Override
    public void setSecureStatus(int n) {
        this._secureStatus = n;
    }

    @Override
    public RemoteHostMemento toMemento() {
        return new RemoteHostMemento(this._host, this._port, this._filename, this._index, this._clientGUID, this._speed, this._size, this._chatEnabled, this._quality, this._replyToMulticast, this.xmlString(), this._urns, this._browseHostEnabled, this._firewalled, this._vendor, this._http11, this._tlsCapable, this.pushAddrString());
    }

    private String xmlString() {
        if (this._xmlDoc == null) {
            return null;
        }
        return this._xmlDoc.getXMLString();
    }

    private String pushAddrString() {
        if (this._serializeProxies && this._pushAddr != null) {
            return this._pushAddr.httpStringValue();
        }
        return null;
    }
}

