/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Provider;
import com.google.inject.util.Objects;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocUtils;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.http.SimpleReadHeaderState;
import com.limegroup.gnutella.http.SimpleWriteHeaderState;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.ThexReader;
import com.limegroup.gnutella.tigertree.ThexReaderFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.Function;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.io.Connectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.channel.ThrottleReader;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateMachine;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.nio.statemachine.ReadSkipState;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.rudp.RUDPSocket;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog(HTTPDownloader.class);
    public static final int BUF_LENGTH = 2048;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    static volatile int MIN_PARTIAL_FILE_BYTES = 0x100000;
    private RemoteFileDesc _rfd;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private long _totalAmountRead;
    private long _amountRead;
    private long _amountToRead;
    private volatile boolean _disconnect;
    private long _initialReadingPoint;
    private long _initialWritingPoint;
    private long _contentLength;
    private volatile boolean _bodyConsumed = true;
    private Socket _socket;
    private IOStateMachine _stateMachine;
    private Observer observerHandler;
    private SimpleReadHeaderState _headerReader;
    private boolean _requestingThex;
    private ThexReader _thexReader;
    private final VerifyingFile _incompleteFile;
    private Set<RemoteFileDesc> _locationsReceived;
    private Set<DirectAltLoc> _goodLocs;
    private Set<PushAltLoc> _goodPushLocs;
    private Set<PushAltLoc> _badPushLocs;
    private Set<DirectAltLoc> _badLocs;
    private Set<DirectAltLoc> _writtenGoodLocs;
    private Set<DirectAltLoc> _writtenBadLocs;
    private Set<PushAltLoc> _writtenPushLocs;
    private Set<PushAltLoc> _writtenBadPushLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isActive = false;
    private Range _requestedInterval = null;
    private boolean _wantsFalts = false;
    private final boolean _inNetwork;
    private final NetworkManager networkManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final DownloadManager downloadManager;
    private final CreationTimeCache creationTimeCache;
    private final BandwidthManager bandwidthManager;
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final PushEndpointFactory pushEndpointFactory;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final ThexReaderFactory thexReaderFactory;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    HTTPDownloader(Socket socket, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, boolean bl, boolean bl2, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, DownloadManager downloadManager, CreationTimeCache creationTimeCache, BandwidthManager bandwidthManager, Provider<PushEndpointCache> provider, PushEndpointFactory pushEndpointFactory, RemoteFileDescFactory remoteFileDescFactory, ThexReaderFactory thexReaderFactory, TcpBandwidthStatistics tcpBandwidthStatistics, NetworkInstanceUtils networkInstanceUtils) {
        if (bl2 && socket == null) {
            throw new NullPointerException("null socket");
        }
        this.networkManager = networkManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.downloadManager = downloadManager;
        this.creationTimeCache = creationTimeCache;
        this.bandwidthManager = bandwidthManager;
        this.pushEndpointCache = provider;
        this.pushEndpointFactory = pushEndpointFactory;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.thexReaderFactory = thexReaderFactory;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
        this._rfd = Objects.nonNull(remoteFileDesc, "rfd");
        this._socket = socket;
        this._incompleteFile = verifyingFile;
        this._filename = remoteFileDesc.getFileName();
        this._index = remoteFileDesc.getIndex();
        this._guid = remoteFileDesc.getClientGUID();
        this._amountToRead = 0L;
        this._port = remoteFileDesc.getPort();
        this._host = remoteFileDesc.getHost();
        this._chatEnabled = remoteFileDesc.isChatEnabled();
        this._browseEnabled = remoteFileDesc.isBrowseHostEnabled();
        this._locationsReceived = new HashSet<RemoteFileDesc>();
        this._goodLocs = new HashSet<DirectAltLoc>();
        this._badLocs = new HashSet<DirectAltLoc>();
        this._goodPushLocs = new HashSet<PushAltLoc>();
        this._badPushLocs = new HashSet<PushAltLoc>();
        this._writtenGoodLocs = new HashSet<DirectAltLoc>();
        this._writtenBadLocs = new HashSet<DirectAltLoc>();
        this._writtenPushLocs = new HashSet<PushAltLoc>();
        this._writtenBadPushLocs = new HashSet<PushAltLoc>();
        this._amountRead = 0L;
        this._totalAmountRead = 0L;
        this._inNetwork = bl;
    }

    Collection<RemoteFileDesc> getLocationsReceived() {
        return this._locationsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends AlternateLocation> void storeLocation(T t, Set<T> set, Set<T> set2, Set<T> set3, Set<T> set4) {
        Set<T> set5 = set;
        synchronized (set5) {
            set2.remove(t);
            set.remove(t);
        }
        set5 = set3;
        synchronized (set5) {
            if (!set4.contains(t)) {
                set3.add(t);
            }
        }
    }

    void addSuccessfulAltLoc(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            DirectAltLoc directAltLoc = (DirectAltLoc)alternateLocation;
            HTTPDownloader.storeLocation(directAltLoc, this._badLocs, this._writtenBadLocs, this._goodLocs, this._writtenGoodLocs);
        } else if (alternateLocation instanceof PushAltLoc) {
            PushAltLoc pushAltLoc = (PushAltLoc)alternateLocation;
            HTTPDownloader.storeLocation(pushAltLoc, this._badPushLocs, this._writtenBadPushLocs, this._goodPushLocs, this._writtenPushLocs);
        } else {
            throw new IllegalStateException("bad location of class: " + alternateLocation.getClass());
        }
    }

    void addFailedAltLoc(AlternateLocation alternateLocation) {
        if (alternateLocation instanceof DirectAltLoc) {
            DirectAltLoc directAltLoc = (DirectAltLoc)alternateLocation;
            HTTPDownloader.storeLocation(directAltLoc, this._goodLocs, this._writtenGoodLocs, this._badLocs, this._writtenBadLocs);
        } else if (alternateLocation instanceof PushAltLoc) {
            PushAltLoc pushAltLoc = (PushAltLoc)alternateLocation;
            HTTPDownloader.storeLocation(pushAltLoc, this._goodPushLocs, this._writtenPushLocs, this._badPushLocs, this._writtenBadPushLocs);
        } else {
            throw new IllegalStateException("bad location of class: " + alternateLocation.getClass());
        }
    }

    public void initializeTCP() throws IOException {
        if (this._socket == null) {
            throw new IllegalStateException("no socket!");
        }
        try {
            this._socket.setKeepAlive(true);
        }
        catch (IOException iOException) {
            if (!OSUtils.isWindowsVista()) {
                throw iOException;
            }
            LOG.warn("couldn't set keepalive");
        }
        this.observerHandler = new Observer();
        this._stateMachine = new IOStateMachine(this.observerHandler, new LinkedList<IOState>(), 2048);
        this._stateMachine.setReadChannel(new ThrottleReader(this.bandwidthManager.getReadThrottle()));
        ((NIOMultiplexor)((Object)this._socket)).setReadObserver(this._stateMachine);
        ((NIOMultiplexor)((Object)this._socket)).setWriteObserver(this._stateMachine);
        this._socket.setSoTimeout(8000);
    }

    public void connectHTTP(long l, long l2, boolean bl, IOStateObserver iOStateObserver) {
        this.connectHTTP(l, l2, bl, -1L, iOStateObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(long l, long l2, boolean bl, long l3, IOStateObserver iOStateObserver) {
        Object object;
        HTTPHeaderValue hTTPHeaderValue;
        if (l < 0L) {
            throw new IllegalArgumentException("invalid start: " + l);
        }
        if (l2 <= l) {
            throw new IllegalArgumentException("stop(" + l2 + ") <= start(" + l + ")");
        }
        Object object2 = this;
        synchronized (object2) {
            this._isActive = true;
            this._amountToRead = l2 - l;
            this._amountRead = 0L;
            this._initialReadingPoint = l;
            this._initialWritingPoint = l;
            this._bodyConsumed = false;
            this._contentLength = 0L;
            this._requestedInterval = Range.createRange(this._initialReadingPoint, l2 - 1L);
        }
        this.observerHandler.setDelegate(iOStateObserver);
        object2 = new ArrayList();
        HashSet<HTTPHeaderValue> hashSet = new HashSet<HTTPHeaderValue>();
        object2.add(HTTPHeaderName.HOST.create(this._host + ":" + this._port));
        object2.add(HTTPHeaderName.USER_AGENT.create(ConstantHTTPHeaderValue.USER_AGENT));
        if (bl) {
            object2.add(HTTPHeaderName.QUEUE.create(ConstantHTTPHeaderValue.QUEUE_VERSION));
            hashSet.add(ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT()) {
            hashSet.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
            if (!this.networkManager.acceptedIncomingConnection()) {
                hashSet.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
            }
        }
        if (this.isPartialFileValid() && (this.networkManager.acceptedIncomingConnection() || this._wantsFalts) && (hTTPHeaderValue = this.alternateLocationFactory.create(this._rfd.getSHA1Urn())) != null) {
            this.addSuccessfulAltLoc((AlternateLocation)hTTPHeaderValue);
        }
        if ((hTTPHeaderValue = this._rfd.getSHA1Urn()) != null) {
            object2.add(HTTPHeaderName.GNUTELLA_CONTENT_URN.create(hTTPHeaderValue));
        }
        this.writeAlternateLocations((List<Header>)object2, HTTPHeaderName.ALT_LOCATION, this._goodLocs, this._writtenGoodLocs, true);
        this.writeAlternateLocations((List<Header>)object2, HTTPHeaderName.NALTS, this._badLocs, this._writtenBadLocs, false);
        if (this._wantsFalts) {
            this.writeAlternateLocations((List<Header>)object2, HTTPHeaderName.FALT_LOCATION, this._goodPushLocs, this._writtenPushLocs, false);
            this.writeAlternateLocations((List<Header>)object2, HTTPHeaderName.BFALT_LOCATION, this._badPushLocs, this._writtenBadPushLocs, false);
        }
        object2.add(HTTPHeaderName.RANGE.create("bytes=" + this._initialReadingPoint + "-" + (l2 - 1L)));
        if (this.networkManager.acceptedIncomingConnection() && !this.networkInstanceUtils.isPrivateAddress(this.networkManager.getAddress())) {
            int n = this.networkManager.getPort();
            object = NetworkUtils.ip2string(this.networkManager.getAddress());
            object2.add(HTTPHeaderName.NODE.create((String)object + ":" + n));
            hashSet.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                object2.add(HTTPHeaderName.CHAT.create((String)object + ":" + n));
                hashSet.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (!this.networkManager.acceptedIncomingConnection()) {
            object2.add(HTTPHeaderName.FW_NODE_INFO.create(this.pushEndpointFactory.createForSelf()));
            hashSet.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
        }
        if (hashSet.size() > 0) {
            object2.add(HTTPHeaderName.FEATURES.create(new HTTPHeaderValueCollection(hashSet)));
        }
        if (l3 > 0L) {
            object2.add(HTTPHeaderName.DOWNLOADED.create("" + l3));
        }
        SimpleWriteHeaderState simpleWriteHeaderState = new SimpleWriteHeaderState("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1", (List<? extends Header>)object2, this._inNetwork ? this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_INNETWORK_UPSTREAM) : this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_UPSTREAM));
        object = new SimpleReadHeaderState(this._inNetwork ? this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_INNETWORK_DOWNSTREAM) : this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_DOWNSTREAM), DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._stateMachine.addStates(new IOState[]{simpleWriteHeaderState, object});
        this._headerReader = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends AlternateLocation> void writeAlternateLocations(List<Header> list, HTTPHeaderName hTTPHeaderName, Set<T> set, Set<T> set2, boolean bl) {
        ArrayList<HTTPHeaderValue> arrayList = null;
        BitNumbers bitNumbers = null;
        Object object = set;
        synchronized (object) {
            if (set.size() > 0) {
                arrayList = new ArrayList<HTTPHeaderValue>(set.size());
                if (bl) {
                    bitNumbers = new BitNumbers(set.size());
                }
                for (AlternateLocation alternateLocation : set) {
                    Object object2;
                    if (alternateLocation instanceof PushAltLoc) {
                        object2 = (PushAltLoc)alternateLocation;
                        if (((PushAltLoc)object2).getPushAddress().getProxies().isEmpty()) {
                            if (((PushAltLoc)object2).getPushAddress().isLocal()) continue;
                            assert (false) : "empty pushloc in downloader";
                        }
                    } else if (alternateLocation instanceof DirectAltLoc) {
                        object2 = ((DirectAltLoc)alternateLocation).getHost();
                        if (bl && object2 instanceof Connectable && ((Connectable)object2).isTLSCapable()) {
                            assert (bitNumbers != null);
                            bitNumbers.set(arrayList.size());
                        }
                    }
                    arrayList.add(alternateLocation);
                    set2.add(alternateLocation);
                }
                set.clear();
            }
        }
        if (arrayList != null) {
            if (bitNumbers != null && !bitNumbers.isEmpty()) {
                object = bitNumbers.toHexString();
                arrayList.add(0, new HTTPHeaderValue((String)object){
                    final /* synthetic */ String val$hex;
                    {
                        this.val$hex = string;
                    }

                    public String httpStringValue() {
                        return "tls=" + this.val$hex;
                    }
                });
            }
            list.add(hTTPHeaderName.create(new HTTPHeaderValueCollection(arrayList)));
        }
    }

    void consumeBody(IOStateObserver iOStateObserver) {
        if (!this._bodyConsumed) {
            if (this._contentLength != -1L) {
                this.consumeBody(this._contentLength, iOStateObserver);
            } else {
                iOStateObserver.handleIOException(new IOException("no content length"));
            }
        } else {
            iOStateObserver.handleStatesFinished();
        }
        this._bodyConsumed = true;
    }

    boolean isBodyConsumed() {
        return this._bodyConsumed;
    }

    public void requestHashTree(URN uRN, IOStateObserver iOStateObserver) {
        SimpleReadHeaderState simpleReadHeaderState;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port);
        }
        this.observerHandler.setDelegate(iOStateObserver);
        ArrayList<Header> arrayList = new ArrayList<Header>();
        arrayList.add(HTTPHeaderName.HOST.create(this._host + ":" + this._port));
        arrayList.add(HTTPHeaderName.USER_AGENT.create(ConstantHTTPHeaderValue.USER_AGENT));
        SimpleWriteHeaderState simpleWriteHeaderState = new SimpleWriteHeaderState("GET " + this._thexUri + " HTTP/1.1", arrayList, this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_UPSTREAM));
        this._headerReader = simpleReadHeaderState = new SimpleReadHeaderState(this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_DOWNSTREAM), DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._requestingThex = true;
        this._bodyConsumed = false;
        this._stateMachine.addStates(simpleWriteHeaderState, simpleReadHeaderState);
    }

    boolean isRequestingThex() {
        return this._requestingThex;
    }

    public ConnectionStatus parseThexResponseHeaders() {
        this._requestingThex = false;
        try {
            int n = HTTPDownloader.parseHTTPCode(this._headerReader.getConnectLine(), this._rfd);
            boolean bl = false;
            if (n < 200 || n >= 300) {
                bl = true;
            }
            return this.parseThexHeaders(n, bl);
        }
        catch (IOException iOException) {
            return ConnectionStatus.getNoFile();
        }
    }

    public void downloadThexBody(URN uRN, IOStateObserver iOStateObserver) {
        this._thexReader = this.thexReaderFactory.createHashTreeReader(uRN.httpStringValue(), this._root32, this._rfd.getFileSize());
        this.observerHandler.setDelegate(iOStateObserver);
        this._stateMachine.addState(this._thexReader);
    }

    public HashTree getHashTree() {
        this._contentLength -= this._thexReader.getAmountProcessed();
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        HashTree hashTree = null;
        try {
            hashTree = this._thexReader.getHashTree();
        }
        catch (IOException iOException) {
            LOG.warn("Failed to create tree", iOException);
        }
        if (hashTree == null) {
            this._rfd.setTHEXFailed();
        } else {
            this._thexSucceeded = true;
        }
        return hashTree;
    }

    private ConnectionStatus parseThexHeaders(int n, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._rfd + " consuming headers");
        }
        this._contentLength = -1L;
        for (Map.Entry<String, String> entry : this._headerReader.getHeaders().entrySet()) {
            String string = entry.getKey();
            if (HTTPHeaderName.CONTENT_LENGTH.is(string)) {
                this._contentLength = HTTPDownloader.readContentLength(entry.getValue());
            }
            if (n != 503 || !HTTPHeaderName.QUEUE.is(string)) continue;
            String string2 = entry.getValue();
            int[] nArray = new int[]{-1, -1, -1};
            this.parseQueueHeaders(string2, nArray);
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            if (n2 == -1 || n3 == -1 || n4 == -1) continue;
            this._bodyConsumed = true;
            return ConnectionStatus.getQueued(n4, n2);
        }
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        if (bl || this._contentLength == -1L) {
            return ConnectionStatus.getNoFile();
        }
        return ConnectionStatus.getConnected();
    }

    private void consumeBody(long l, IOStateObserver iOStateObserver) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("enter consumeBody(" + l + ")");
        }
        if (l < 0L) {
            iOStateObserver.handleIOException(new IOException("unknown content-length, can't consume"));
        }
        this.observerHandler.setDelegate(iOStateObserver);
        this._stateMachine.addState(new ReadSkipState(l));
    }

    public void parseHeaders() throws IOException {
        String string = this._headerReader.getConnectLine();
        Map<String, String> map = this._headerReader.getHeaders();
        if (string == null || string.equals("")) {
            throw new IOException();
        }
        int n = HTTPDownloader.parseHTTPCode(string, this._rfd);
        this._contentLength = -1L;
        int[] nArray = new int[]{-1, -1, -1};
        for (Map.Entry<String, String> object : map.entrySet()) {
            String string2 = object.getKey();
            String string3 = object.getValue();
            if (HTTPHeaderName.CONTENT_RANGE.is(string2)) {
                this.validateContentRange(this.parseContentRange(string3));
                continue;
            }
            if (HTTPHeaderName.CONTENT_LENGTH.is(string2)) {
                this._contentLength = HTTPDownloader.readContentLength(string3);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.is(string2)) {
                this.checkContentUrnHeader(string3, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.is(string2)) {
                this.checkContentUrnHeader(string3, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.is(string2)) {
                this.readAlternateLocations(string3, true);
                continue;
            }
            if (HTTPHeaderName.QUEUE.is(string2)) {
                this.parseQueueHeaders(string3, nArray);
                continue;
            }
            if (HTTPHeaderName.SERVER.is(string2)) {
                this._server = string3;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Server is: " + string3);
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.is(string2)) {
                this.parseAvailableRangesHeader(string3, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.is(string2)) {
                HTTPDownloader.parseRetryAfterHeader(string3, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.is(string2)) {
                this.parseCreationTimeHeader(string3, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.is(string2)) {
                this.parseFeatureHeader(string3);
                continue;
            }
            if (HTTPHeaderName.THEX_URI.is(string2)) {
                this.parseTHEXHeader(string3);
                continue;
            }
            if (HTTPHeaderName.FALT_LOCATION.is(string2)) {
                this.parseFALTHeader(string3);
                continue;
            }
            if (HTTPHeaderName.PROXIES.is(string2)) {
                this.parseProxiesHeader(string3);
                continue;
            }
            if (!HTTPHeaderName.FWTPORT.is(string2)) continue;
            this.parseFWTPortHeader(string3);
        }
        if (n < 200 || n >= 300) {
            if (n == 404) {
                throw new FileNotFoundException();
            }
            if (n == 410) {
                throw new NotSharingException();
            }
            if (n == 416) {
                if (this._rfd.isPartialSource()) {
                    for (Range range : this._rfd.getAvailableRanges()) {
                        if (!this._requestedInterval.isSubrange(range)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (n == 503) {
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = nArray[2];
                if (n2 != -1 && n3 != -1 && n4 != -1) {
                    this._bodyConsumed = true;
                    throw new QueuedException(n2, n3, n4);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(n);
        }
    }

    private void checkContentUrnHeader(String string, URN uRN) throws ContentUrnMismatchException {
        if (this._root32 == null && string.indexOf("urn:bitprint:") > -1) {
            this._root32 = string.substring(string.lastIndexOf(".") + 1).trim();
        }
        if (uRN == null) {
            return;
        }
        URN uRN2 = null;
        try {
            uRN2 = URN.createSHA1Urn(string);
        }
        catch (IOException iOException) {
            return;
        }
        if (!uRN.equals(uRN2)) {
            throw new ContentUrnMismatchException();
        }
    }

    private void readAlternateLocations(String string, boolean bl) {
        AltLocUtils.parseAlternateLocations(this._rfd.getSHA1Urn(), string, bl, this.alternateLocationFactory, new Function<AlternateLocation, Void>(){

            @Override
            public Void apply(AlternateLocation alternateLocation) {
                RemoteFileDesc remoteFileDesc = alternateLocation.createRemoteFileDesc(HTTPDownloader.this._rfd.getSize(), HTTPDownloader.this.remoteFileDescFactory);
                HTTPDownloader.this._locationsReceived.add(remoteFileDesc);
                return null;
            }
        });
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && this._incompleteFile.getVerifiedBlockSize() > (long)MIN_PARTIAL_FILE_BYTES && SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && NetworkUtils.isValidPort(this.networkManager.getPort()) && NetworkUtils.isValidAddress(this.networkManager.getAddress());
    }

    public static long readContentLength(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static int parseHTTPCode(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + string);
        }
        remoteFileDesc.setHTTP11(string2.indexOf("1.1") > 0);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
    }

    private void parseQueueHeaders(String string, int[] nArray) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,:=");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                String string3;
                if (string2.equalsIgnoreCase("pollMin")) {
                    string3 = stringTokenizer.nextToken();
                    nArray[0] = Integer.parseInt(string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("pollMax")) {
                    string3 = stringTokenizer.nextToken();
                    nArray[1] = Integer.parseInt(string3);
                    continue;
                }
                if (!string2.equalsIgnoreCase("position")) continue;
                string3 = stringTokenizer.nextToken();
                nArray[2] = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Arrays.fill(nArray, -1);
                break;
            }
            catch (NoSuchElementException noSuchElementException) {
                Arrays.fill(nArray, -1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateContentRange(Range range) throws IOException {
        long l = range.getLow();
        long l2 = range.getHigh() + 1L;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (this._disconnect) {
                throw new IOException("stolen from");
            }
            if (l < this._initialReadingPoint || l2 > this._initialReadingPoint + this._amountToRead) {
                throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1L) + "... given low: " + l + ", high: " + l2);
            }
            this._initialReadingPoint = l;
            this._amountToRead = l2 - l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range parseContentRange(String string) throws IOException {
        long l;
        long l2;
        long l3;
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading content range: " + string);
        }
        try {
            int n = string.indexOf("bytes") + 6;
            int n2 = string.indexOf(47);
            if (string.substring(n, n2).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this._rfd + " Content-Range like */?, " + string);
                }
                HTTPDownloader hTTPDownloader = this;
                synchronized (hTTPDownloader) {
                    return Range.createRange(0L, this._amountToRead - 1L);
                }
            }
            int n3 = string.lastIndexOf("-");
            l3 = Long.parseLong(string.substring(n, n3));
            l2 = Long.parseLong(string.substring(n3 + 1, n2));
            if (l2 < l3) {
                throw new ProblemReadingHeaderException("invalid range, high (" + l2 + ") less than low (" + l3 + ")");
            }
            if (string.substring(n2 + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this._rfd + " Content-Range like #-#/*, " + string);
                }
                return Range.createRange(l3, l2);
            }
            l = Long.parseLong(string.substring(n2 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(string);
        }
        if (l2 == l) {
            --l3;
            --l2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._rfd + " Content-Range like #-#/#, " + string);
        }
        return Range.createRange(l3, l2);
    }

    private void parseAvailableRangesHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        int n;
        IntervalSet intervalSet = new IntervalSet();
        string = string.toLowerCase();
        int n2 = string.indexOf("bytes") + 6;
        while (n2 != -1 && n2 < string.length() && (n = string.indexOf(45, n2)) != -1) {
            Range range = null;
            try {
                long l = Long.parseLong(string.substring(n2, n).trim());
                n2 = n + 1;
                n = string.indexOf(44, n2);
                if (n == -1) {
                    n = string.length();
                }
                long l2 = Long.parseLong(string.substring(n2, n).trim());
                n2 = n + 1;
                if (l2 >= remoteFileDesc.getSize()) {
                    l2 = remoteFileDesc.getSize() - 1L;
                }
                if (l > l2) continue;
                range = Range.createRange(l, l2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException(numberFormatException);
            }
            intervalSet.add(range);
        }
        remoteFileDesc.setAvailableRanges(intervalSet);
    }

    private static void parseRetryAfterHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        n = Math.max(n, 60);
        n = Math.min(n, 3600);
        remoteFileDesc.setRetryAfter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCreationTimeHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        if (remoteFileDesc.getSHA1Urn() != null && l > 0L) {
            CreationTimeCache creationTimeCache = this.creationTimeCache;
            synchronized (creationTimeCache) {
                Long l2 = this.creationTimeCache.getCreationTime(remoteFileDesc.getSHA1Urn());
                if (l2 == null || l2 > l) {
                    this.creationTimeCache.addTime(remoteFileDesc.getSHA1Urn(), l);
                }
            }
        }
    }

    private void parseFeatureHeader(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase().trim() : string2.substring(0, n).toLowerCase().trim();
            if (string3.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (string3.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (string3.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!string3.equals("fwt")) continue;
            int n2 = 0;
            try {
                n2 = (int)HTTPUtils.parseFeatureToken(string2);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {
                continue;
            }
            try {
                this.updatePEAddress();
                this.pushEndpointCache.get().setFWTVersionSupported(this._rfd.getClientGUID(), n2);
            }
            catch (IOException iOException) {}
        }
    }

    private void parseTHEXHeader(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._host + ":" + this._port + ">" + string);
        }
        if (string.indexOf(";") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this._thexUri = stringTokenizer.nextToken();
            this._root32 = stringTokenizer.nextToken();
        } else {
            this._thexUri = string;
        }
    }

    private void parseFALTHeader(String string) {
        this._wantsFalts = true;
        this.readAlternateLocations(string, false);
    }

    private void parseProxiesHeader(String string) {
        if (this._rfd.getPushAddr() == null || string == null || string.length() < 12) {
            return;
        }
        try {
            this.pushEndpointCache.get().overwriteProxies(this._rfd.getClientGUID(), string);
            this.updatePEAddress();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseFWTPortHeader(String string) {
        try {
            int n = Integer.parseInt(string);
            if (NetworkUtils.isValidPort(n)) {
                IpPortImpl ipPortImpl = new IpPortImpl(this._socket.getInetAddress(), n);
                this.pushEndpointCache.get().setAddr(this._rfd.getClientGUID(), ipPortImpl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void updatePEAddress() throws IOException {
        IpPortImpl ipPortImpl;
        if (this._socket instanceof RUDPSocket && this.networkInstanceUtils.isValidExternalIpPort(ipPortImpl = new IpPortImpl(this._socket.getInetAddress(), this._socket.getPort()))) {
            this.pushEndpointCache.get().setAddr(this._rfd.getClientGUID(), ipPortImpl);
        }
    }

    public void doDownload(IOStateObserver iOStateObserver) throws SocketException {
        this._socket.setSoTimeout(60000);
        this.observerHandler.setDelegate(iOStateObserver);
        this._stateMachine.addState(new DownloadState());
    }

    void createAssertionReport(AssertFailure assertFailure) {
        Object object;
        String string = "current worker " + System.identityHashCode(this);
        String string2 = null;
        URN uRN = this._rfd.getSHA1Urn();
        string2 = uRN != null ? ((object = (ManagedDownloaderImpl)this.downloadManager.getDownloaderForURN(uRN)) == null ? "couldn't find my downloader???" : ((ManagedDownloaderImpl)object).getWorkersInfo()) : " sha1 not available ";
        object = assertFailure.getMessage() + "\n\n" + string + "\n\n" + string2;
        AssertFailure assertFailure2 = new AssertFailure((String)object);
        assertFailure2.setStackTrace(assertFailure.getStackTrace());
        throw assertFailure2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER:" + this + " signaled to stop at " + (this._initialReadingPoint + this._amountRead));
            }
            this._isActive = false;
        }
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                IOUtils.close(HTTPDownloader.this._socket);
            }
        });
    }

    public synchronized void stopAt(long l) {
        this._disconnect = true;
        this._amountToRead = Math.min(this._amountToRead, l - this._initialReadingPoint);
    }

    public synchronized void startAt(long l) {
        this._initialWritingPoint = l;
    }

    synchronized void forgetRanges() {
        this._initialWritingPoint = 0L;
        this._initialReadingPoint = 0L;
        this._amountToRead = 0L;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0L;
    }

    public synchronized long getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public synchronized long getInitialWritingPoint() {
        return this._initialWritingPoint;
    }

    public synchronized long getAmountRead() {
        return this._amountRead;
    }

    public synchronized long getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public synchronized long getAmountToRead() {
        return this._amountToRead;
    }

    public synchronized boolean isActive() {
        return this._isActive;
    }

    synchronized boolean isVictim() {
        return this._disconnect;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public boolean wantsFalts() {
        return this._wantsFalts;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        long l = 0L;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (!this._isActive) {
                return;
            }
            l = this.getTotalAmountRead();
        }
        this.bandwidthTracker.measureBandwidth(l);
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    @Override
    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean bl) {
    }

    private static class Observer
    implements IOStateObserver {
        private IOStateObserver delegate;
        private boolean handled = false;
        private boolean error = false;

        private Observer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleIOException(IOException iOException) {
            IOStateObserver iOStateObserver;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    LOG.warn("Ignoring iox", iOException);
                    return;
                }
                this.handled = true;
                iOStateObserver = this.delegate;
            }
            if (iOStateObserver != null) {
                iOStateObserver.handleIOException(iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatesFinished() {
            IOStateObserver iOStateObserver;
            Observer observer = this;
            synchronized (observer) {
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Ignoring states finished", new Exception());
                    }
                    return;
                }
                this.handled = true;
                iOStateObserver = this.delegate;
            }
            if (iOStateObserver != null) {
                iOStateObserver.handleStatesFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IOStateObserver iOStateObserver;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Ignoring shutdown.");
                    }
                    return;
                }
                this.handled = true;
                iOStateObserver = this.delegate;
            }
            if (iOStateObserver != null) {
                iOStateObserver.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDelegate(IOStateObserver iOStateObserver) {
            boolean bl = false;
            Observer observer = this;
            synchronized (observer) {
                this.handled = false;
                bl = this.error;
                this.delegate = iOStateObserver;
            }
            if (bl) {
                iOStateObserver.shutdown();
            }
        }
    }

    private static class DownloadRestarter
    implements VerifyingFile.WriteCallback,
    Runnable {
        private final DownloadState downloader;
        private final InterestReadableByteChannel irc;
        private final ByteBuffer buffer;

        DownloadRestarter(InterestReadableByteChannel interestReadableByteChannel, ByteBuffer byteBuffer, DownloadState downloadState) {
            this.irc = interestReadableByteChannel;
            this.buffer = byteBuffer;
            this.downloader = downloadState;
        }

        public void writeScheduled() {
            LOG.debug("Delayed write scheduled");
            NIODispatcher.instance().executeLaterAlways(this);
        }

        public void run() {
            this.buffer.clear();
            this.downloader.writeDone();
            this.irc.interestRead(true);
        }
    }

    private class DownloadState
    extends ReadState {
        private long currPos;
        private volatile boolean doingWrite;

        private DownloadState() {
            this.currPos = HTTPDownloader.this._initialReadingPoint;
        }

        void writeDone() {
            this.doingWrite = false;
            HTTPDownloader.this._stateMachine.handleRead();
        }

        protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
            if (this.doingWrite) {
                return true;
            }
            boolean bl = false;
            try {
                bl = this.readImpl(readableByteChannel, byteBuffer);
            }
            catch (IOException iOException) {
                LOG.debug("Error while reading", iOException);
                this.chunkCompleted();
                throw iOException;
            }
            if (!bl) {
                this.chunkCompleted();
                if (!HTTPDownloader.this.isHTTP11() || HTTPDownloader.this._disconnect) {
                    throw new IOException("stolen from");
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chunkCompleted() {
            HTTPDownloader.this._bodyConsumed = true;
            HTTPDownloader hTTPDownloader = HTTPDownloader.this;
            synchronized (hTTPDownloader) {
                HTTPDownloader.this._isActive = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readImpl(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
            while (true) {
                long l;
                int n;
                int n2;
                long l2;
                long l3 = 0L;
                HTTPDownloader hTTPDownloader = HTTPDownloader.this;
                synchronized (hTTPDownloader) {
                    if (HTTPDownloader.this._amountRead >= HTTPDownloader.this._amountToRead) {
                        LOG.debug("Read >= to needed, done.");
                        HTTPDownloader.this._isActive = false;
                        return false;
                    }
                    l2 = HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead;
                }
                int n3 = (int)Math.min(l2, (long)byteBuffer.position());
                if (n3 != 0 && LOG.isDebugEnabled()) {
                    LOG.debug("Using preread data of: " + n3);
                }
                if (l2 - (long)n3 > 0L) {
                    if ((long)byteBuffer.limit() > l2) {
                        byteBuffer.limit((int)l2);
                    }
                    while (byteBuffer.hasRemaining() && (l3 = (long)readableByteChannel.read(byteBuffer)) > 0L) {
                    }
                    byteBuffer.limit(byteBuffer.capacity());
                }
                int n4 = byteBuffer.position();
                if (HTTPDownloader.this._inNetwork) {
                    HTTPDownloader.this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_BODY_INNETWORK_DOWNSTREAM).addData(n4);
                } else {
                    HTTPDownloader.this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_BODY_DOWNSTREAM).addData(n4);
                }
                if (n4 == 0) {
                    if (l3 == -1L) {
                        LOG.debug("EOF while reading");
                        throw new IOException("EOF");
                    }
                    if (l3 == 0L) {
                        return true;
                    }
                }
                Object object = this;
                synchronized (object) {
                    if (HTTPDownloader.this._isActive) {
                        if ((n4 = (int)Math.min((long)n4, HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead)) <= 0) {
                            LOG.debug("Someone stole completely from us while reading");
                            HTTPDownloader.this._isActive = false;
                            byteBuffer.clear();
                            return false;
                        }
                        int n5 = (int)Math.min((long)n4, Math.max(0L, HTTPDownloader.this._initialWritingPoint - this.currPos));
                        if (n5 > 0) {
                            LOG.debug("Amount we should skip: " + n5);
                        }
                        n2 = n4 - n5;
                        n = n5;
                        l = this.currPos + (long)n5;
                        HTTPDownloader.this._amountRead += n4;
                        this.currPos += (long)n4;
                        if (n5 >= n4) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("skipped full read of: " + n5 + " bytes");
                            }
                            byteBuffer.clear();
                            continue;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("WORKER:" + this + " stopping at " + (HTTPDownloader.this._initialReadingPoint + HTTPDownloader.this._amountRead));
                        }
                        byteBuffer.clear();
                        return false;
                    }
                }
                try {
                    object = new VerifyingFile.WriteRequest(l, n, n2, byteBuffer.array());
                    if (!HTTPDownloader.this._incompleteFile.writeBlock((VerifyingFile.WriteRequest)object)) {
                        LOG.debug("Scheduling callback for write.");
                        InterestReadableByteChannel interestReadableByteChannel = (InterestReadableByteChannel)readableByteChannel;
                        interestReadableByteChannel.interestRead(false);
                        this.doingWrite = true;
                        HTTPDownloader.this._incompleteFile.registerWriteCallback((VerifyingFile.WriteRequest)object, new DownloadRestarter(interestReadableByteChannel, byteBuffer, this));
                        return true;
                    }
                }
                catch (AssertFailure assertFailure) {
                    HTTPDownloader.this.createAssertionReport(assertFailure);
                }
                byteBuffer.clear();
            }
        }

        public long getAmountProcessed() {
            return -1L;
        }
    }
}

