/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.SourceRanker;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceRanker
implements SourceRanker {
    protected MeshHandler meshHandler;

    @Override
    public boolean addToPool(Collection<? extends RemoteFileDesc> collection) {
        boolean bl = false;
        for (RemoteFileDesc remoteFileDesc : collection) {
            if (!this.addToPool(remoteFileDesc)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public abstract boolean addToPool(RemoteFileDesc var1);

    @Override
    public abstract boolean hasMore();

    @Override
    public abstract RemoteFileDesc getBest();

    @Override
    public abstract Collection<RemoteFileDesc> getShareableHosts();

    @Override
    public abstract int getNumKnownHosts();

    @Override
    public synchronized boolean hasNonBusy() {
        return this.getNumKnownHosts() > this.getNumBusyHosts();
    }

    @Override
    public synchronized int getNumBusyHosts() {
        int n = 0;
        long l = System.currentTimeMillis();
        for (RemoteFileDesc remoteFileDesc : this.getPotentiallyBusyHosts()) {
            if (!remoteFileDesc.isBusy(l)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public synchronized int calculateWaitTime() {
        if (!this.hasMore()) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        long l = System.currentTimeMillis();
        for (RemoteFileDesc remoteFileDesc : this.getPotentiallyBusyHosts()) {
            if (!remoteFileDesc.isBusy(l)) continue;
            n = Math.min(n, remoteFileDesc.getWaitTime(l));
        }
        return n * 1000;
    }

    protected abstract Collection<RemoteFileDesc> getPotentiallyBusyHosts();

    @Override
    public synchronized void stop() {
        this.clearState();
        this.meshHandler = null;
    }

    protected void clearState() {
    }

    @Override
    public synchronized void setMeshHandler(MeshHandler meshHandler) {
        this.meshHandler = meshHandler;
    }

    @Override
    public synchronized MeshHandler getMeshHandler() {
        return this.meshHandler;
    }
}

