/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.IOException;
import java.io.OutputStream;

class AltLocValueForSelf
extends AbstractAltLocValue {
    private static final long serialVersionUID = 8101291047246461600L;
    private final long fileSize;
    private final byte[] ttroot;
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    public AltLocValueForSelf(long l, byte[] byArray, NetworkManager networkManager, ApplicationServices applicationServices) {
        super(AbstractAltLocValue.VERSION);
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal fileSize: " + l);
        }
        if (byArray != null && byArray.length != 24) {
            throw new IllegalArgumentException("Illegal ttroot length: " + byArray.length);
        }
        this.fileSize = l;
        this.ttroot = byArray;
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
    }

    public byte[] getValue() {
        return AbstractAltLocValue.serialize(this);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getValue());
    }

    public int getPort() {
        return this.networkManager.getPort();
    }

    public byte[] getGUID() {
        return this.applicationServices.getMyGUID();
    }

    public boolean isFirewalled() {
        return !this.networkManager.acceptedIncomingConnection();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public byte[] getRootHash() {
        return this.ttroot;
    }

    public boolean supportsTLS() {
        return SSLSettings.isIncomingTLSEnabled();
    }
}

