/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Provider;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DHTSettings;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTNodeFetcher {
    private static final Log LOG = LogFactory.getLog(DHTNodeFetcher.class);
    private final DHTBootstrapper bootstrapper;
    private volatile long lastRequest = 0L;
    private ScheduledFuture<?> fetcherTask = null;
    private final Object fetcherTaskLock = new Object();
    private final AtomicBoolean pingingSingleHost = new AtomicBoolean(false);
    private UDPPinger pinger;
    private volatile int pingExpireTime = -1;
    private final ConnectionServices connectionServices;
    private final Provider<HostCatcher> hostCatcher;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<UDPPinger> udpPingerFactory;
    private final PingRequestFactory pingRequestFactory;

    public DHTNodeFetcher(DHTBootstrapper dHTBootstrapper, ConnectionServices connectionServices, Provider<HostCatcher> provider, ScheduledExecutorService scheduledExecutorService, Provider<UDPPinger> provider2, PingRequestFactory pingRequestFactory) {
        this.connectionServices = connectionServices;
        this.hostCatcher = provider;
        this.backgroundExecutor = scheduledExecutorService;
        this.udpPingerFactory = provider2;
        this.bootstrapper = dHTBootstrapper;
        this.pingRequestFactory = pingRequestFactory;
    }

    private synchronized void requestDHTHosts() {
        LOG.debug("Requesting DHT hosts");
        if (!this.connectionServices.isConnected()) {
            return;
        }
        List<ExtendedEndpoint> list = this.hostCatcher.get().getDHTSupportEndpoint(0);
        boolean bl = false;
        for (ExtendedEndpoint extendedEndpoint : list) {
            if (!DHTManager.DHTMode.ACTIVE.equals((Object)extendedEndpoint.getDHTMode())) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding active host from HostCatcher: " + extendedEndpoint.getInetSocketAddress());
            }
            bl = true;
            this.bootstrapper.addBootstrapHost(extendedEndpoint.getInetSocketAddress());
        }
        if (bl) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastRequest < DHTSettings.DHT_NODE_FETCHER_TIME.getValue()) {
            return;
        }
        if (this.pingingSingleHost.get()) {
            return;
        }
        this.lastRequest = l;
        PingRequest pingRequest = this.pingRequestFactory.createUDPingWithDHTIPPRequest();
        UDPPingerRequestListener uDPPingerRequestListener = new UDPPingerRequestListener();
        UDPPingRankerCanceller uDPPingRankerCanceller = new UDPPingRankerCanceller();
        if (!list.isEmpty()) {
            LOG.debug("Sending ping to dht capable hosts");
            this.hostCatcher.get().getPinger().rank(list, uDPPingerRequestListener, uDPPingRankerCanceller, pingRequest);
        } else {
            LOG.debug("Sending ping to all hosts");
            this.hostCatcher.get().sendMessageToAllHosts(pingRequest, uDPPingerRequestListener, uDPPingRankerCanceller);
        }
    }

    public void requestDHTHosts(SocketAddress socketAddress) {
        if (!this.connectionServices.isConnected()) {
            return;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return;
        }
        if (!this.pingingSingleHost.getAndSet(true)) {
            IpPortImpl ipPortImpl = new IpPortImpl((InetSocketAddress)socketAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting DHT hosts from host " + socketAddress);
            }
            PingRequest pingRequest = this.pingRequestFactory.createUDPingWithDHTIPPRequest();
            if (this.pinger == null) {
                this.pinger = this.udpPingerFactory.get();
            }
            this.pinger.rank(Arrays.asList(ipPortImpl), new SinglePingRequestListener(), null, pingRequest, this.pingExpireTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.fetcherTaskLock;
        synchronized (object) {
            if (this.fetcherTask != null) {
                return;
            }
            long l = DHTSettings.DHT_NODE_FETCHER_TIME.getValue();
            long l2 = (long)(Math.random() * (double)l);
            Runnable runnable = new Runnable(){

                public void run() {
                    DHTNodeFetcher.this.requestDHTHosts();
                }
            };
            this.fetcherTask = this.backgroundExecutor.scheduleWithFixedDelay(runnable, l2, l, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.fetcherTaskLock;
        synchronized (object) {
            if (this.fetcherTask != null) {
                this.fetcherTask.cancel(true);
                this.fetcherTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.fetcherTaskLock;
        synchronized (object) {
            return this.fetcherTask != null;
        }
    }

    private void processPingReply(Message message) {
        Collection<IpPort> collection;
        if (!(message instanceof PingReply)) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        PingReply pingReply = (PingReply)message;
        Collection<IpPort> collection2 = collection = ConnectionSettings.FILTER_CLASS_C.getValue() ? NetworkUtils.filterOnePerClassC(pingReply.getPackedDHTIPPorts()) : pingReply.getPackedDHTIPPorts();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received ping reply from " + pingReply.getAddress());
        }
        for (IpPort ipPort : collection) {
            this.bootstrapper.addBootstrapHost(new InetSocketAddress(ipPort.getInetAddress(), ipPort.getPort()));
        }
    }

    public void setPingExpireTime(int n) {
        this.pingExpireTime = n;
    }

    private class SinglePingRequestListener
    extends UDPPingerRequestListener {
        private SinglePingRequestListener() {
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            super.processMessage(message, replyHandler);
            DHTNodeFetcher.this.pingingSingleHost.set(false);
        }

        public void unregistered(byte[] byArray) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistering Ping");
            }
            DHTNodeFetcher.this.pingingSingleHost.set(false);
        }
    }

    private class UDPPingerRequestListener
    implements MessageListener {
        private UDPPingerRequestListener() {
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            DHTNodeFetcher.this.processPingReply(message);
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }

    private class UDPPingRankerCanceller
    implements Cancellable {
        private UDPPingRankerCanceller() {
        }

        public boolean isCancelled() {
            boolean bl;
            long l = System.currentTimeMillis() - DHTNodeFetcher.this.lastRequest;
            boolean bl2 = bl = DHTNodeFetcher.this.pingingSingleHost.get() || l > DHTSettings.MAX_DHT_NODE_FETCHER_TIME.getValue() || !DHTNodeFetcher.this.connectionServices.isConnected() || !DHTNodeFetcher.this.isRunning();
            if (bl && LOG.isDebugEnabled()) {
                LOG.debug("Cancelling UDP ping after " + l + " ms, connected: " + DHTNodeFetcher.this.connectionServices.isConnected() + ", waiting: " + DHTNodeFetcher.this.bootstrapper.isWaitingForNodes());
            }
            return bl;
        }
    }
}

