/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Provider;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.connection.AbstractConnection;
import com.limegroup.gnutella.connection.CompositeQueue;
import com.limegroup.gnutella.connection.CompressionBandwidthTrackerImpl;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionMessageStatistics;
import com.limegroup.gnutella.connection.ConnectionRoutingStatistics;
import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.connection.MessageReader;
import com.limegroup.gnutella.connection.MessageReaderFactory;
import com.limegroup.gnutella.connection.MessageReceiver;
import com.limegroup.gnutella.connection.MessageWriter;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.handshaking.AsyncIncomingHandshaker;
import com.limegroup.gnutella.handshaking.AsyncOutgoingHandshaker;
import com.limegroup.gnutella.handshaking.HandshakeObserver;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponderFactory;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.OOBProxyControlVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBThrottle;
import org.limewire.nio.Throttle;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.DeflaterWriter;
import org.limewire.nio.channel.DelayedBufferWriter;
import org.limewire.nio.channel.InflaterReader;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.channel.StatisticGatheringWriter;
import org.limewire.nio.channel.ThrottleWriter;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnutellaConnection
extends AbstractConnection
implements ReplyHandler,
MessageReceiver,
SentMessageHandler,
Shutdownable,
Inspectable,
RoutedConnection,
ConnectionRoutingStatistics,
ConnectionMessageStatistics {
    private static final Log LOG = LogFactory.getLog(GnutellaConnection.class);
    private long LEAF_QUERY_ROUTE_UPDATE_TIME = 300000L;
    private long ULTRAPEER_QUERY_ROUTE_UPDATE_TIME = 60000L;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 8000;
    private volatile SpamFilter _routeFilter;
    private volatile SpamFilter _personalFilter;
    private final Object QRP_LOCK = new Object();
    private static final Throttle _nbThrottle = new NBThrottle(true, 8000.0f, ConnectionSettings.NUM_CONNECTIONS.getValue(), 5000);
    private volatile OutputRunner _outputRunner;
    private final ConnectionStats _connectionStats = new ConnectionStats();
    private long _nextQRPForwardTime;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isKillable = true;
    private volatile int hopsFlowMax = -1;
    private volatile long _busyTime = -1L;
    private volatile boolean myPushProxy;
    private volatile boolean pushProxyFor;
    private QueryRouteTable _lastQRPTableReceived;
    private QueryRouteTable _lastQRPTableSent;
    private boolean supernodeClientAtLooping = false;
    private volatile Deflater deflater;
    private volatile Inflater inflater;
    private volatile byte[] clientGUID = DataUtils.EMPTY_GUID;
    private volatile boolean _useLocalPreference;
    private boolean receivedCapVM = false;
    private int _maxDisabledOOBProtocolVersion = 0;
    private final ConnectionManager connectionManager;
    private final NetworkManager networkManager;
    private final QueryRequestFactory queryRequestFactory;
    private final HeadersFactory headersFactory;
    private final HandshakeResponderFactory handshakeResponderFactory;
    private final QueryReplyFactory queryReplyFactory;
    private final MessageDispatcher messageDispatcher;
    private final NetworkUpdateSanityChecker networkUpdateSanityChecker;
    private final SearchResultHandler searchResultHandler;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<ConnectionServices> connectionServices;
    private final GuidMapManager guidMapManager;
    private final SocketsManager socketsManager;
    private final GuidMap guidMap;
    private final MessageReaderFactory messageReaderFactory;
    private final ApplicationServices applicationServices;
    private final SecureMessageVerifier secureMessageVerifier;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Map<StatsWriters, StatisticGatheringWriter> statsWriters = new HashMap<StatsWriters, StatisticGatheringWriter>();
    private volatile Message.MessageCounter incoming;
    private volatile Message.MessageCounter outgoing;
    private volatile long droppedBadHops;
    private volatile long droppedBadAddress;

    public GnutellaConnection(String string, int n, SocketsManager.ConnectType connectType, ConnectionManager connectionManager, NetworkManager networkManager, QueryRequestFactory queryRequestFactory, HeadersFactory headersFactory, HandshakeResponderFactory handshakeResponderFactory, QueryReplyFactory queryReplyFactory, MessageDispatcher messageDispatcher, NetworkUpdateSanityChecker networkUpdateSanityChecker, SearchResultHandler searchResultHandler, CapabilitiesVMFactory capabilitiesVMFactory, SocketsManager socketsManager, Acceptor acceptor, MessagesSupportedVendorMessage messagesSupportedVendorMessage, Provider<UpdateHandler> provider, Provider<ConnectionServices> provider2, GuidMapManager guidMapManager, SpamFilterFactory spamFilterFactory, MessageReaderFactory messageReaderFactory, MessageFactory messageFactory, ApplicationServices applicationServices, SecureMessageVerifier secureMessageVerifier, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        super(string, n, connectType, capabilitiesVMFactory, messagesSupportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.headersFactory = headersFactory;
        this.handshakeResponderFactory = handshakeResponderFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.messageDispatcher = messageDispatcher;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.searchResultHandler = searchResultHandler;
        this.updateHandler = provider;
        this.connectionServices = provider2;
        this.guidMapManager = guidMapManager;
        this.messageReaderFactory = messageReaderFactory;
        this.applicationServices = applicationServices;
        this.guidMap = guidMapManager.getMap();
        this._routeFilter = spamFilterFactory.createRouteFilter();
        this._personalFilter = spamFilterFactory.createPersonalFilter();
        this.secureMessageVerifier = secureMessageVerifier;
        this.socketsManager = socketsManager;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public GnutellaConnection(Socket socket, ConnectionManager connectionManager, NetworkManager networkManager, QueryRequestFactory queryRequestFactory, HeadersFactory headersFactory, HandshakeResponderFactory handshakeResponderFactory, QueryReplyFactory queryReplyFactory, MessageDispatcher messageDispatcher, NetworkUpdateSanityChecker networkUpdateSanityChecker, SearchResultHandler searchResultHandler, CapabilitiesVMFactory capabilitiesVMFactory, Acceptor acceptor, MessagesSupportedVendorMessage messagesSupportedVendorMessage, Provider<UpdateHandler> provider, Provider<ConnectionServices> provider2, GuidMapManager guidMapManager, SpamFilterFactory spamFilterFactory, MessageReaderFactory messageReaderFactory, MessageFactory messageFactory, ApplicationServices applicationServices, SecureMessageVerifier secureMessageVerifier, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        super(socket, capabilitiesVMFactory, messagesSupportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.headersFactory = headersFactory;
        this.handshakeResponderFactory = handshakeResponderFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.messageDispatcher = messageDispatcher;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.searchResultHandler = searchResultHandler;
        this.updateHandler = provider;
        this.connectionServices = provider2;
        this.guidMapManager = guidMapManager;
        this.messageReaderFactory = messageReaderFactory;
        this.applicationServices = applicationServices;
        this.guidMap = guidMapManager.getMap();
        this._routeFilter = spamFilterFactory.createRouteFilter();
        this._personalFilter = spamFilterFactory.createPersonalFilter();
        this.secureMessageVerifier = secureMessageVerifier;
        this.socketsManager = null;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void initialize(GnetConnectObserver gnetConnectObserver) throws IOException {
        HandshakeResponder handshakeResponder;
        Properties properties;
        if (gnetConnectObserver == null && this.isOutgoing()) {
            throw new NullPointerException("must have an observer if outgoing!");
        }
        if (this.isOutgoing()) {
            String string = this.getAddress();
            if (this.connectionServices.get().isSupernode()) {
                properties = this.headersFactory.createUltrapeerHeaders(string);
                handshakeResponder = this.handshakeResponderFactory.createUltrapeerHandshakeResponder(string);
            } else {
                properties = this.headersFactory.createLeafHeaders(string);
                handshakeResponder = this.handshakeResponderFactory.createLeafHandshakeResponder(string);
            }
        } else {
            String string = this.getSocket().getInetAddress().getHostAddress();
            properties = null;
            handshakeResponder = this.connectionServices.get().isSupernode() ? this.handshakeResponderFactory.createUltrapeerHandshakeResponder(string) : this.handshakeResponderFactory.createLeafHandshakeResponder(string);
        }
        this.initialize(properties, handshakeResponder, 6000, gnetConnectObserver);
    }

    void initialize(Properties properties, HandshakeResponder handshakeResponder, int n, GnetConnectObserver gnetConnectObserver) throws IOException {
        handshakeResponder.setLocalePreferencing(this._useLocalPreference);
        if (this.isOutgoing()) {
            AsyncHandshakeConnecter asyncHandshakeConnecter = new AsyncHandshakeConnecter(properties, handshakeResponder, gnetConnectObserver);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getAddress(), this.getPort());
            Socket socket = this.socketsManager.connect(inetSocketAddress, n, asyncHandshakeConnecter, this.getConnectType());
            this.setSocket(socket);
        } else {
            this.startHandshake(properties, handshakeResponder, gnetConnectObserver);
        }
    }

    private void startHandshake(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) throws IOException {
        this.initializeHandshake();
        HandshakeWatcher handshakeWatcher = new HandshakeWatcher(gnetConnectObserver);
        Handshaker handshaker = this.isOutgoing() ? new AsyncOutgoingHandshaker(properties, handshakeResponder, this.getSocket(), handshakeWatcher) : new AsyncIncomingHandshaker(handshakeResponder, this.getSocket(), handshakeWatcher);
        handshakeWatcher.setHandshaker(handshaker);
        try {
            handshaker.shake();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
    }

    private void postHandshakeInitialize(Handshaker handshaker) {
        this.handshakeInitialized(handshaker);
        if (this.isWriteDeflated()) {
            this.deflater = new Deflater();
        }
        if (this.isReadDeflated()) {
            this.inflater = new Inflater();
        }
        this.getConnectionBandwidthStatistics().setCompressionOption(this.isWriteDeflated(), this.isReadDeflated(), new CompressionBandwidthTrackerImpl(this.inflater, this.deflater));
        this.startOutput();
    }

    @Override
    public void resetQueryRouteTable(ResetTableMessage resetTableMessage) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable(resetTableMessage.getTableSize(), resetTableMessage.getInfinity());
        } else {
            this._lastQRPTableReceived.reset(resetTableMessage);
        }
    }

    @Override
    public void patchQueryRouteTable(PatchTableMessage patchTableMessage) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable();
        }
        try {
            this._lastQRPTableReceived.patch(patchTableMessage);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
    }

    public void setBusy(boolean bl) {
        if (bl) {
            if (this._busyTime == -1L) {
                this._busyTime = System.currentTimeMillis();
            }
        } else {
            this._busyTime = -1L;
        }
    }

    private byte getHopsFlowMax() {
        return (byte)this.hopsFlowMax;
    }

    @Override
    public boolean isBusyLeaf() {
        if (!this.isSupernodeClientConnection()) {
            return false;
        }
        byte by = this.getHopsFlowMax();
        return by >= 0 && by < 3;
    }

    @Override
    public boolean shouldForwardQuery(QueryRequest queryRequest) {
        if (queryRequest.isFeatureQuery()) {
            if (this.isSupernodeClientConnection()) {
                return this.getConnectionCapabilities().getRemoteHostFeatureQuerySelector() >= queryRequest.getFeatureSelector();
            }
            if (this.getConnectionCapabilities().isSupernodeSupernodeConnection()) {
                return this.getConnectionCapabilities().getRemoteHostSupportsFeatureQueries();
            }
            return false;
        }
        return this.hitsQueryRouteTable(queryRequest);
    }

    protected boolean hitsQueryRouteTable(QueryRequest queryRequest) {
        if (this._lastQRPTableReceived == null) {
            return false;
        }
        return this._lastQRPTableReceived.contains(queryRequest);
    }

    @Override
    public QueryRouteTable getQueryRouteTableReceived() {
        return this._lastQRPTableReceived;
    }

    @Override
    public double getQueryRouteTablePercentFull() {
        return this._lastQRPTableReceived == null ? 0.0 : this._lastQRPTableReceived.getPercentFull();
    }

    @Override
    public int getQueryRouteTableSize() {
        return this._lastQRPTableReceived == null ? 0 : this._lastQRPTableReceived.getSize();
    }

    @Override
    public int getQueryRouteTableEmptyUnits() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getEmptyUnits();
    }

    @Override
    public int getQueryRouteTableUnitsInUse() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getUnitsInUse();
    }

    private void startOutput() {
        if (LimeWireUtils.isBetaRelease() || LimeWireUtils.isTestingVersion()) {
            this.statsWriters.put(StatsWriters.TOP, new StatisticGatheringWriter());
            this.statsWriters.put(StatsWriters.DEFLATER, new StatisticGatheringWriter());
            this.statsWriters.put(StatsWriters.DELAYER, new StatisticGatheringWriter());
            this.statsWriters.put(StatsWriters.THROTTLE, new StatisticGatheringWriter());
            this.outgoing = new Message.MessageCounter(10);
        } else {
            this.outgoing = new Message.MessageCounter(1);
        }
        CompositeQueue compositeQueue = new CompositeQueue();
        MessageWriter messageWriter = new MessageWriter(this._connectionStats, compositeQueue, this);
        this._outputRunner = messageWriter;
        ChannelWriter channelWriter = messageWriter;
        if (this.statsWriters.containsKey((Object)StatsWriters.TOP)) {
            channelWriter = this.addWriter(channelWriter, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.TOP));
        }
        if (this.isWriteDeflated()) {
            channelWriter = this.addWriter(channelWriter, new DeflaterWriter(this.deflater));
            if (this.statsWriters.containsKey((Object)StatsWriters.DEFLATER)) {
                channelWriter = this.addWriter(channelWriter, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.DEFLATER));
            }
        }
        channelWriter = this.addWriter(channelWriter, new DelayedBufferWriter(1400));
        if (this.statsWriters.containsKey((Object)StatsWriters.DELAYER)) {
            channelWriter = this.addWriter(channelWriter, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.DELAYER));
        }
        channelWriter = this.addWriter(channelWriter, new ThrottleWriter(_nbThrottle));
        if (this.statsWriters.containsKey((Object)StatsWriters.THROTTLE)) {
            channelWriter = this.addWriter(channelWriter, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.THROTTLE));
        }
        ((NIOMultiplexor)((Object)this.getSocket())).setWriteObserver(messageWriter);
    }

    private <T extends InterestWritableByteChannel & ChannelWriter> ChannelWriter addWriter(ChannelWriter channelWriter, T t) {
        channelWriter.setWriteChannel(t);
        return t;
    }

    @Override
    public void send(Message message) {
        int n = this.hopsFlowMax;
        if (n > -1 && message instanceof QueryRequest && message.getHops() >= n) {
            return;
        }
        this._outputRunner.send(message);
    }

    @Override
    public void originateQuery(QueryRequest queryRequest) {
        queryRequest.originate();
        if (LOG.isTraceEnabled()) {
            LOG.trace("do not proxy condition " + this.getConnectionCapabilities().isClientSupernodeConnection() + " " + (this.getConnectionCapabilities().getSupportedOOBProxyControlVersion() == -1) + " " + SearchSettings.DISABLE_OOB_V2.getValueAsString());
        }
        if (this.getConnectionCapabilities().isClientSupernodeConnection() && this.getConnectionCapabilities().getSupportedOOBProxyControlVersion() == -1 && SearchSettings.DISABLE_OOB_V2.getBoolean()) {
            queryRequest = this.queryRequestFactory.createDoNotProxyQuery(queryRequest);
            queryRequest.originate();
        }
        this.send(queryRequest);
    }

    @Override
    public void shutdown() {
        this.close();
    }

    @Override
    protected void closeImpl() {
        IOUtils.close(this.deflater);
        IOUtils.close(this.inflater);
        if (this._outputRunner != null) {
            this._outputRunner.shutdown();
        }
        this.guidMapManager.removeMap(this.guidMap);
    }

    @Override
    public void startMessaging() {
        this.incoming = new Message.MessageCounter(LimeWireUtils.isBetaRelease() ? 10 : 1);
        this.supernodeClientAtLooping = this.isSupernodeClientConnection();
        LOG.debug("Starting asynchronous connection");
        try {
            this.getSocket().setSoTimeout(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MessageReader messageReader = this.messageReaderFactory.createMessageReader(this);
        if (this.isReadDeflated()) {
            messageReader.setReadChannel(new InflaterReader(this.inflater));
        }
        ((NIOMultiplexor)((Object)this.getSocket())).setReadObserver(messageReader);
    }

    @Override
    public void messagingClosed() {
        if (this.connectionManager != null) {
            this.messageDispatcher.dispatch(new Runnable(){

                public void run() {
                    GnutellaConnection.this.connectionManager.remove(GnutellaConnection.this);
                }
            });
        }
    }

    @Override
    public void processReadMessage(Message message) {
        super.processReadMessage(message);
        this._connectionStats.addReceived();
        this.incoming.countMessage(message);
        this.handleMessageInternal(message);
    }

    @Override
    public void processSentMessage(Message message) {
        this.outgoing.countMessage(message);
        this.processWrittenMessage(message);
    }

    private void handleMessageInternal(Message message) {
        if (this.isSpam(message)) {
            this._connectionStats.addReceivedDropped();
        } else {
            if (message instanceof QueryReply) {
                QueryReply queryReply = (QueryReply)message;
                this._connectionStats.replyReceived(queryReply);
                if (message.getHops() == 0) {
                    this.clientGUID = queryReply.getClientGUID();
                }
                if (MessageSettings.RETURN_PATH_IN_REPLIES.getValue() && this.connectionManager.isActiveSupernode() && !queryReply.hasSecureData()) {
                    message = this.queryReplyFactory.createWithReturnPathInfo(queryReply, this.myIp == null ? null : new IpPortImpl(this.myIp, this.networkManager.getPort()), this);
                }
            }
            if (message instanceof QueryRequest) {
                this._connectionStats.queryReceived();
            }
            if (this.supernodeClientAtLooping) {
                if (message instanceof QueryRequest) {
                    message = this.tryToProxy((QueryRequest)message);
                } else if (message instanceof QueryStatusResponse) {
                    message = this.morphToStopQuery((QueryStatusResponse)message);
                }
            }
            this.messageDispatcher.dispatchTCP(message, this);
        }
    }

    @Override
    public long getNumQueryReplies() {
        return this._connectionStats.getRepliesReceived();
    }

    @Override
    public Message.Network getNetwork() {
        return Message.Network.TCP;
    }

    @Override
    public byte getSoftMax() {
        return super.getSoftMax();
    }

    private QueryRequest tryToProxy(QueryRequest queryRequest) {
        if (this.getConnectionCapabilities().remoteHostSupportsLeafGuidance() < 1) {
            return queryRequest;
        }
        if (queryRequest.desiresOutOfBandRepliesV3()) {
            return queryRequest;
        }
        if (queryRequest.doNotProxy()) {
            return queryRequest;
        }
        if (this._maxDisabledOOBProtocolVersion >= 3) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("query not proxied because disabled version is " + this._maxDisabledOOBProtocolVersion);
            }
            return queryRequest;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("query might be proxied for max disabled version " + this._maxDisabledOOBProtocolVersion + " " + Arrays.toString(queryRequest.getGUID()));
        }
        if (!(this.networkManager.isOOBCapable() && this.outOfBandStatistics.isSuccessRateGreat() && this.outOfBandStatistics.isOOBEffectiveForProxy())) {
            return queryRequest;
        }
        byte[] byArray = queryRequest.getGUID();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        GUID.addressEncodeGuid(byArray2, this.networkManager.getAddress(), this.networkManager.getPort());
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(byArray2);
        }
        queryRequest = this.queryRequestFactory.createProxyQuery(queryRequest, byArray2);
        this.guidMap.addMapping(byArray, byArray2);
        this.outOfBandStatistics.addSentQuery();
        return queryRequest;
    }

    private QueryStatusResponse morphToStopQuery(QueryStatusResponse queryStatusResponse) {
        GUID gUID = this.guidMap.getNewGUID(queryStatusResponse.getQueryGUID());
        if (gUID != null) {
            return new QueryStatusResponse(gUID, queryStatusResponse.getNumResults());
        }
        return queryStatusResponse;
    }

    boolean isSpam(Message message) {
        QueryReply queryReply;
        byte[] byArray;
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return !this._routeFilter.allow(message);
        }
        if (this.isSupernodeClientConnection() && message.getHops() != 0) {
            ++this.droppedBadHops;
            return true;
        }
        if (message instanceof QueryReply && message.getHops() == 0 && !this.networkInstanceUtils.isPrivateAddress(byArray = (queryReply = (QueryReply)message).getIPBytes()) && !queryReply.hasSecureData() && !Arrays.equals(byArray, this.getAddressBytes())) {
            ++this.droppedBadAddress;
            return true;
        }
        return !this._routeFilter.allow(message);
    }

    @Override
    public void countDroppedMessage() {
        this._connectionStats.addReceivedDropped();
    }

    @Override
    public boolean isPersonalSpam(Message message) {
        return !this._personalFilter.allow(message);
    }

    @Override
    public void setRouteFilter(SpamFilter spamFilter) {
        this._routeFilter = spamFilter;
    }

    @Override
    public void setPersonalFilter(SpamFilter spamFilter) {
        this._personalFilter = spamFilter;
    }

    @Override
    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        this.send(pingReply);
    }

    @Override
    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        byte[] byArray;
        boolean bl = true;
        if (this.guidMap != null && (byArray = this.guidMap.getOriginalGUID(queryReply.getGUID())) != null) {
            bl = false;
            byte by = queryReply.getHops();
            queryReply = this.queryReplyFactory.createQueryReply(byArray, queryReply);
            queryReply.setTTL((byte)2);
            queryReply.setHops(by);
        }
        if (bl && queryReply.isUDP() && !queryReply.isReplyToMulticastQuery()) {
            return;
        }
        if (this.myIp != null && queryReply.isLocal() && !this.networkInstanceUtils.isPrivateAddress(queryReply.getIPBytes()) && !queryReply.hasSecureData()) {
            queryReply = this.queryReplyFactory.createWithNewAddress(this.myIp, queryReply);
        }
        this.send(queryReply);
    }

    @Override
    public byte[] getClientGUID() {
        return this.clientGUID;
    }

    @Override
    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        this.send(pushRequest);
    }

    @Override
    public void handleVendorMessage(VendorMessage vendorMessage) {
        super.handleVendorMessage(vendorMessage);
        if (vendorMessage instanceof HopsFlowVendorMessage) {
            HopsFlowVendorMessage hopsFlowVendorMessage = (HopsFlowVendorMessage)vendorMessage;
            if (this.isSupernodeClientConnection()) {
                this.setBusy(hopsFlowVendorMessage.getHopValue() == 0);
            }
            this.hopsFlowMax = hopsFlowVendorMessage.getHopValue();
        } else if (vendorMessage instanceof PushProxyAcknowledgement) {
            PushProxyAcknowledgement pushProxyAcknowledgement = (PushProxyAcknowledgement)vendorMessage;
            if (Arrays.equals(pushProxyAcknowledgement.getGUID(), this.applicationServices.getMyGUID())) {
                this.myPushProxy = true;
            }
        } else if (vendorMessage instanceof CapabilitiesVM) {
            CapabilitiesVM capabilitiesVM = (CapabilitiesVM)vendorMessage;
            int n = this.updateHandler.get().getLatestId();
            int n2 = capabilitiesVM.supportsUpdate();
            if (!(n2 == -1 || this.receivedCapVM && n2 <= n)) {
                this.networkUpdateSanityChecker.handleNewRequest(this, NetworkUpdateSanityChecker.RequestType.VERSION);
                this.send(new UpdateRequest());
            } else if (n2 == n) {
                this.updateHandler.get().handleUpdateAvailable(this, n2);
            }
            this.receivedCapVM = true;
            this.connectionManager.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_CAPABILITIES, this));
        } else if (vendorMessage instanceof MessagesSupportedVendorMessage) {
            Object object;
            Object object2;
            if (this.getConnectionCapabilities().isClientSupernodeConnection() && this.getConnectionCapabilities().remoteHostSupportsLeafGuidance() >= 0) {
                object2 = this.searchResultHandler.getQueriesToReSend();
                object = object2.iterator();
                while (object.hasNext()) {
                    QueryRequest queryRequest = object.next();
                    this.send(queryRequest);
                }
            }
            if (this.getConnectionCapabilities().remoteHostSupportsPushProxy() > -1) {
                object2 = new GUID(this.applicationServices.getMyGUID());
                object = new PushProxyRequest((GUID)object2);
                this.send((Message)object);
            }
            if (!this.networkManager.canReceiveUnsolicited() && this.connectionManager.canSendConnectBack(Message.Network.UDP) && this.getConnectionCapabilities().remoteHostSupportsUDPRedirect() > -1) {
                object2 = this.networkManager.getUDPConnectBackGUID();
                object = new UDPConnectBackVendorMessage(this.networkManager.getPort(), (GUID)object2);
                this.send((Message)object);
                this.connectionManager.connectBackSent(Message.Network.UDP);
            }
            if (!this.networkManager.acceptedIncomingConnection() && this.connectionManager.canSendConnectBack(Message.Network.TCP) && this.getConnectionCapabilities().remoteHostSupportsTCPRedirect() > -1) {
                object2 = new TCPConnectBackVendorMessage(this.networkManager.getPort());
                this.send((Message)object2);
                this.connectionManager.connectBackSent(Message.Network.TCP);
            }
            if (this.getConnectionCapabilities().isClientSupernodeConnection() && SearchSettings.DISABLE_OOB_V2.getBoolean() && this.getConnectionCapabilities().getSupportedOOBProxyControlVersion() != -1) {
                object2 = new OOBProxyControlVendorMessage(OOBProxyControlVendorMessage.Control.DISABLE_VERSION_2);
                this.send((Message)object2);
            }
        } else if (vendorMessage instanceof OOBProxyControlVendorMessage) {
            this._maxDisabledOOBProtocolVersion = ((OOBProxyControlVendorMessage)vendorMessage).getMaximumDisabledVersion();
            if (LOG.isTraceEnabled()) {
                LOG.trace("_maxDisabledOOBProtocolVersion set to " + this._maxDisabledOOBProtocolVersion);
            }
        }
    }

    @Override
    public int getNumMessagesSent() {
        return this._connectionStats.getSent();
    }

    @Override
    public int getNumMessagesReceived() {
        return this._connectionStats.getReceived();
    }

    @Override
    public int getNumSentMessagesDropped() {
        return this._connectionStats.getSentDropped();
    }

    @Override
    public long getNumReceivedMessagesDropped() {
        return this._connectionStats.getReceivedDropped();
    }

    @Override
    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getConnectionBandwidthStatistics().getBytesSent()));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getConnectionBandwidthStatistics().getBytesReceived()));
    }

    @Override
    public float getMeasuredUpstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    @Override
    public float getMeasuredDownstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    @Override
    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    @Override
    public void incrementNextQRPForwardTime(long l) {
        this._nextQRPForwardTime = this.isLeafConnection() ? l + this.LEAF_QUERY_ROUTE_UPDATE_TIME : l + this.ULTRAPEER_QUERY_ROUTE_UPDATE_TIME;
    }

    @Override
    public boolean isKillable() {
        return this._isKillable;
    }

    @Override
    public QueryRouteTable getQueryRouteTableSent() {
        return this._lastQRPTableSent;
    }

    @Override
    public void setQueryRouteTableSent(QueryRouteTable queryRouteTable) {
        this._lastQRPTableSent = queryRouteTable;
    }

    @Override
    public boolean isMyPushProxy() {
        return this.myPushProxy;
    }

    @Override
    public boolean isPushProxyFor() {
        return this.pushProxyFor;
    }

    @Override
    public void setPushProxyFor(boolean bl) {
        this.pushProxyFor = bl;
    }

    @Override
    public Object getQRPLock() {
        return this.QRP_LOCK;
    }

    @Override
    public void setLocalePreferencing(boolean bl) {
        this._useLocalPreference = bl;
    }

    @Override
    public void reply(Message message) {
        this.send(message);
    }

    @Override
    public Map<String, Object> inspect() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("hfm", this.getHopsFlowMax());
        hashMap.put("mdb", Float.valueOf(this.getMeasuredDownstreamBandwidth()));
        hashMap.put("mub", Float.valueOf(this.getMeasuredUpstreamBandwidth()));
        hashMap.put("qrpft", this.getNextQRPForwardTime());
        hashMap.put("nmr", this.getNumMessagesReceived());
        hashMap.put("nms", this.getNumMessagesSent());
        this._connectionStats.addStats(hashMap);
        OutputRunner outputRunner = this._outputRunner;
        if (outputRunner != null) {
            hashMap.put("or", outputRunner.inspect());
        }
        hashMap.put("nrmd", this.getNumReceivedMessagesDropped());
        hashMap.put("nsmd", this.getNumSentMessagesDropped());
        hashMap.put("qrteu", this.getQueryRouteTableEmptyUnits());
        hashMap.put("qrtpf", this.getQueryRouteTablePercentFull());
        hashMap.put("qrts", this.getQueryRouteTableSize());
        hashMap.put("bl", this.isBusyLeaf());
        hashMap.put("k", this.isKillable());
        hashMap.put("pp", this.isPushProxyFor());
        hashMap.put("rhsi", this.getConnectionCapabilities().remoteHostSupportsInspections());
        hashMap.put("tlsc", this.isTLSCapable());
        hashMap.put("tlse", this.isTLSEncoded());
        hashMap.put("br", this.getConnectionBandwidthStatistics().getBytesReceived());
        hashMap.put("bs", this.getConnectionBandwidthStatistics().getBytesSent());
        hashMap.put("ct", this.getConnectionTime());
        hashMap.put("lp", this.getListeningPort());
        hashMap.put("lpref", this.getLocalePref());
        hashMap.put("ubr", this.getConnectionBandwidthStatistics().getUncompressedBytesReceived());
        hashMap.put("ubs", this.getConnectionBandwidthStatistics().getUncompressedBytesSent());
        hashMap.put("ua", this.getConnectionCapabilities().getUserAgent());
        hashMap.put("v", this.getConnectionCapabilities().getVersion());
        hashMap.put("pln", this.getConnectionCapabilities().remoteHostIsPassiveLeafNode());
        hashMap.put("pdn", this.getConnectionCapabilities().remostHostIsPassiveDHTNode());
        hashMap.put("pan", this.getConnectionCapabilities().remostHostIsActiveDHTNode());
        hashMap.put("myip", this.getConnectionCapabilities().getHeadersRead().props().getProperty("Remote-IP"));
        hashMap.put("cguid", this.getClientGUID());
        for (StatsWriters statsWriters : this.statsWriters.keySet()) {
            hashMap.put(statsWriters.toString(), this.statsWriters.get((Object)statsWriters).inspect());
        }
        hashMap.put("incoming", this.incoming.inspect());
        hashMap.put("outgoing", this.outgoing.inspect());
        hashMap.put("badHops", this.droppedBadHops);
        hashMap.put("badAddr", this.droppedBadAddress);
        return hashMap;
    }

    @Override
    public ConnectionRoutingStatistics getRoutedConnectionStatistics() {
        return this;
    }

    @Override
    public final boolean isGoodLeaf() {
        return this.getConnectionCapabilities().isGoodLeaf();
    }

    @Override
    public final boolean isGoodUltrapeer() {
        return this.getConnectionCapabilities().isGoodUltrapeer();
    }

    @Override
    public final boolean isHighDegreeConnection() {
        return this.getConnectionCapabilities().isHighDegreeConnection();
    }

    @Override
    public final boolean isLeafConnection() {
        return this.getConnectionCapabilities().isLeafConnection();
    }

    @Override
    public final boolean isSupernodeClientConnection() {
        return this.getConnectionCapabilities().isSupernodeClientConnection();
    }

    @Override
    public final boolean isUltrapeerQueryRoutingConnection() {
        return this.getConnectionCapabilities().isUltrapeerQueryRoutingConnection();
    }

    @Override
    public final boolean supportsPongCaching() {
        return this.getConnectionCapabilities().supportsPongCaching();
    }

    @Override
    public final ConnectionMessageStatistics getConnectionMessageStatistics() {
        return this;
    }

    private class HandshakeWatcher
    implements HandshakeObserver {
        private Handshaker shaker;
        private GnetConnectObserver observer;

        HandshakeWatcher(GnetConnectObserver gnetConnectObserver) {
            this.observer = gnetConnectObserver;
        }

        void setHandshaker(Handshaker handshaker) {
            this.shaker = handshaker;
        }

        public void shutdown() {
            GnutellaConnection.this.setHeaders(this.shaker.getReadHeaders(), this.shaker.getWrittenHeaders());
            GnutellaConnection.this.close();
            this.observer.shutdown();
        }

        public void handleHandshakeFinished(Handshaker handshaker) {
            GnutellaConnection.this.postHandshakeInitialize(handshaker);
            this.observer.handleConnect();
        }

        public void handleBadHandshake() {
            GnutellaConnection.this.setHeaders(this.shaker.getReadHeaders(), this.shaker.getWrittenHeaders());
            GnutellaConnection.this.close();
            this.observer.handleBadHandshake();
        }

        public void handleNoGnutellaOk(int n, String string) {
            GnutellaConnection.this.setHeaders(this.shaker.getReadHeaders(), this.shaker.getWrittenHeaders());
            GnutellaConnection.this.close();
            this.observer.handleNoGnutellaOk(n, string);
        }
    }

    private class AsyncHandshakeConnecter
    implements ConnectObserver {
        private Properties requestHeaders;
        private HandshakeResponder responder;
        private GnetConnectObserver observer;

        AsyncHandshakeConnecter(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) {
            this.requestHeaders = properties;
            this.responder = handshakeResponder;
            this.observer = gnetConnectObserver;
        }

        public void handleConnect(Socket socket) throws IOException {
            GnutellaConnection.this.setSocket(socket);
            GnutellaConnection.this.startHandshake(this.requestHeaders, this.responder, this.observer);
        }

        public void shutdown() {
            this.observer.shutdown();
        }

        public void handleIOException(IOException iOException) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StatsWriters {
        TOP,
        DEFLATER,
        DELAYER,
        THROTTLE;

    }
}

