/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionCapabilities;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;

public class ConnectionCapabilitiesImpl
implements ConnectionCapabilities {
    private volatile CapabilitiesVM capabilitiesVendorMessage;
    private volatile HandshakeResponse headersRead = HandshakeResponse.createEmptyResponse();
    private volatile HandshakeResponse headersWritten = HandshakeResponse.createEmptyResponse();
    private volatile MessagesSupportedVendorMessage messagesSupportedVendorMessage;

    public String getUserAgent() {
        return this.headersRead.getUserAgent();
    }

    public boolean isLimeWire() {
        return this.headersRead.isLimeWire();
    }

    public boolean isOldLimeWire() {
        return this.headersRead.isOldLimeWire();
    }

    public boolean isGoodUltrapeer() {
        return this.headersRead.isGoodUltrapeer();
    }

    public boolean isGoodLeaf() {
        return this.headersRead.isGoodLeaf();
    }

    public boolean supportsPongCaching() {
        return this.headersRead.supportsPongCaching();
    }

    public int getNumIntraUltrapeerConnections() {
        return this.headersRead.getNumIntraUltrapeerConnections();
    }

    public boolean isHighDegreeConnection() {
        return this.headersRead.isHighDegreeConnection();
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this.headersRead.isUltrapeerQueryRoutingConnection();
    }

    public boolean supportsProbeQueries() {
        return this.headersRead.supportsProbeQueries();
    }

    public boolean receivedHeaders() {
        return this.headersRead != HandshakeResponse.createEmptyResponse();
    }

    public HandshakeResponse getHeadersRead() {
        return this.headersRead;
    }

    public String getVersion() {
        return this.headersRead.getVersion();
    }

    public boolean isLeafConnection() {
        return this.headersRead.isLeaf();
    }

    public boolean isSupernodeConnection() {
        return this.headersRead.isUltrapeer();
    }

    public boolean isClientSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.headersWritten.props().getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isSupernodeSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.headersWritten.props().getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isGUESSUltrapeer() {
        return this.headersRead.isGUESSUltrapeer();
    }

    public boolean isSupernodeClientConnection() {
        if (!this.isLeafConnection()) {
            return false;
        }
        String string = this.headersWritten.props().getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        if (!Boolean.valueOf(string).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    @Deprecated
    public boolean supportsGGEP() {
        return this.headersRead.supportsGGEP();
    }

    public boolean isQueryRoutingEnabled() {
        return this.headersRead.isQueryRoutingEnabled();
    }

    public int supportsVendorMessage(byte[] byArray, int n) {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsMessage(byArray, n);
        }
        return -1;
    }

    public boolean supportsVMRouting() {
        if (this.headersRead != null) {
            return (double)this.headersRead.supportsVendorMessages() >= 0.2;
        }
        return false;
    }

    public int remoteHostSupportsUDPConnectBack() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsUDPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsTCPConnectBack() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsTCPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsUDPRedirect() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsUDPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsTCPRedirect() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsTCPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsUDPCrawling() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsUDPCrawling();
        }
        return -1;
    }

    public int remoteHostSupportsHopsFlow() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsHopsFlow();
        }
        return -1;
    }

    public int remoteHostSupportsPushProxy() {
        if (this.messagesSupportedVendorMessage != null && this.isClientSupernodeConnection()) {
            return this.messagesSupportedVendorMessage.supportsPushProxy();
        }
        return -1;
    }

    public int remoteHostSupportsLeafGuidance() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsLeafGuidance();
        }
        return -1;
    }

    public int remoteHostSupportsHeaderUpdate() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsHeaderUpdate();
        }
        return -1;
    }

    public int getSupportedOOBProxyControlVersion() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsOOBProxyingControl();
        }
        return -1;
    }

    public int remoteHostSupportsInspections() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsInspectionRequests();
        }
        return -1;
    }

    public boolean getRemoteHostSupportsFeatureQueries() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsFeatureQueries() > 0;
        }
        return false;
    }

    public int getRemoteHostFeatureQuerySelector() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsFeatureQueries();
        }
        return -1;
    }

    public boolean remoteHostSupportsWhatIsNew() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsWhatIsNew();
        }
        return false;
    }

    public int getRemoteHostUpdateVersion() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsUpdate();
        }
        return -1;
    }

    public int remostHostIsActiveDHTNode() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.isActiveDHTNode();
        }
        return -1;
    }

    public int remostHostIsPassiveDHTNode() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.isPassiveDHTNode();
        }
        return -1;
    }

    public int remoteHostIsPassiveLeafNode() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.isPassiveLeafNode();
        }
        return -1;
    }

    public int getCapability(ConnectionCapabilities.Capability capability) {
        if (this.capabilitiesVendorMessage != null) {
            switch (capability) {
                case TLS: {
                    return this.capabilitiesVendorMessage.supportsTLS();
                }
            }
            throw new IllegalArgumentException("unknown capability!");
        }
        return -1;
    }

    public HandshakeResponse getHeadersWritten() {
        return this.headersWritten;
    }

    public boolean isCapabilitiesVmSet() {
        return this.capabilitiesVendorMessage != null;
    }

    public void setCapabilitiesVendorMessage(CapabilitiesVM capabilitiesVM) {
        this.capabilitiesVendorMessage = capabilitiesVM;
    }

    public void setHeadersRead(HandshakeResponse handshakeResponse) {
        this.headersRead = handshakeResponse;
    }

    public void setHeadersWritten(HandshakeResponse handshakeResponse) {
        this.headersWritten = handshakeResponse;
    }

    public void setMessagesSupportedVendorMessage(MessagesSupportedVendorMessage messagesSupportedVendorMessage) {
        this.messagesSupportedVendorMessage = messagesSupportedVendorMessage;
    }
}

