/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.RemoteClientInfo;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;
import org.limewire.http.LimeHttpClient;
import org.limewire.http.SimpleLimeHttpClient;

final class ServletAccessor {
    private static final Log LOG = LogFactory.getLog(ServletAccessor.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String DEFAULT_SERVLET_URL = "http://doctor.frostwire.com/bug-manager";
    private final String SERVLET_URL;
    private final boolean ALLOW_NIO;

    ServletAccessor() {
        this(true);
    }

    ServletAccessor(boolean bl) {
        this(bl, DEFAULT_SERVLET_URL);
    }

    ServletAccessor(boolean bl, String string) {
        this.ALLOW_NIO = bl;
        this.SERVLET_URL = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized RemoteClientInfo getRemoteBugInfo(LocalClientInfo localClientInfo) {
        RemoteClientInfo remoteClientInfo = new RemoteClientInfo();
        HttpResponse httpResponse = null;
        LimeHttpClient limeHttpClient = this.ALLOW_NIO ? GuiCoreMediator.getLimeHttpClient() : new SimpleLimeHttpClient();
        try {
            List<NameValuePair> list = localClientInfo.getPostRequestParams();
            HttpPost httpPost = new HttpPost(this.SERVLET_URL);
            httpPost.addHeader("Cache-Control", "no-cache");
            httpPost.addHeader("User-Agent", LimeWireUtils.getHttpServer());
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpPost.setEntity(new UrlEncodedFormEntity(list));
            HttpConnectionParams.setConnectionTimeout(limeHttpClient.getParams(), 10000);
            HttpClientParams.setRedirecting(limeHttpClient.getParams(), false);
            httpResponse = limeHttpClient.execute(httpPost);
            String string = httpResponse.getEntity() != null ? EntityUtils.toString(httpResponse.getEntity()) : null;
            String string2 = string;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got response: " + httpResponse);
            }
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                remoteClientInfo.addRemoteInfo(string2);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Servlet connect failed, code: " + httpResponse.getStatusLine().getStatusCode());
                }
                remoteClientInfo.connectFailed();
            }
            limeHttpClient.releaseConnection(httpResponse);
        }
        catch (IOException iOException) {
            this.fail(remoteClientInfo, iOException);
        }
        finally {
            limeHttpClient.releaseConnection(httpResponse);
        }
        return remoteClientInfo;
    }

    private void fail(RemoteClientInfo remoteClientInfo, Throwable throwable) {
        LOG.error("Error connecting to bug servlet", throwable);
        remoteClientInfo.connectFailed();
    }
}

