/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.LocalAbstractInfo;
import com.limegroup.gnutella.bugs.SessionInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.limewire.mojito.settings.MojitoProps;
import org.limewire.nio.NIODispatcher;
import org.limewire.setting.AbstractSetting;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalClientInfo
extends LocalAbstractInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalClientInfo(Throwable throwable, String string, String string2, boolean bl, SessionInfo sessionInfo) {
        Thread[] threadArray;
        this._limewireVersion = LimeWireUtils.getLimeWireVersion();
        this._javaVersion = VersionUtils.getJavaVersion();
        this._javaVendor = this.prop("java.vendor");
        this._os = OSUtils.getOS();
        this._osVersion = this.prop("os.version");
        this._architecture = this.prop("os.arch");
        this._freeMemory = "" + Runtime.getRuntime().freeMemory();
        this._totalMemory = "" + Runtime.getRuntime().totalMemory();
        this._peakThreads = "" + ManagementFactory.getThreadMXBean().getPeakThreadCount();
        this._loadAverage = LocalClientInfo.getLoadAvg();
        this._pendingObjects = "" + ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
        this._heapUsage = "" + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this._nonHeapUsage = "" + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        this._settingsFreeSpace = LocalClientInfo.getFreeSpace(CommonUtils.getUserSettingsDir());
        this._incompleteFreeSpace = LocalClientInfo.getFreeSpace(SharingSettings.INCOMPLETE_DIRECTORY.getValue());
        this._downloadFreeSpace = LocalClientInfo.getFreeSpace(SharingSettings.getSaveDirectory());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        this._bug = stringWriter.toString();
        this._currentThread = string;
        this._bugName = throwable.getClass().getName();
        this._fatalError = "" + bl;
        stringWriter = new StringWriter();
        printWriter = new PrintWriter(stringWriter);
        Properties properties = new Properties();
        Object[] objectArray = threadArray = LimeProps.instance().getFactory();
        synchronized (threadArray) {
            for (AbstractSetting object2 : threadArray) {
                if (object2.isPrivate() || object2.isDefault()) continue;
                properties.put(object2.getKey(), object2.getValueAsString());
            }
            // ** MonitorExit[objectArray /* !! */ ] (shouldn't be in output)
            objectArray = threadArray = MojitoProps.instance().getFactory();
            synchronized (threadArray) {
                for (AbstractSetting abstractSetting : threadArray) {
                    if (abstractSetting.isPrivate() || abstractSetting.isDefault()) continue;
                    properties.put(abstractSetting.getKey(), abstractSetting.getValueAsString());
                }
                // ** MonitorExit[objectArray /* !! */ ] (shouldn't be in output)
                properties.list(printWriter);
                printWriter.flush();
                this._props = stringWriter.toString();
                if (GUIMediator.isConstructed() && GuiCoreMediator.getCore() != null && GuiCoreMediator.getLifecycleManager().isLoaded()) {
                    this._upTime = CommonUtils.seconds2time((int)(sessionInfo.getCurrentUptime() / 1000L));
                    this._connected = "" + GuiCoreMediator.getConnectionServices().isConnected();
                    this._upToUp = "" + sessionInfo.getNumUltrapeerToUltrapeerConnections();
                    this._upToLeaf = "" + sessionInfo.getNumUltrapeerToLeafConnections();
                    this._leafToUp = "" + sessionInfo.getNumLeafToUltrapeerConnections();
                    this._oldConnections = "" + sessionInfo.getNumOldConnections();
                    this._ultrapeer = "" + GuiCoreMediator.getConnectionServices().isSupernode();
                    this._leaf = "" + GuiCoreMediator.getConnectionServices().isShieldedLeaf();
                    this._activeUploads = "" + GuiCoreMediator.getUploadServices().getNumUploads();
                    this._queuedUploads = "" + GuiCoreMediator.getUploadServices().getNumQueuedUploads();
                    this._activeDownloads = "" + GuiCoreMediator.getDownloadServices().getNumActiveDownloads();
                    this._httpDownloaders = "" + sessionInfo.getNumIndividualDownloaders();
                    this._waitingDownloaders = "" + sessionInfo.getNumWaitingDownloads();
                    this._acceptedIncoming = "" + sessionInfo.acceptedIncomingConnection();
                    this._sharedFiles = "" + GuiCoreMediator.getFileManager().getNumFiles();
                    this._guessCapable = "" + sessionInfo.isGUESSCapable();
                    this._solicitedCapable = "" + sessionInfo.canReceiveSolicited();
                    this._portStable = "" + GuiCoreMediator.getUdpService().portStable();
                    this._canDoFWT = "" + GuiCoreMediator.getUdpService().canDoFWT();
                    this._lastReportedPort = "" + GuiCoreMediator.getUdpService().lastReportedPort();
                    this._externalPort = "" + sessionInfo.getPort();
                    this._receivedIpPong = "" + GuiCoreMediator.getUdpService().receivedIpPong();
                    this._responseSize = "" + sessionInfo.getContentResponsesSize();
                    this._creationCacheSize = "" + sessionInfo.getCreationCacheSize();
                    this._vfByteSize = "" + sessionInfo.getDiskControllerByteCacheSize();
                    this._vfVerifyingSize = "" + sessionInfo.getDiskControllerVerifyingCacheSize();
                    this._bbSize = "" + sessionInfo.getByteBufferCacheSize();
                    this._vfQueueSize = "" + sessionInfo.getDiskControllerQueueSize();
                    this._waitingSockets = "" + sessionInfo.getNumberOfWaitingSockets();
                    this._pendingTimeouts = "" + sessionInfo.getNumberOfPendingTimeouts();
                    this._sp2Workarounds = "" + GuiCoreMediator.getConnectionCheckerManager().getNumWorkarounds();
                    this._slotManager = "" + GuiCoreMediator.getUploadSlotManager();
                    objectArray = NIODispatcher.instance().getSelectStats();
                    this._numSelects = "" + (long)objectArray[0];
                    this._numImmediateSelects = "" + (long)objectArray[1];
                    this._avgSelectTime = "" + (long)objectArray[2];
                }
                this._detail = string2;
                objectArray = new Thread[Thread.activeCount()];
                int n = Thread.enumerate(objectArray);
                this._threadCount = "" + n;
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (int i = 0; i < n; ++i) {
                    String string3 = objectArray[i].getName();
                    Integer n2 = (Integer)hashMap.get(string3);
                    if (n2 == null) {
                        hashMap.put(string3, new Integer(1));
                        continue;
                    }
                    int n3 = n2 + 1;
                    hashMap.put(string3, new Integer(n3));
                }
                stringWriter = new StringWriter();
                printWriter = new PrintWriter(stringWriter);
                for (Map.Entry entry : hashMap.entrySet()) {
                    printWriter.println((String)entry.getKey() + ": " + entry.getValue());
                }
                printWriter.flush();
                this._otherThreads = stringWriter.toString();
                return;
            }
        }
    }

    private static String getFreeSpace(File file) {
        return LocalClientInfo.invoke16Method(file, File.class, "getUsableSpace", Long.class);
    }

    private static String getLoadAvg() {
        return LocalClientInfo.invoke16Method(ManagementFactory.getOperatingSystemMXBean(), OperatingSystemMXBean.class, "getSystemLoadAverage", Double.class);
    }

    private static String invoke16Method(Object object, Class<?> clazz, String string, Class<?> clazz2) {
        if (!VersionUtils.isJava16OrAbove()) {
            return "-1";
        }
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 == null) {
                return "-7";
            }
            if (!clazz2.isAssignableFrom(object2.getClass())) {
                return "-5";
            }
            return object2.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return "-2";
        }
        catch (IllegalAccessException illegalAccessException) {
            return "-3";
        }
        catch (InvocationTargetException invocationTargetException) {
            return "-4";
        }
        catch (Throwable throwable) {
            return "-6";
        }
    }

    private final String prop(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return "?";
        }
        return string2;
    }

    public final List<NameValuePair> getPostRequestParams() {
        LinkedList<NameValuePair> linkedList = new LinkedList<NameValuePair>();
        this.append(linkedList, "1", this._limewireVersion);
        this.append(linkedList, "2", this._javaVersion);
        this.append(linkedList, "3", this._os);
        this.append(linkedList, "4", this._osVersion);
        this.append(linkedList, "5", this._architecture);
        this.append(linkedList, "6", this._freeMemory);
        this.append(linkedList, "7", this._totalMemory);
        this.append(linkedList, "8", this._bug);
        this.append(linkedList, "9", this._currentThread);
        this.append(linkedList, "10", this._props);
        this.append(linkedList, "11", this._upTime);
        this.append(linkedList, "12", this._connected);
        this.append(linkedList, "13", this._upToUp);
        this.append(linkedList, "14", this._upToLeaf);
        this.append(linkedList, "15", this._leafToUp);
        this.append(linkedList, "16", this._oldConnections);
        this.append(linkedList, "17", this._ultrapeer);
        this.append(linkedList, "18", this._leaf);
        this.append(linkedList, "19", this._activeUploads);
        this.append(linkedList, "20", this._queuedUploads);
        this.append(linkedList, "21", this._activeDownloads);
        this.append(linkedList, "22", this._httpDownloaders);
        this.append(linkedList, "23", this._waitingDownloaders);
        this.append(linkedList, "24", this._acceptedIncoming);
        this.append(linkedList, "25", this._sharedFiles);
        this.append(linkedList, "26", this._otherThreads);
        this.append(linkedList, "27", this._detail);
        this.append(linkedList, "28", this._otherBug);
        this.append(linkedList, "29", this._javaVendor);
        this.append(linkedList, "30", this._threadCount);
        this.append(linkedList, "31", this._bugName);
        this.append(linkedList, "32", this._guessCapable);
        this.append(linkedList, "33", this._solicitedCapable);
        this.append(linkedList, "34", this._latestSIMPP);
        this.append(linkedList, "36", this._portStable);
        this.append(linkedList, "37", this._canDoFWT);
        this.append(linkedList, "38", this._lastReportedPort);
        this.append(linkedList, "39", this._externalPort);
        this.append(linkedList, "40", this._receivedIpPong);
        this.append(linkedList, "41", this._fatalError);
        this.append(linkedList, "42", this._responseSize);
        this.append(linkedList, "43", this._creationCacheSize);
        this.append(linkedList, "45", this._vfByteSize);
        this.append(linkedList, "44", this._vfVerifyingSize);
        this.append(linkedList, "46", this._bbSize);
        this.append(linkedList, "47", this._vfQueueSize);
        this.append(linkedList, "48", this._waitingSockets);
        this.append(linkedList, "49", this._pendingTimeouts);
        this.append(linkedList, "50", this._peakThreads);
        this.append(linkedList, "51", this._sp2Workarounds);
        this.append(linkedList, "52", this._loadAverage);
        this.append(linkedList, "53", this._pendingObjects);
        this.append(linkedList, "54", this._settingsFreeSpace);
        this.append(linkedList, "55", this._incompleteFreeSpace);
        this.append(linkedList, "56", this._downloadFreeSpace);
        this.append(linkedList, "57", this._heapUsage);
        this.append(linkedList, "58", this._nonHeapUsage);
        this.append(linkedList, "59", this._slotManager);
        this.append(linkedList, "60", this._numSelects);
        this.append(linkedList, "61", this._numImmediateSelects);
        this.append(linkedList, "62", this._avgSelectTime);
        this.append(linkedList, "63", this._userComments);
        return linkedList;
    }

    public String getShortParamList() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        for (NameValuePair nameValuePair : this.getPostRequestParams()) {
            stringBuilder.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    private final void append(List<? super NameValuePair> list, String string, String string2) {
        if (string2 != null) {
            list.add(new BasicNameValuePair(string, string2));
        }
    }
}

