/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.google.inject.Inject;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.auth.IpPortContentAuthority;
import com.limegroup.gnutella.auth.IpPortContentAuthorityFactory;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ContentSettings;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import org.limewire.io.IpPortImpl;

public class SettingsBasedContentAuthority
implements ContentAuthority {
    private ContentAuthority[] authorities;
    private Random RNG = this.newRandom();
    private final IpPortContentAuthorityFactory ipPortContentAuthorityFactory;

    @Inject
    public SettingsBasedContentAuthority(IpPortContentAuthorityFactory ipPortContentAuthorityFactory) {
        this.ipPortContentAuthorityFactory = ipPortContentAuthorityFactory;
    }

    public boolean initialize() {
        String[] stringArray = ContentSettings.AUTHORITIES.getValue();
        ArrayList<IpPortContentAuthority> arrayList = new ArrayList<IpPortContentAuthority>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(this.ipPortContentAuthorityFactory.createIpPortContentAuthority(new IpPortImpl(stringArray[i])));
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.authorities = arrayList.toArray(new ContentAuthority[arrayList.size()]);
        return !arrayList.isEmpty();
    }

    public ContentAuthority[] getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(ContentAuthority[] contentAuthorityArray) {
        this.authorities = contentAuthorityArray;
    }

    public void send(Message message) {
        int n = this.RNG.nextInt(this.authorities.length);
        this.authorities[n].send(message);
    }

    protected Random newRandom() {
        return new Random();
    }
}

