/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrnSet
implements Set<URN>,
Iterable<URN>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1065284624401321676L;
    private URN sha1;
    private URN ttroot;

    public UrnSet() {
    }

    public UrnSet(URN uRN) {
        this.add(uRN);
    }

    public UrnSet(Collection<? extends URN> collection) {
        this.addAll(collection);
    }

    public String toString() {
        return this.isEmpty() ? "{Empty UrnSet}" : "UrnSet of: " + this.sha1;
    }

    public UrnSet clone() {
        UrnSet urnSet = new UrnSet();
        urnSet.sha1 = this.sha1;
        return urnSet;
    }

    @Override
    public int hashCode() {
        return this.sha1 == null ? 0 : this.sha1.hashCode();
    }

    URN getSHA1() {
        return this.sha1;
    }

    URN getTTRoot() {
        return this.ttroot;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (collection.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(collection);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public boolean add(URN uRN) {
        if (uRN.isSHA1() && this.sha1 == null) {
            this.sha1 = uRN;
            return true;
        }
        if (uRN.isTTRoot() && this.ttroot == null) {
            this.ttroot = uRN;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends URN> collection) {
        boolean bl = false;
        for (URN uRN : collection) {
            bl |= this.add(uRN);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.sha1 = null;
        this.ttroot = null;
    }

    @Override
    public boolean contains(Object object) {
        return object.equals(this.sha1) || object.equals(this.ttroot);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.size() > 2) {
            return false;
        }
        if (collection.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean bl = true;
        for (Object obj : collection) {
            bl &= this.contains(obj);
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.sha1 == null && this.ttroot == null;
    }

    @Override
    public Iterator<URN> iterator() {
        return new UrnIterator();
    }

    @Override
    public boolean remove(Object object) {
        if (this.sha1 != null && object.equals(this.sha1)) {
            this.sha1 = null;
            return true;
        }
        if (this.ttroot != null && object.equals(this.ttroot)) {
            this.ttroot = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.sha1 == null && this.ttroot == null || collection.isEmpty()) {
            return false;
        }
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
            if (!this.isEmpty()) continue;
            break;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        if (this.sha1 != null && !collection.contains(this.sha1)) {
            this.sha1 = null;
            bl = true;
        }
        if (this.ttroot != null && !collection.contains(this.ttroot)) {
            this.ttroot = null;
            bl = true;
        }
        return bl;
    }

    @Override
    public int size() {
        int n = 0;
        if (this.sha1 != null) {
            ++n;
        }
        if (this.ttroot != null) {
            ++n;
        }
        return n;
    }

    @Override
    public Object[] toArray() {
        switch (this.size()) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                URN uRN = this.sha1 != null ? this.sha1 : this.ttroot;
                return new Object[]{uRN};
            }
            case 2: {
                return new Object[]{this.sha1, this.ttroot};
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        switch (n) {
            case 1: {
                URN uRN = this.sha1 != null ? this.sha1 : this.ttroot;
                objectArray[0] = uRN;
                break;
            }
            case 2: {
                objectArray[0] = this.sha1;
                objectArray[1] = this.ttroot;
            }
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UrnIterator
    implements Iterator<URN> {
        private boolean givenSHA1;
        private boolean givenTTRoot;

        private UrnIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.givenSHA1 && UrnSet.this.sha1 != null || !this.givenTTRoot && UrnSet.this.ttroot != null;
        }

        @Override
        public URN next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.givenSHA1 && UrnSet.this.sha1 != null) {
                this.givenSHA1 = true;
                return UrnSet.this.sha1;
            }
            if (!this.givenTTRoot && UrnSet.this.ttroot != null) {
                this.givenTTRoot = true;
                return UrnSet.this.ttroot;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (!this.givenSHA1 && !this.givenTTRoot) {
                throw new IllegalStateException();
            }
            if (this.givenTTRoot) {
                UrnSet.this.ttroot = null;
            } else if (this.givenSHA1) {
                UrnSet.this.sha1 = null;
            }
        }
    }
}

