/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.filters.SpamFilter;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@Singleton
public class UDPReplyHandlerFactoryImpl
implements UDPReplyHandlerFactory {
    private final UDPService udpService;

    @Inject
    public UDPReplyHandlerFactoryImpl(UDPService uDPService) {
        this.udpService = uDPService;
    }

    public UDPReplyHandler createUDPReplyHandler(InetSocketAddress inetSocketAddress, SpamFilter spamFilter) {
        return new UDPReplyHandler(inetSocketAddress, spamFilter, this.udpService);
    }

    public UDPReplyHandler createUDPReplyHandler(InetAddress inetAddress, int n, SpamFilter spamFilter) {
        return new UDPReplyHandler(inetAddress, n, spamFilter, this.udpService);
    }
}

