/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.MultiIterable;
import org.limewire.inspection.Inspectable;
import org.limewire.util.Base32;

public final class RouteTable
implements Inspectable {
    private Map<byte[], RouteTableEntry> _newMap = new ExperimentalGUIDMap();
    private Map<byte[], RouteTableEntry> _oldMap = new ExperimentalGUIDMap();
    private int _mseconds;
    private long _nextSwitchTime;
    private int _maxSize;
    private Map<Integer, ReplyHandler> _idMap = new HashMap<Integer, ReplyHandler>();
    private Map<ReplyHandler, Integer> _handlerMap = new HashMap<ReplyHandler, Integer>();
    private int _nextID;

    public RouteTable(int n, int n2) {
        this._mseconds = n * 1000;
        this._nextSwitchTime = System.currentTimeMillis() + (long)this._mseconds;
        this._maxSize = n2;
    }

    public synchronized ResultCounter routeReply(byte[] byArray, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        if (replyHandler == null) {
            throw new NullPointerException("null reply handler");
        }
        if (!replyHandler.isOpen()) {
            return null;
        }
        int n = this.handler2id(replyHandler);
        RouteTableEntry routeTableEntry = this._newMap.remove(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = this._oldMap.remove(byArray);
        }
        if (routeTableEntry == null) {
            routeTableEntry = new RouteTableEntry(n);
        } else {
            routeTableEntry.handlerID = n;
        }
        this._newMap.put(byArray, routeTableEntry);
        return routeTableEntry;
    }

    public synchronized ResultCounter tryToRouteReply(byte[] byArray, ReplyHandler replyHandler) {
        this.repOk();
        this.purge();
        assert (replyHandler != null);
        assert (byArray != null) : "Null GUID in tryToRouteReply";
        if (!replyHandler.isOpen()) {
            return null;
        }
        if (!this._newMap.containsKey(byArray) && !this._oldMap.containsKey(byArray)) {
            int n = this.handler2id(replyHandler);
            RouteTableEntry routeTableEntry = new RouteTableEntry(n);
            this._newMap.put(byArray, routeTableEntry);
            return routeTableEntry;
        }
        return null;
    }

    public synchronized void setTTL(ResultCounter resultCounter, byte by) {
        if (resultCounter == null) {
            throw new IllegalArgumentException("Null entry!!");
        }
        if (!(resultCounter instanceof RouteTableEntry)) {
            throw new IllegalArgumentException("entry is not recognized.");
        }
        if (by <= 0) {
            throw new IllegalArgumentException("Input TTL too small: " + by);
        }
        ((RouteTableEntry)resultCounter).setTTL(by);
    }

    public synchronized boolean getAndSetTTL(byte[] byArray, byte by, byte by2) {
        if (by < 1 || by2 <= by) {
            throw new IllegalArgumentException("Bad ttl input (get/set): " + by + "/" + by2);
        }
        RouteTableEntry routeTableEntry = this._newMap.get(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = this._oldMap.get(byArray);
        }
        if (routeTableEntry != null && routeTableEntry.getTTL() == by) {
            routeTableEntry.setTTL(by2);
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] byArray) {
        this.repOk();
        RouteTableEntry routeTableEntry = this._newMap.get(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = this._oldMap.get(byArray);
        }
        return routeTableEntry == null ? null : this.id2handler(new Integer(routeTableEntry.handlerID));
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] byArray, int n, short s, short s2) {
        return this.getReplyHandler(byArray, n, s, s2, 0);
    }

    public synchronized ReplyRoutePair getReplyHandler(byte[] byArray, int n, short s, short s2, int n2) {
        this.repOk();
        RouteTableEntry routeTableEntry = this._newMap.get(byArray);
        if (routeTableEntry == null) {
            routeTableEntry = this._oldMap.get(byArray);
        }
        if (routeTableEntry == null) {
            return null;
        }
        ReplyHandler replyHandler = this.id2handler(new Integer(routeTableEntry.handlerID));
        if (replyHandler == null) {
            return null;
        }
        ReplyRoutePair replyRoutePair = new ReplyRoutePair(replyHandler, routeTableEntry.bytesRouted, routeTableEntry.repliesRouted);
        routeTableEntry.bytesRouted += n;
        routeTableEntry.repliesRouted += s;
        routeTableEntry.partialRepliesRouted += s2;
        if (n2 != 0) {
            routeTableEntry.updateClassCNetworks(n2, s);
        }
        return replyRoutePair;
    }

    public synchronized void timeStampResults(QueryReply queryReply) {
        RouteTableEntry routeTableEntry = this._newMap.get(queryReply.getGUID());
        if (routeTableEntry == null) {
            routeTableEntry = this._oldMap.get(queryReply.getGUID());
        }
        if (routeTableEntry == null) {
            return;
        }
        routeTableEntry.timeStampResults(queryReply.getUniqueResultCount());
    }

    public synchronized void countHopsTTLNet(QueryReply queryReply) {
        RouteTableEntry routeTableEntry = this._newMap.get(queryReply.getGUID());
        if (routeTableEntry == null) {
            routeTableEntry = this._oldMap.get(queryReply.getGUID());
        }
        if (routeTableEntry == null) {
            return;
        }
        routeTableEntry.countHopsTTLNet(queryReply.getNetwork(), queryReply.getHops(), queryReply.getTTL());
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        this.repOk();
        assert (replyHandler != null) : "Null replyHandler in removeReplyHandler";
        Integer n = this.handler2id(replyHandler);
        this._idMap.remove(n);
        this._handlerMap.remove(replyHandler);
    }

    private Integer handler2id(ReplyHandler replyHandler) {
        Integer n = this._handlerMap.get(replyHandler);
        if (n != null) {
            return n;
        }
        while (this._idMap.get(n = new Integer(this._nextID++)) != null) {
        }
        this._handlerMap.put(replyHandler, n);
        this._idMap.put(n, replyHandler);
        return n;
    }

    private ReplyHandler id2handler(Integer n) {
        return this._idMap.get(n);
    }

    private final boolean purge() {
        long l = System.currentTimeMillis();
        if (l < this._nextSwitchTime && this._newMap.size() < this._maxSize) {
            return false;
        }
        this._oldMap.clear();
        Map<byte[], RouteTableEntry> map = this._oldMap;
        this._oldMap = this._newMap;
        this._newMap = map;
        this._nextSwitchTime = l + (long)this._mseconds;
        return true;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        TreeMap<byte[], RouteTableEntry> treeMap = new TreeMap<byte[], RouteTableEntry>(new GUID.GUIDByteComparator());
        treeMap.putAll(this._oldMap);
        treeMap.putAll(this._newMap);
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            stringBuilder.append(new GUID(byArray));
            stringBuilder.append("->");
            int n = ((RouteTableEntry)treeMap.get(byArray)).handlerID;
            ReplyHandler replyHandler = this.id2handler(new Integer(n));
            stringBuilder.append(replyHandler == null ? "null" : replyHandler.toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private final void repOk() {
    }

    private static final byte[] zeroOOBBytes(byte[] byArray) {
        if (!MessageSettings.GUID_ZERO_EXPERIMENT.getValue()) {
            return byArray;
        }
        byArray = (byte[])byArray.clone();
        for (int n : new int[]{0, 1, 2, 3, 13, 14}) {
            byArray[n] = 0;
        }
        return byArray;
    }

    public Object inspect() {
        HashMap<String, Object> hashMap;
        Object object;
        HashMap hashMap2 = new HashMap();
        MultiIterable<Map.Entry<byte[], RouteTableEntry>> multiIterable = new MultiIterable<Map.Entry<byte[], RouteTableEntry>>((Iterable<Map.Entry<byte[], RouteTableEntry>>)this._newMap.entrySet(), (Iterable<Map.Entry<byte[], RouteTableEntry>>)this._oldMap.entrySet());
        for (Map.Entry entry : multiIterable) {
            object = (RouteTableEntry)entry.getValue();
            hashMap = new HashMap<String, Object>();
            hashMap.put("br", ((RouteTableEntry)object).bytesRouted);
            hashMap.put("ttl", ((RouteTableEntry)object).ttl);
            hashMap.put("rr", ((RouteTableEntry)object).repliesRouted);
            hashMap.put("prr", ((RouteTableEntry)object).partialRepliesRouted);
            hashMap.put("cc", ((RouteTableEntry)object).classCnetworks.getMap());
            hashMap.put("rt", ((RouteTableEntry)object).resultTimeStamps);
            hashMap.put("rc", ((RouteTableEntry)object).resultCounts);
            hashMap.put("ct", ((RouteTableEntry)object).creationTime);
            hashMap.put("id", ((RouteTableEntry)object).handlerID);
            hashMap.put("nets", this.getBytes(((RouteTableEntry)object).networks));
            hashMap.put("hops", this.getBytes(((RouteTableEntry)object).hops));
            hashMap.put("ttls", this.getBytes(((RouteTableEntry)object).ttls));
            hashMap2.put(Base32.encode((byte[])entry.getKey()), hashMap);
        }
        Iterator<Object> iterator = this._idMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            object = this._idMap.get(n);
            hashMap = new HashMap();
            hashMap.put("ip", object.getAddress());
            hashMap.put("port", object.getPort());
            hashMap.put("cguid", object.getClientGUID());
            hashMap2.put(String.valueOf(n), hashMap);
        }
        return hashMap2;
    }

    private byte[] getBytes(int[] nArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(nArray.length * 4);
        byteBuffer.asIntBuffer().put(nArray);
        return byteBuffer.array();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExperimentalGUIDMap
    extends TreeMap<byte[], RouteTableEntry> {
        ExperimentalGUIDMap() {
            super(new GUID.GUIDByteComparator());
        }

        @Override
        public boolean containsKey(Object object) {
            if (object instanceof byte[]) {
                object = RouteTable.zeroOOBBytes((byte[])object);
            }
            return super.containsKey(object);
        }

        @Override
        public RouteTableEntry get(Object object) {
            if (object instanceof byte[]) {
                object = RouteTable.zeroOOBBytes((byte[])object);
            }
            return (RouteTableEntry)super.get(object);
        }

        @Override
        public RouteTableEntry put(byte[] byArray, RouteTableEntry routeTableEntry) {
            byArray = RouteTable.zeroOOBBytes(byArray);
            return super.put(byArray, routeTableEntry);
        }

        @Override
        public RouteTableEntry remove(Object object) {
            if (object instanceof byte[]) {
                object = RouteTable.zeroOOBBytes((byte[])object);
            }
            return (RouteTableEntry)super.remove(object);
        }
    }

    public static final class ReplyRoutePair {
        private final ReplyHandler handler;
        private final int volume;
        private final int REPLIES_ROUTED;

        ReplyRoutePair(ReplyHandler replyHandler, int n, int n2) {
            this.handler = replyHandler;
            this.volume = n;
            this.REPLIES_ROUTED = n2;
        }

        public ReplyHandler getReplyHandler() {
            return this.handler;
        }

        public int getBytesRouted() {
            return this.volume;
        }

        public int getResultsRouted() {
            return this.REPLIES_ROUTED;
        }
    }

    private static final class RouteTableEntry
    implements ResultCounter {
        private int handlerID;
        private int bytesRouted;
        private int repliesRouted;
        private int partialRepliesRouted;
        private byte ttl = 0;
        private final ClassCNetworks classCnetworks = new ClassCNetworks();
        private final long creationTime = System.currentTimeMillis();
        private final List<Double> resultTimeStamps = new ArrayList<Double>();
        private final List<Double> resultCounts = new ArrayList<Double>();
        private final int[] networks = new int[4];
        private final int[] hops = new int[5];
        private final int[] ttls = new int[5];

        RouteTableEntry(int n) {
            this.handlerID = n;
            this.bytesRouted = 0;
            this.repliesRouted = 0;
        }

        public void setTTL(byte by) {
            this.ttl = by;
        }

        public byte getTTL() {
            return this.ttl;
        }

        public int getNumResults() {
            return Math.max(0, this.repliesRouted - this.partialRepliesRouted);
        }

        void updateClassCNetworks(int n, int n2) {
            this.classCnetworks.add(n, n2);
        }

        void timeStampResults(int n) {
            this.resultTimeStamps.add(Double.valueOf(System.currentTimeMillis() - this.creationTime));
            this.resultCounts.add(Double.valueOf(n));
        }

        void countHopsTTLNet(Message.Network network, byte by, byte by2) {
            int n = Math.max(0, Math.min(network.ordinal(), this.networks.length - 1));
            this.networks[n] = this.networks[n] + 1;
            int n2 = Math.min(this.hops.length - 1, Math.max(0, by - 1));
            this.hops[n2] = this.hops[n2] + 1;
            int n3 = Math.min(this.ttls.length - 1, Math.max(0, by2 - 1));
            this.ttls[n3] = this.ttls[n3] + 1;
        }
    }
}

