/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Set;
import org.limewire.collection.IntervalSet;
import org.limewire.io.IpPort;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private final long index;
    private final long size;
    private final byte[] nameBytes;
    private final String name;
    private final int incomingNameByteArraySize;
    private LimeXMLDocument document;
    private final Set<URN> urns;
    private final byte[] extBytes;
    private volatile RemoteFileDesc cachedRFD;
    private final boolean isMetaFile;
    private final Set<? extends IpPort> alternateLocations;
    private final long creationTime;
    private final IntervalSet ranges;
    private final boolean verified;

    public Response(long l, long l2, String string, int n, Set<? extends URN> set, LimeXMLDocument limeXMLDocument, Set<? extends IpPort> set2, long l3, byte[] byArray, IntervalSet intervalSet, boolean bl) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (l2 < 0L || l2 > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("invalid size: " + l2);
        }
        this.index = l;
        this.size = l2;
        this.name = string == null ? "" : string;
        this.isMetaFile = this.name.toLowerCase().endsWith(".torrent");
        byte[] byArray2 = null;
        try {
            byArray2 = this.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        this.nameBytes = byArray2;
        this.urns = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
        this.alternateLocations = set2;
        this.creationTime = l3;
        this.extBytes = byArray;
        this.incomingNameByteArraySize = n;
        this.document = limeXMLDocument;
        this.ranges = intervalSet;
        this.verified = bl;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        int n;
        ByteOrder.int2leb((int)this.index, outputStream);
        if (this.size > Integer.MAX_VALUE) {
            ByteOrder.int2leb(-1, outputStream);
        } else {
            ByteOrder.int2leb((int)this.size, outputStream);
        }
        for (n = 0; n < this.nameBytes.length; ++n) {
            outputStream.write(this.nameBytes[n]);
        }
        outputStream.write(0);
        for (n = 0; n < this.extBytes.length; ++n) {
            outputStream.write(this.extBytes[n]);
        }
        outputStream.write(0);
    }

    public void setDocument(LimeXMLDocument limeXMLDocument) {
        this.document = limeXMLDocument;
    }

    public int getIncomingLength() {
        if (this.incomingNameByteArraySize != -1) {
            return 8 + this.incomingNameByteArraySize + 1 + this.extBytes.length + 1;
        }
        return 8 + this.nameBytes.length + 1 + this.extBytes.length + 1;
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public Set<URN> getUrns() {
        return this.urns;
    }

    public Set<? extends IpPort> getLocations() {
        return this.alternateLocations;
    }

    public long getCreateTime() {
        return this.creationTime;
    }

    public boolean isMetaFile() {
        return this.isMetaFile;
    }

    byte[] getExtBytes() {
        return this.extBytes;
    }

    public IntervalSet getRanges() {
        return this.ranges;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public RemoteFileDesc toRemoteFileDesc(HostData hostData, RemoteFileDescFactory remoteFileDescFactory) {
        RemoteFileDesc remoteFileDesc;
        if (this.cachedRFD != null && this.cachedRFD.getPort() == hostData.getPort() && this.cachedRFD.getHost().equals(hostData.getIP())) {
            return this.cachedRFD;
        }
        this.cachedRFD = remoteFileDesc = remoteFileDescFactory.createRemoteFileDesc(hostData.getIP(), hostData.getPort(), this.getIndex(), this.getName(), this.getSize(), hostData.getClientGUID(), hostData.getSpeed(), hostData.isChatEnabled(), hostData.getQuality(), hostData.isBrowseHostEnabled(), this.getDocument(), this.getUrns(), hostData.isReplyToMulticastQuery(), hostData.isFirewalled(), hostData.getVendorCode(), hostData.getPushProxies(), this.getCreateTime(), hostData.getFWTVersionSupported(), hostData.isTLSCapable());
        return remoteFileDesc;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Response)) {
            return false;
        }
        Response response = (Response)object;
        return this.getIndex() == response.getIndex() && this.getSize() == response.getSize() && this.getName().equals(response.getName()) && (this.getDocument() == null ? response.getDocument() == null : this.getDocument().equals(response.getDocument())) && ((Object)this.getUrns()).equals(response.getUrns());
    }

    public int hashCode() {
        return (int)((long)(961 * this.getName().hashCode()) + 31L * this.getSize() + this.getIndex());
    }

    public String toString() {
        return "index:        " + this.index + "\r\n" + "size:         " + this.size + "\r\n" + "name:         " + this.name + "\r\n" + "xml document: " + this.document + "\r\n" + "urns:         " + this.urns;
    }
}

