/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Buffer;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AddressSecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class QueryUnicaster {
    private static final Log LOG = LogFactory.getLog(QueryUnicaster.class);
    public static final int ITERATION_TIME = 100;
    public static final int MIN_ENDPOINTS = 25;
    public static final int MAX_ENDPOINTS = 30;
    public static final long ONE_HOUR = 3600000L;
    private final Thread _querier;
    private final Map<GUID, QueryBundle> _queries;
    private final Map<ReplyHandler, Set<GUID>> _querySets;
    private final LinkedList<GUESSEndpoint> _queryHosts;
    private final Map<GUESSEndpoint, QueryKeyBundle> _queryKeys;
    private final Buffer<GUESSEndpoint> _pingList;
    private final List<GUID> _qGuidsToRemove;
    private long _lastPingTime = 0L;
    private int _testUDPPingsSent = 0;
    private boolean _initialized = false;
    private final NetworkManager networkManager;
    private final QueryRequestFactory queryRequestFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<UDPService> udpService;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public QueryUnicaster(NetworkManager networkManager, QueryRequestFactory queryRequestFactory, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, Provider<UDPService> provider2, PingRequestFactory pingRequestFactory) {
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.backgroundExecutor = scheduledExecutorService;
        this.messageRouter = provider;
        this.udpService = provider2;
        this.pingRequestFactory = pingRequestFactory;
        this._queries = new Hashtable<GUID, QueryBundle>();
        this._queryHosts = new LinkedList();
        this._queryKeys = new Hashtable<GUESSEndpoint, QueryKeyBundle>();
        this._pingList = new Buffer(25);
        this._querySets = new Hashtable<ReplyHandler, Set<GUID>>();
        this._qGuidsToRemove = new Vector<GUID>();
        this._querier = ThreadExecutor.newManagedThread(new Runnable(){

            public void run() {
                QueryUnicaster.this.queryLoop();
            }
        });
        this._querier.setName("QueryUnicaster");
        this._querier.setDaemon(true);
    }

    int getQueryNumber() {
        return this._queries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GUESSEndpoint> getUnicastEndpoints() {
        ArrayList<GUESSEndpoint> arrayList = new ArrayList<GUESSEndpoint>();
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            LOG.debug("QueryUnicaster.getUnicastEndpoints(): obtained lock.");
            int n = this._queryHosts.size();
            if (n > 0) {
                int n2 = n > 10 ? 10 : n;
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(this._queryHosts.get(i));
                }
            }
            LOG.debug("QueryUnicaster.getUnicastEndpoints(): releasing lock.");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUESSEndpoint getUnicastEndpoint() {
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            if (this._queryHosts.isEmpty()) {
                return null;
            }
            return this._queryHosts.getFirst();
        }
    }

    public synchronized void start() {
        if (!this._initialized) {
            this._querier.start();
            QueryKeyExpirer queryKeyExpirer = new QueryKeyExpirer();
            this.backgroundExecutor.scheduleWithFixedDelay(queryKeyExpirer, 0L, 10800000L, TimeUnit.MILLISECONDS);
            this._initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLoop() {
        while (true) {
            try {
                while (true) {
                    Object object;
                    this.waitForQueries();
                    GUESSEndpoint gUESSEndpoint = this.getUnicastHost();
                    if (!this._queryKeys.containsKey(gUESSEndpoint)) {
                        object = this.pingRequestFactory.createQueryKeyRequest();
                        this.udpService.get().send((Message)object, gUESSEndpoint.getInetAddress(), gUESSEndpoint.getPort());
                        continue;
                    }
                    object = this._queryKeys.get((Object)gUESSEndpoint)._queryKey;
                    this.purgeGuidsInternal();
                    boolean bl = false;
                    Object object2 = this._queries;
                    synchronized (object2) {
                        for (QueryBundle queryBundle : this._queries.values()) {
                            if (queryBundle._hostsQueried.size() > 1000) {
                                this._qGuidsToRemove.add(new GUID(queryBundle._qr.getGUID()));
                                continue;
                            }
                            if (queryBundle._hostsQueried.contains(gUESSEndpoint)) continue;
                            InetAddress inetAddress = gUESSEndpoint.getInetAddress();
                            QueryRequest queryRequest = this.queryRequestFactory.createQueryKeyQuery(queryBundle._qr, (AddressSecurityToken)object);
                            this.udpService.get().send(queryRequest, inetAddress, gUESSEndpoint.getPort());
                            bl = true;
                            queryBundle._hostsQueried.add(gUESSEndpoint);
                        }
                    }
                    if (!bl) {
                        this.addUnicastEndpoint(gUESSEndpoint);
                    }
                    object2 = this._qGuidsToRemove;
                    synchronized (object2) {
                        this.purgeGuidsInternal();
                        this._qGuidsToRemove.clear();
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeGuidsInternal() {
        List<GUID> list = this._qGuidsToRemove;
        synchronized (list) {
            for (GUID gUID : this._qGuidsToRemove) {
                this._queries.remove(gUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueries() throws InterruptedException {
        LOG.debug("QueryUnicaster.waitForQueries(): waiting for Queries.");
        Map<GUID, QueryBundle> map = this._queries;
        synchronized (map) {
            if (this._queries.isEmpty()) {
                this._queries.wait();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("QueryUnicaster.waitForQueries(): numQueries = " + this._queries.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQuery(QueryRequest queryRequest, ReplyHandler replyHandler) {
        HashSet<GUID> hashSet;
        LOG.debug("QueryUnicaster.addQuery(): entered.");
        boolean bl = false;
        GUID gUID = new GUID(queryRequest.getGUID());
        Map<Object, Object> map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey(gUID)) {
                hashSet = new QueryBundle(queryRequest);
                this._queries.put(gUID, (QueryBundle)((Object)hashSet));
                bl = true;
            }
            if (bl) {
                this._queries.notifyAll();
            }
        }
        if (replyHandler == null) {
            return bl;
        }
        map = this._querySets;
        synchronized (map) {
            hashSet = this._querySets.get(replyHandler);
            if (hashSet == null) {
                hashSet = new HashSet<GUID>();
                this._querySets.put(replyHandler, hashSet);
            }
            hashSet.add(gUID);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("QueryUnicaster.addQuery(): returning " + bl);
        }
        return bl;
    }

    public void addUnicastEndpoint(InetAddress inetAddress, int n) {
        if (!SearchSettings.GUESS_ENABLED.getValue()) {
            return;
        }
        if (this.notMe(inetAddress, n) && NetworkUtils.isValidPort(n) && NetworkUtils.isValidAddress(inetAddress)) {
            GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
            this.addUnicastEndpoint(gUESSEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnicastEndpoint(GUESSEndpoint gUESSEndpoint) {
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            LOG.debug("QueryUnicaster.addUnicastEndpoint(): obtained lock.");
            if (this._queryHosts.size() == 30) {
                this._queryHosts.removeLast();
            }
            this._queryHosts.addFirst(gUESSEndpoint);
            this._queryHosts.notify();
            if (!(!this.udpService.get().isListening() || this.networkManager.isGUESSCapable() || this._testUDPPingsSent >= 10 || ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isCloseIP(this.networkManager.getAddress(), gUESSEndpoint.getInetAddress().getAddress()))) {
                PingRequest pingRequest = this.pingRequestFactory.createPingRequest(this.udpService.get().getSolicitedGUID().bytes(), (byte)1, (byte)0);
                this.udpService.get().send(pingRequest, gUESSEndpoint.getInetAddress(), gUESSEndpoint.getPort());
                ++this._testUDPPingsSent;
            }
            LOG.debug("QueryUnicaster.addUnicastEndpoint(): released lock.");
        }
    }

    private boolean notMe(InetAddress inetAddress, int n) {
        boolean bl = true;
        if (n == this.networkManager.getPort() && Arrays.equals(inetAddress.getAddress(), this.networkManager.getAddress())) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeQuery(ReplyHandler replyHandler) {
        LOG.debug("QueryUnicaster.purgeQuery(RH): entered.");
        if (replyHandler == null) {
            return;
        }
        Map<ReplyHandler, Set<GUID>> map = this._querySets;
        synchronized (map) {
            Set<GUID> set = this._querySets.remove(replyHandler);
            if (set == null) {
                return;
            }
            for (GUID gUID : set) {
                this.purgeQuery(gUID);
            }
        }
        LOG.debug("QueryUnicaster.purgeQuery(RH): returning.");
    }

    void purgeQuery(GUID gUID) {
        LOG.debug("QueryUnicaster.purgeQuery(GUID): entered.");
        this._qGuidsToRemove.add(gUID);
        LOG.debug("QueryUnicaster.purgeQuery(GUID): returning.");
    }

    public void handleQueryReply(QueryReply queryReply) {
        this.addResults(new GUID(queryReply.getGUID()), queryReply.getResultCount());
    }

    public void handleQueryKeyPong(PingReply pingReply) {
        if (pingReply == null) {
            throw new NullPointerException("null pong");
        }
        AddressSecurityToken addressSecurityToken = pingReply.getQueryKey();
        if (addressSecurityToken == null) {
            throw new IllegalArgumentException("no key in pong");
        }
        InetAddress inetAddress = pingReply.getInetAddress();
        int n = pingReply.getPort();
        GUESSEndpoint gUESSEndpoint = new GUESSEndpoint(inetAddress, n);
        this._queryKeys.put(gUESSEndpoint, new QueryKeyBundle(addressSecurityToken));
        this.addUnicastEndpoint(gUESSEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResults(GUID gUID, int n) {
        Map<GUID, QueryBundle> map = this._queries;
        synchronized (map) {
            QueryBundle queryBundle = this._queries.get(gUID);
            if (queryBundle != null) {
                queryBundle._numResults += n;
                if (queryBundle._numResults > 250) {
                    List<GUID> list = this._qGuidsToRemove;
                    synchronized (list) {
                        this._qGuidsToRemove.add(new GUID(queryBundle._qr.getGUID()));
                        this.purgeGuidsInternal();
                        this._qGuidsToRemove.clear();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUESSEndpoint getUnicastHost() throws InterruptedException {
        Object object;
        LOG.debug("QueryUnicaster.getUnicastHost(): waiting for hosts.");
        Object object2 = this._queryHosts;
        synchronized (object2) {
            LOG.debug("QueryUnicaster.getUnicastHost(): obtained lock.");
            while (this._queryHosts.isEmpty()) {
                if (System.currentTimeMillis() - this._lastPingTime > 20000L) {
                    object = this.pingRequestFactory.createPingRequest(ConnectionSettings.TTL.getValue());
                    this.messageRouter.get().broadcastPingRequest((PingRequest)object);
                    this._lastPingTime = System.currentTimeMillis();
                }
                this._queryHosts.wait();
            }
            LOG.debug("QueryUnicaster.getUnicastHost(): got a host, let go lock!");
        }
        if (this._queryHosts.size() < 25) {
            object2 = this._queryHosts.removeLast();
            object = this._pingList;
            synchronized (object) {
                if (!this._pingList.contains(object2)) {
                    PingRequest pingRequest = this.pingRequestFactory.createPingRequest((byte)1);
                    InetAddress inetAddress = ((IpPortImpl)object2).getInetAddress();
                    this.udpService.get().send(pingRequest, inetAddress, ((IpPortImpl)object2).getPort());
                    this._pingList.add((GUESSEndpoint)object2);
                }
            }
            return object2;
        }
        return this._queryHosts.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetUnicastEndpointsAndQueries() {
        LOG.debug("Resetting unicast endpoints.");
        Object object = this._queries;
        synchronized (object) {
            this._queries.clear();
            this._queries.notifyAll();
        }
        object = this._queryHosts;
        synchronized (object) {
            this._queryHosts.clear();
            this._queryHosts.notifyAll();
        }
        object = this._queryKeys;
        synchronized (object) {
            this._queryKeys.clear();
            this._queryKeys.notifyAll();
        }
        object = this._pingList;
        synchronized (object) {
            this._pingList.clear();
            this._pingList.notifyAll();
        }
        this._lastPingTime = 0L;
        this._testUDPPingsSent = 0;
    }

    private class QueryKeyExpirer
    implements Runnable {
        private QueryKeyExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = QueryUnicaster.this._queryKeys;
            synchronized (map) {
                Iterator iterator = QueryUnicaster.this._queryKeys.values().iterator();
                while (iterator.hasNext()) {
                    if (!((QueryKeyBundle)iterator.next()).shouldExpire()) continue;
                    iterator.remove();
                }
            }
        }
    }

    private static class QueryKeyBundle {
        public static final long QUERY_KEY_LIFETIME = 0x6DDD00L;
        final long _birthTime;
        final AddressSecurityToken _queryKey;

        public QueryKeyBundle(AddressSecurityToken addressSecurityToken) {
            this._queryKey = addressSecurityToken;
            this._birthTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._birthTime >= 0x6DDD00L;
        }

        public String toString() {
            return "{QueryKeyBundle: " + this._queryKey + " BirthTime = " + this._birthTime;
        }
    }

    private static class QueryBundle {
        public static final int MAX_RESULTS = 250;
        public static final int MAX_QUERIES = 1000;
        final QueryRequest _qr;
        int _numResults = 0;
        final Set<GUESSEndpoint> _hostsQueried = new HashSet<GUESSEndpoint>();

        public QueryBundle(QueryRequest queryRequest) {
            this._qr = queryRequest;
        }

        public String toString() {
            return "QueryBundle: " + this._qr;
        }
    }
}

