/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushEndpointCacheImpl
implements PushEndpointCache {
    private final Map<GUID, PushEndpointCache.CachedPushEndpoint> GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final HTTPHeaderUtils httpHeaderUtils;

    @Inject
    PushEndpointCacheImpl(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, HTTPHeaderUtils hTTPHeaderUtils) {
        scheduledExecutorService.scheduleWithFixedDelay(new WeakCleaner(), 30000L, 30000L, TimeUnit.MILLISECONDS);
        this.httpHeaderUtils = hTTPHeaderUtils;
    }

    @Override
    public void overwriteProxies(byte[] byArray, String string) {
        Set<Connectable> set = this.httpHeaderUtils.decodePushProxies(string, ",");
        this.overwriteProxies(byArray, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteProxies(byte[] byArray, Set<? extends IpPort> set) {
        GUID gUID = new GUID(byArray);
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.GUID_PROXY_MAP.get(gUID);
            if (cachedPushEndpoint == null) {
                cachedPushEndpoint = new CachedPushEndpointImpl(gUID);
                this.GUID_PROXY_MAP.put(gUID, cachedPushEndpoint);
            }
            cachedPushEndpoint.overwriteProxies(set);
        }
    }

    @Override
    public void setAddr(byte[] byArray, IpPort ipPort) {
        GUID gUID = new GUID(byArray);
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.getCached(gUID);
        if (cachedPushEndpoint != null) {
            cachedPushEndpoint.setIpPort(ipPort);
        }
    }

    @Override
    public void setFeatures(byte[] byArray, int n) {
        GUID gUID = new GUID(byArray);
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.getCached(gUID);
        if (cachedPushEndpoint != null) {
            cachedPushEndpoint.setFeatures(n);
        }
    }

    @Override
    public void setFWTVersionSupported(byte[] byArray, int n) {
        GUID gUID = new GUID(byArray);
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint = this.getCached(gUID);
        if (cachedPushEndpoint != null) {
            cachedPushEndpoint.setFWTVersion(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushEndpointCache.CachedPushEndpoint getCached(GUID gUID) {
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            return this.GUID_PROXY_MAP.get(gUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID updateProxiesFor(GUID gUID, PushEndpoint pushEndpoint, boolean bl) {
        PushEndpointCache.CachedPushEndpoint cachedPushEndpoint;
        GUID gUID2 = null;
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            cachedPushEndpoint = this.GUID_PROXY_MAP.get(gUID);
            if (cachedPushEndpoint != null) {
                gUID2 = cachedPushEndpoint.getGuid();
            }
            if (cachedPushEndpoint == null || gUID2 == null) {
                cachedPushEndpoint = new CachedPushEndpointImpl(gUID, pushEndpoint.getFeatures(), pushEndpoint.supportsFWTVersion());
                if (bl) {
                    cachedPushEndpoint.updateProxies(pushEndpoint.getProxies(), true);
                } else {
                    cachedPushEndpoint.updateProxies(IpPort.EMPTY_SET, true);
                }
                this.GUID_PROXY_MAP.put(gUID, cachedPushEndpoint);
                return gUID;
            }
        }
        cachedPushEndpoint.updateProxies(pushEndpoint.getProxies(), bl);
        return gUID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            this.GUID_PROXY_MAP.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedPushEndpointImpl
    implements PushEndpointCache.CachedPushEndpoint {
        private final WeakReference<GUID> _guidRef;
        private Set<IpPort> _proxies;
        private int _features;
        private int _fwtVersion;
        private IpPort _externalAddr;

        CachedPushEndpointImpl(GUID gUID) {
            this(gUID, 0, 0);
        }

        CachedPushEndpointImpl(GUID gUID, int n, int n2) {
            this._guidRef = new WeakReference<GUID>(gUID);
            this._features = n;
            this._fwtVersion = n2;
        }

        @Override
        public synchronized void updateProxies(Set<? extends IpPort> set, boolean bl) {
            IpPortSet ipPortSet = new IpPortSet();
            if (set == null) {
                set = this._proxies;
            }
            if (this._proxies != null) {
                ipPortSet.addAll(this._proxies);
            }
            if (bl) {
                ipPortSet.addAll(set);
            } else {
                ipPortSet.removeAll(set);
            }
            this.overwriteProxies(ipPortSet);
        }

        @Override
        public synchronized void overwriteProxies(Set<? extends IpPort> set) {
            this._proxies = Collections.unmodifiableSet(set);
        }

        @Override
        public synchronized Set<IpPort> getProxies() {
            return this._proxies != null ? this._proxies : IpPort.EMPTY_SET;
        }

        @Override
        public synchronized int getFeatures() {
            return this._features;
        }

        @Override
        public synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        @Override
        public synchronized void setFeatures(int n) {
            this._features = n;
        }

        @Override
        public synchronized void setFWTVersion(int n) {
            this._fwtVersion = n;
        }

        @Override
        public synchronized void setIpPort(IpPort ipPort) {
            this._externalAddr = ipPort;
        }

        @Override
        public synchronized IpPort getIpPort() {
            return this._externalAddr;
        }

        @Override
        public GUID getGuid() {
            return (GUID)this._guidRef.get();
        }
    }

    private final class WeakCleaner
    implements Runnable {
        private WeakCleaner() {
        }

        public void run() {
            PushEndpointCacheImpl.this.GUID_PROXY_MAP.size();
        }
    }
}

