/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class NodeAssignerImpl
implements NodeAssigner {
    private static final Log LOG = LogFactory.getLog(NodeAssignerImpl.class);
    private static final boolean ULTRAPEER_OS = OSUtils.isHighLoadOS();
    static final int TIMER_DELAY = 1000;
    private static final int TIMER_DELAY_IN_SECONDS = 1;
    private long _currentUptime = 0L;
    private int _maxUpstreamBytesPerSec = UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.getValue();
    private int _maxDownstreamBytesPerSec = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue();
    private volatile boolean _isTooGoodUltrapeerToPassUp = false;
    private volatile long _lastUltrapeerAttempt = 0L;
    private int _ultrapeerTries = 0;
    private boolean _isHardcoreCapable;
    private ScheduledFuture<?> timer;
    private final Provider<BandwidthTracker> uploadTracker;
    private final Provider<BandwidthTracker> downloadTracker;
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkManager networkManager;
    private final SearchServices searchServices;
    private final Provider<DHTManager> dhtManager;
    private final ScheduledExecutorService backgroundExecutor;
    private final Executor unlimitedExecutor;
    private final ConnectionServices connectionServices;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public NodeAssignerImpl(@Named(value="uploadTracker") Provider<BandwidthTracker> provider, @Named(value="downloadTracker") Provider<BandwidthTracker> provider2, Provider<ConnectionManager> provider3, NetworkManager networkManager, SearchServices searchServices, Provider<DHTManager> provider4, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, @Named(value="unlimitedExecutor") Executor executor, ConnectionServices connectionServices, TcpBandwidthStatistics tcpBandwidthStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.uploadTracker = provider;
        this.downloadTracker = provider2;
        this.connectionManager = provider3;
        this.networkManager = networkManager;
        this.searchServices = searchServices;
        this.dhtManager = provider4;
        this.backgroundExecutor = scheduledExecutorService;
        this.connectionServices = connectionServices;
        this.unlimitedExecutor = executor;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void start() {
        Runnable runnable = new Runnable(){

            public void run() {
                NodeAssignerImpl.this.collectBandwidthData();
                NodeAssignerImpl.this.setHardcoreCapable();
                NodeAssignerImpl.this.assignUltrapeerNode();
                NodeAssignerImpl.this.assignDHTMode();
            }
        };
        this.timer = this.backgroundExecutor.scheduleWithFixedDelay(runnable, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel(true);
        }
    }

    private void collectBandwidthData() {
        ++this._currentUptime;
        this.uploadTracker.get().measureBandwidth();
        this.downloadTracker.get().measureBandwidth();
        this.connectionManager.get().measureBandwidth();
        float f = 0.0f;
        try {
            f = this.uploadTracker.get().getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        int n = (int)f + (int)this.connectionManager.get().getMeasuredUpstreamBandwidth();
        f = 0.0f;
        try {
            f = this.downloadTracker.get().getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        int n2 = (int)f + (int)this.connectionManager.get().getMeasuredDownstreamBandwidth();
        if (n > this._maxUpstreamBytesPerSec) {
            this._maxUpstreamBytesPerSec = n;
            UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.setValue(this._maxUpstreamBytesPerSec);
        }
        if (n2 > this._maxDownstreamBytesPerSec) {
            this._maxDownstreamBytesPerSec = n2;
            DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.setValue(this._maxDownstreamBytesPerSec);
        }
    }

    private void setHardcoreCapable() {
        boolean bl = this._isHardcoreCapable = (this._maxUpstreamBytesPerSec >= UltrapeerSettings.MIN_UPSTREAM_REQUIRED.getValue() || this._maxDownstreamBytesPerSec >= UltrapeerSettings.MIN_DOWNSTREAM_REQUIRED.getValue()) && ConnectionSettings.CONNECTION_SPEED.getValue() > 56 && ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && ULTRAPEER_OS && !this.networkInstanceUtils.isPrivate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hardcore capable: " + this._isHardcoreCapable);
        }
    }

    private void assignUltrapeerNode() {
        boolean bl;
        if (UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue()) {
            LOG.debug("Ultrapeer mode disabled");
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(false);
            return;
        }
        if (this.connectionServices.isSupernode()) {
            LOG.debug("Already an ultrapeer, exiting");
            return;
        }
        boolean bl2 = ApplicationSettings.AVERAGE_UPTIME.getValue() >= UltrapeerSettings.MIN_AVG_UPTIME.getValue();
        boolean bl3 = this._currentUptime >= (long)UltrapeerSettings.MIN_INITIAL_UPTIME.getValue();
        boolean bl4 = bl2 | bl3;
        boolean bl5 = bl = this._isHardcoreCapable && bl4 && this.networkManager.isGUESSCapable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node is ultrapeer capable: " + bl + "(hc: " + this._isHardcoreCapable + ", up: " + bl4 + ", gc: " + this.networkManager.isGUESSCapable());
        }
        long l = System.currentTimeMillis();
        boolean bl6 = this._isTooGoodUltrapeerToPassUp = bl && this.networkManager.acceptedIncomingConnection() && l - this.searchServices.getLastQueryTime() > 300000L && this.tcpBandwidthStatistics.getAverageHttpUpstream() < 1.0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node is " + (this._isTooGoodUltrapeerToPassUp ? "" : "NOT") + " to good to pass up");
        }
        if (bl) {
            UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(true);
        }
        if (this._isTooGoodUltrapeerToPassUp && this.shouldTryToBecomeAnUltrapeer(l) && this.switchFromActiveDHTNodeToUltrapeer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node WILL try to become an ultrapeer");
            }
            ++this._ultrapeerTries;
            final int n = 4 * this._ultrapeerTries;
            Runnable runnable = new Runnable(){

                public void run() {
                    ((ConnectionManager)NodeAssignerImpl.this.connectionManager.get()).tryToBecomeAnUltrapeer(n);
                }
            };
            this.unlimitedExecutor.execute(runnable);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Node will not try to become an ultrapeer");
        }
    }

    private boolean shouldTryToBecomeAnUltrapeer(long l) {
        if (l - this._lastUltrapeerAttempt < (long)UltrapeerSettings.UP_RETRY_TIME.getValue()) {
            return false;
        }
        this._lastUltrapeerAttempt = l;
        return true;
    }

    private boolean switchFromActiveDHTNodeToUltrapeer() {
        if (this.dhtManager.get().getDHTMode() != DHTManager.DHTMode.ACTIVE) {
            return true;
        }
        if (DHTSettings.EXCLUDE_ULTRAPEERS.getValue() && this.acceptUltrapeer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Randomly switching from DHT node to ultrapeer!");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isTooGoodUltrapeerToPassUp() {
        return this._isTooGoodUltrapeerToPassUp;
    }

    private DHTManager.DHTMode assignDHTMode() {
        DHTManager.DHTMode dHTMode = this.dhtManager.get().getDHTMode();
        assert (dHTMode != null) : "Current DHTMode is null, fix your DHTManager-Stub!";
        DHTManager.DHTMode dHTMode2 = DHTManager.DHTMode.INACTIVE;
        if (!this.dhtManager.get().isEnabled()) {
            if (dHTMode != dHTMode2) {
                this.switchDHTMode(dHTMode, dHTMode2);
            }
            return dHTMode2;
        }
        boolean bl = this.connectionServices.isActiveSuperNode();
        if (bl && this.isPassiveDHTCapable()) {
            dHTMode2 = DHTManager.DHTMode.PASSIVE;
        }
        if (!bl || !DHTSettings.EXCLUDE_ULTRAPEERS.getValue()) {
            assert (DHTSettings.MIN_ACTIVE_DHT_INITIAL_UPTIME.getValue() / 1000L > (long)UltrapeerSettings.MIN_CONNECT_TIME.getValue()) : "Wrong minimum initial uptime";
            long l = Math.max(this.connectionManager.get().getCurrentAverageUptime(), ApplicationSettings.AVERAGE_CONNECTION_TIME.getValue());
            boolean bl2 = this.isPassiveLeafDHTCapable();
            boolean bl3 = this.isActiveDHTCapable();
            if (LOG.isDebugEnabled()) {
                if (bl2 && !bl3) {
                    LOG.debug("Node is passive DHT capable\n average time: " + l + "\n currentUptime: " + this._currentUptime);
                } else if (bl3) {
                    LOG.debug("Node is active DHT capable\n average time: " + l + "\n currentUptime: " + this._currentUptime);
                } else {
                    LOG.debug("Node is NOT DHT capable\n average time: " + l + "\n currentUptime: " + this._currentUptime);
                }
            }
            if (bl2 && !bl) {
                dHTMode2 = DHTManager.DHTMode.PASSIVE_LEAF;
            }
            if (bl3) {
                dHTMode2 = DHTManager.DHTMode.ACTIVE;
            }
        }
        if (dHTMode2 == DHTManager.DHTMode.PASSIVE && !DHTSettings.ENABLE_PASSIVE_DHT_MODE.getValue()) {
            dHTMode2 = DHTManager.DHTMode.INACTIVE;
        } else if (dHTMode2 == DHTManager.DHTMode.PASSIVE_LEAF && !DHTSettings.ENABLE_PASSIVE_LEAF_DHT_MODE.getValue()) {
            dHTMode2 = DHTManager.DHTMode.INACTIVE;
        }
        if (DHTSettings.FORCE_DHT_CONNECT.getValue()) {
            dHTMode2 = DHTManager.DHTMode.ACTIVE;
        }
        if (dHTMode2 != dHTMode && (bl || this.acceptDHTNode()) || dHTMode != DHTManager.DHTMode.INACTIVE && dHTMode2 == DHTManager.DHTMode.INACTIVE) {
            this.switchDHTMode(dHTMode, dHTMode2);
        }
        return dHTMode2;
    }

    private void switchDHTMode(DHTManager.DHTMode dHTMode, final DHTManager.DHTMode dHTMode2) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (dHTMode2 != DHTManager.DHTMode.INACTIVE) {
                    ((DHTManager)NodeAssignerImpl.this.dhtManager.get()).start(dHTMode2);
                } else {
                    ((DHTManager)NodeAssignerImpl.this.dhtManager.get()).stop();
                }
                DHTSettings.DHT_MODE.setValue(dHTMode2.toString());
            }
        };
        this.unlimitedExecutor.execute(runnable);
    }

    private boolean isPassiveDHTCapable() {
        long l = this.getAverageTime();
        return ULTRAPEER_OS && l >= DHTSettings.MIN_PASSIVE_DHT_AVERAGE_UPTIME.getValue() && this._currentUptime >= DHTSettings.MIN_PASSIVE_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.canReceiveSolicited();
    }

    private boolean isPassiveLeafDHTCapable() {
        long l = this.getAverageTime();
        return ULTRAPEER_OS && l >= DHTSettings.MIN_PASSIVE_LEAF_DHT_AVERAGE_UPTIME.getValue() && this._currentUptime >= DHTSettings.MIN_PASSIVE_LEAF_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.canReceiveSolicited();
    }

    private boolean isActiveDHTCapable() {
        long l = this.getAverageTime();
        return this._isHardcoreCapable && l >= DHTSettings.MIN_ACTIVE_DHT_AVERAGE_UPTIME.getValue() && this._currentUptime >= DHTSettings.MIN_ACTIVE_DHT_INITIAL_UPTIME.getValue() / 1000L && this.networkManager.isGUESSCapable();
    }

    private long getAverageTime() {
        return Math.max(this.connectionManager.get().getCurrentAverageUptime(), ApplicationSettings.AVERAGE_CONNECTION_TIME.getValue());
    }

    private boolean acceptDHTNode() {
        return Math.random() < (double)DHTSettings.DHT_ACCEPT_PROBABILITY.getValue();
    }

    private boolean acceptUltrapeer() {
        return Math.random() < (double)DHTSettings.SWITCH_TO_ULTRAPEER_PROBABILITY.getValue();
    }
}

