/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import org.limewire.io.LocalSocketAddressProvider;

@Singleton
public class LocalSocketAddressProviderImpl
implements LocalSocketAddressProvider {
    private final NetworkManager networkManager;

    @Inject
    public LocalSocketAddressProviderImpl(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public byte[] getLocalAddress() {
        return this.networkManager.getAddress();
    }

    public int getLocalPort() {
        return this.networkManager.getPort();
    }

    public boolean isLocalAddressPrivate() {
        return ConnectionSettings.LOCAL_IS_PRIVATE.getValue();
    }

    public boolean isTLSCapable() {
        return SSLSettings.isIncomingTLSEnabled();
    }
}

