/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.bittorrent.AzureusStarter;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.TorrentManager;
import com.limegroup.bittorrent.handshaking.IncomingConnectionHandler;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.OutOfBandThroughputMeasurer;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.browser.ControlRequestAcceptor;
import com.limegroup.gnutella.browser.LocalAcceptor;
import com.limegroup.gnutella.browser.LocalHTTPAcceptor;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.serial.conversion.DownloadUpgradeTask;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.rudp.messages.LimeRUDPMessageHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListenerList;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.ssl.SSLEngineTest;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.service.ErrorService;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.statistic.StatisticAccumulator;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Log LOG = LogFactory.getLog(LifecycleManagerImpl.class);
    private final AtomicBoolean preinitializeBegin = new AtomicBoolean(false);
    private final AtomicBoolean preinitializeDone = new AtomicBoolean(false);
    private final AtomicBoolean backgroundBegin = new AtomicBoolean(false);
    private final AtomicBoolean backgroundDone = new AtomicBoolean(false);
    private final AtomicBoolean startBegin = new AtomicBoolean(false);
    private final AtomicBoolean startDone = new AtomicBoolean(false);
    private final AtomicBoolean shutdownBegin = new AtomicBoolean(false);
    private final AtomicBoolean shutdownDone = new AtomicBoolean(false);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final Provider<IPFilter> ipFilter;
    private final Provider<Acceptor> acceptor;
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<ContentManager> contentManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<UploadManager> uploadManager;
    private final Provider<HTTPAcceptor> httpUploadAcceptor;
    private final Provider<StaticMessages> staticMessages;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final Provider<NodeAssigner> nodeAssigner;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<FileManager> fileManager;
    private final Provider<TorrentManager> torrentManager;
    private final Provider<ConnectionDispatcher> connectionDispatcher;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<LocalHTTPAcceptor> localHttpAcceptor;
    private final Provider<LocalAcceptor> localAcceptor;
    private final Provider<Pinger> pinger;
    private final Provider<ConnectionWatchdog> connectionWatchdog;
    private final Provider<SavedFileManager> savedFileManager;
    private final Provider<RatingTable> ratingTable;
    private final Provider<ChatManager> chatManager;
    private final Provider<UDPMultiplexor> udpMultiplexor;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final Provider<DHTManager> dhtManager;
    private final Provider<ByteBufferCache> byteBufferCache;
    private final Provider<NetworkManager> networkManager;
    private final Provider<Statistics> statistics;
    private final Provider<ConnectionServices> connectionServices;
    private final Provider<SpamServices> spamServices;
    private final Provider<ControlRequestAcceptor> controlRequestAcceptor;
    private final Provider<LimeCoreGlue> limeCoreGlue;
    private final Provider<OutOfBandThroughputMeasurer> outOfBandThroughputMeasurer;
    private final Provider<BrowseHostHandlerManager> browseHostHandlerManager;
    private final Provider<DownloadUpgradeTask> downloadUpgradeTask;
    private final Provider<StatisticAccumulator> statisticAccumulator;
    private final List<Thread> SHUTDOWN_ITEMS = Collections.synchronizedList(new LinkedList());
    @InspectablePrimitive(value="time lifecycle finished starting")
    private long startFinishedTime;
    private final Provider<LicenseFactory> licenseFactory;
    private final Provider<ConnectionDispatcher> localConnectionDispatcher;
    private final EventListenerList<LifeCycleEvent> listenerList;
    private final ServiceRegistry serviceRegistry;

    @Inject
    public LifecycleManagerImpl(Provider<IPFilter> provider, Provider<Acceptor> provider2, Provider<ActivityCallback> provider3, Provider<ContentManager> provider4, Provider<MessageRouter> provider5, Provider<UploadManager> provider6, Provider<HTTPAcceptor> provider7, Provider<StaticMessages> provider8, Provider<ConnectionManager> provider9, Provider<DownloadManager> provider10, Provider<PushDownloadManager> provider11, Provider<NodeAssigner> provider12, Provider<HostCatcher> provider13, Provider<FileManager> provider14, Provider<TorrentManager> provider15, @Named(value="global") Provider<ConnectionDispatcher> provider16, @Named(value="local") Provider<ConnectionDispatcher> provider17, Provider<UpdateHandler> provider18, Provider<QueryUnicaster> provider19, Provider<LocalHTTPAcceptor> provider20, Provider<LocalAcceptor> provider21, Provider<Pinger> provider22, Provider<ConnectionWatchdog> provider23, Provider<SavedFileManager> provider24, Provider<RatingTable> provider25, Provider<ChatManager> provider26, Provider<UDPMultiplexor> provider27, Provider<HashTreeCache> provider28, Provider<DHTManager> provider29, Provider<ByteBufferCache> provider30, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> provider31, Provider<NetworkManager> provider32, Provider<Statistics> provider33, Provider<ConnectionServices> provider34, Provider<SpamServices> provider35, Provider<ControlRequestAcceptor> provider36, Provider<IncomingConnectionHandler> provider37, Provider<LicenseFactory> provider38, Provider<LimeCoreGlue> provider39, Provider<OutOfBandThroughputMeasurer> provider40, Provider<BrowseHostHandlerManager> provider41, Provider<DownloadUpgradeTask> provider42, Provider<StatisticAccumulator> provider43, ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.listenerList = new EventListenerList();
        this.ipFilter = provider;
        this.acceptor = provider2;
        this.activityCallback = provider3;
        this.contentManager = provider4;
        this.messageRouter = provider5;
        this.uploadManager = provider6;
        this.httpUploadAcceptor = provider7;
        this.staticMessages = provider8;
        this.connectionManager = provider9;
        this.downloadManager = provider10;
        this.pushDownloadManager = provider11;
        this.nodeAssigner = provider12;
        this.hostCatcher = provider13;
        this.fileManager = provider14;
        this.torrentManager = provider15;
        this.connectionDispatcher = provider16;
        this.localConnectionDispatcher = provider17;
        this.updateHandler = provider18;
        this.queryUnicaster = provider19;
        this.localHttpAcceptor = provider20;
        this.localAcceptor = provider21;
        this.pinger = provider22;
        this.connectionWatchdog = provider23;
        this.savedFileManager = provider24;
        this.ratingTable = provider25;
        this.chatManager = provider26;
        this.udpMultiplexor = provider27;
        this.tigerTreeCache = provider28;
        this.dhtManager = provider29;
        this.byteBufferCache = provider30;
        this.networkManager = provider32;
        this.statistics = provider33;
        this.connectionServices = provider34;
        this.spamServices = provider35;
        this.controlRequestAcceptor = provider36;
        this.licenseFactory = provider38;
        this.limeCoreGlue = provider39;
        this.outOfBandThroughputMeasurer = provider40;
        this.browseHostHandlerManager = provider41;
        this.downloadUpgradeTask = provider42;
        this.statisticAccumulator = provider43;
    }

    @Override
    public boolean isLoaded() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STARTING;
    }

    @Override
    public boolean isStarted() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STOPPED;
    }

    @Override
    public boolean isShutdown() {
        return this.getCurrentState() == State.STOPPED;
    }

    @Override
    public void installListeners() {
        if (this.preinitializeBegin.getAndSet(true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        this.serviceRegistry.initialize();
        this.fileManager.get().addFileEventListener(this.activityCallback.get());
        LimeRUDPMessageHandler limeRUDPMessageHandler = new LimeRUDPMessageHandler(this.udpMultiplexor.get());
        limeRUDPMessageHandler.install(this.messageRouter.get());
        this.connectionManager.get().addEventListener((EventListener)this.activityCallback.get());
        this.connectionManager.get().addEventListener((EventListener)this.dhtManager.get());
        this.preinitializeDone.set(true);
        this.installAzureusCoreListeners();
    }

    private void installAzureusCoreListeners() {
        this.addListener(new org.limewire.listener.EventListener<LifeCycleEvent>(){

            @Override
            public void handleEvent(LifeCycleEvent lifeCycleEvent) {
                if (lifeCycleEvent == LifeCycleEvent.SHUTINGDOWN && AzureusStarter.getAzureusCore().isStarted()) {
                    LOG.debug("LifecycleManagerImpl.handleEvent - SHUTINGDOWN - Azureus core pauseDownloads()!");
                    AzureusStarter.getAzureusCore().getGlobalManager().pauseDownloads();
                    AzureusStarter.getAzureusCore().stop();
                }
            }
        });
    }

    @Override
    public void loadBackgroundTasks() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        ThreadExecutor.startThread(new Runnable(){

            public void run() {
                LifecycleManagerImpl.this.doBackgroundTasks();
            }
        }, "BackgroundTasks");
    }

    private void loadBackgroundTasksBlocking() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        this.doBackgroundTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.startBegin.getAndSet(true)) {
            return;
        }
        try {
            this.listenerList.broadcast(LifeCycleEvent.STARTING);
            this.doStart();
            this.listenerList.broadcast(LifeCycleEvent.STARTED);
        }
        finally {
            this.startLatch.countDown();
        }
    }

    private void doStart() {
        int n;
        this.loadBackgroundTasksBlocking();
        LOG.trace("START RouterService");
        this.statisticAccumulator.get().start();
        if (SSLSettings.isIncomingTLSEnabled() || SSLSettings.isOutgoingTLSEnabled()) {
            LOG.trace("START SSL Test");
            this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading TLS Encryption..."));
            SSLEngineTest sSLEngineTest = new SSLEngineTest(SSLUtils.getTLSContext(), SSLUtils.getTLSCipherSuites(), this.byteBufferCache.get());
            if (!sSLEngineTest.go()) {
                Throwable throwable = sSLEngineTest.getLastFailureCause();
                SSLSettings.disableTLS(throwable);
                if (!SSLSettings.IGNORE_SSL_EXCEPTIONS.getValue() && !sSLEngineTest.isIgnorable(throwable)) {
                    ErrorService.error(throwable);
                }
            }
            LOG.trace("END SSL Test");
        }
        LOG.trace("START ContentManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Safe Content Management..."));
        this.contentManager.get().start();
        LOG.trace("STOP ContentManager");
        LOG.trace("START MessageRouter");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Message Router..."));
        this.messageRouter.get().start();
        LOG.trace("STOPMessageRouter");
        LOG.trace("START UpdateManager.instance");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Checking for Updates..."));
        this.updateHandler.get().initialize();
        LOG.trace("STOP UpdateManager.instance");
        LOG.trace("START HTTPUploadManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Upload Management..."));
        this.uploadManager.get().start();
        LOG.trace("STOP HTTPUploadManager");
        LOG.trace("START HTTPUploadAcceptor");
        this.httpUploadAcceptor.get().start();
        this.connectionDispatcher.get().addConnectionAcceptor(this.httpUploadAcceptor.get(), false, this.httpUploadAcceptor.get().getHttpMethods());
        LOG.trace("STOP HTTPUploadAcceptor");
        LOG.trace("START Acceptor");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Connection Listener..."));
        this.acceptor.get().start();
        LOG.trace("STOP Acceptor");
        LOG.trace("START loading StaticMessages");
        this.staticMessages.get().initialize();
        LOG.trace("END loading StaticMessages");
        LOG.trace("START ConnectionManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Connection Management..."));
        this.connectionManager.get().initialize();
        LOG.trace("STOP ConnectionManager");
        LOG.trace("Running download upgrade task");
        this.downloadUpgradeTask.get().upgrade();
        LOG.trace("Download upgrade task run!");
        LOG.trace("START DownloadManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Download Management..."));
        this.downloadManager.get().initialize();
        this.connectionDispatcher.get().addConnectionAcceptor(this.pushDownloadManager.get(), false, "GIV");
        LOG.trace("STOP DownloadManager");
        LOG.trace("START NodeAssigner");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Ultrapeer/DHT Management..."));
        this.nodeAssigner.get().start();
        LOG.trace("STOP NodeAssigner");
        LOG.trace("START HostCatcher.initialize");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Locating Peers..."));
        this.hostCatcher.get().initialize();
        LOG.trace("STOP HostCatcher.initialize");
        if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (n = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
            LOG.trace("START connect");
            this.connectionServices.get().connect();
            LOG.trace("STOP connect");
        }
        LOG.trace("START FileManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Shared Files..."));
        this.fileManager.get().start();
        LOG.trace("STOP FileManager");
        LOG.trace("START TorrentManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading BitTorrent Management..."));
        this.torrentManager.get().initialize(this.connectionDispatcher.get());
        LOG.trace("STOP TorrentManager");
        LOG.trace("START DownloadManager.postGuiInit");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Old Downloads..."));
        this.downloadManager.get().loadSavedDownloadsAndScheduleWriting();
        LOG.trace("STOP DownloadManager.postGuiInit");
        LOG.trace("START QueryUnicaster");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Directed Querier..."));
        this.queryUnicaster.get().start();
        LOG.trace("STOP QueryUnicaster");
        LOG.trace("START LocalHTTPAcceptor");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Magnet Listener..."));
        this.localHttpAcceptor.get().start();
        this.localConnectionDispatcher.get().addConnectionAcceptor(this.localHttpAcceptor.get(), true, this.localHttpAcceptor.get().getHttpMethods());
        LOG.trace("STOP LocalHTTPAcceptor");
        LOG.trace("START LocalAcceptor");
        this.initializeLocalConnectionDispatcher();
        this.localAcceptor.get().start();
        LOG.trace("STOP LocalAcceptor");
        LOG.trace("START Pinger");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Peer Listener..."));
        this.pinger.get().start();
        LOG.trace("STOP Pinger");
        LOG.trace("START ConnectionWatchdog");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Stale Connection Management..."));
        this.connectionWatchdog.get().start();
        LOG.trace("STOP ConnectionWatchdog");
        LOG.trace("START SavedFileManager");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Saved Files..."));
        this.savedFileManager.get();
        LOG.trace("STOP SavedFileManager");
        LOG.trace("START loading spam data");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Spam Management..."));
        this.ratingTable.get();
        LOG.trace("START loading spam data");
        LOG.trace("START register connection dispatchers");
        this.activityCallback.get().componentLoading(I18nMarker.marktr("Loading Network Listeners..."));
        this.initializeConnectionDispatcher();
        LOG.trace("STOP register connection dispatchers");
        LOG.trace("START Random Initializings");
        this.outOfBandThroughputMeasurer.get().initialize();
        this.browseHostHandlerManager.get().initialize();
        LOG.trace("STOP Random Initializings");
        this.serviceRegistry.start();
        if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
            this.startManualGCThread();
        }
        LOG.trace("STOP RouterService.");
        this.startDone.set(true);
        this.startFinishedTime = System.currentTimeMillis();
    }

    private void initializeConnectionDispatcher() {
        this.connectionDispatcher.get().addConnectionAcceptor(this.controlRequestAcceptor.get(), true, "MAGNET", "TORRENT");
        this.connectionDispatcher.get().addConnectionAcceptor(this.chatManager.get(), false, "CHAT");
    }

    private void initializeLocalConnectionDispatcher() {
        this.localConnectionDispatcher.get().addConnectionAcceptor(this.controlRequestAcceptor.get(), true, "MAGNET", "TORRENT");
    }

    @Override
    public void shutdown() {
        try {
            this.listenerList.broadcast(LifeCycleEvent.SHUTINGDOWN);
            this.doShutdown();
            this.listenerList.broadcast(LifeCycleEvent.SHUTDOWN);
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    private void doShutdown() {
        if (!this.startBegin.get() || this.shutdownBegin.getAndSet(true)) {
            return;
        }
        try {
            this.startLatch.await();
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Interrupted while waiting to finish starting", interruptedException);
            return;
        }
        this.serviceRegistry.stop();
        this.nodeAssigner.get().stop();
        this.dhtManager.get().stop();
        try {
            this.acceptor.get().setListeningPort(0);
        }
        catch (IOException iOException) {
            LOG.error("Error stopping acceptor", iOException);
        }
        this.acceptor.get().shutdown();
        this.connectionManager.get().disconnect(false);
        this.statistics.get().shutdown();
        ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(this.networkManager.get().acceptedIncomingConnection());
        try {
            this.hostCatcher.get().write();
        }
        catch (IOException iOException) {
            LOG.error("Error saving host catcher file", iOException);
        }
        SettingsGroupManager.instance().save();
        this.ratingTable.get().ageAndSave();
        this.cleanupPreviewFiles();
        this.cleanupTorrentMetadataFiles();
        this.downloadManager.get().writeSnapshot();
        this.fileManager.get().stop();
        this.tigerTreeCache.get().persistCache(this.fileManager.get(), this.downloadManager.get());
        this.licenseFactory.get().persistCache();
        this.contentManager.get().stop();
        this.messageRouter.get().stop();
        this.localAcceptor.get().stop();
        this.statisticAccumulator.get().stop();
        this.shutdownDone.set(true);
    }

    private static String parseCommand(String string) {
        if (string.startsWith("\"")) {
            int n = string.indexOf("\"", 1);
            if (n > -1) {
                return string.substring(0, n + 1);
            }
            return string + "\"";
        }
        int n = string.indexOf(" ");
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    @Override
    public void shutdown(String string) {
        this.shutdown();
        if (string != null) {
            try {
                if (OSUtils.isWindowsVista()) {
                    String string2 = LifecycleManagerImpl.parseCommand(string).trim();
                    String string3 = string.substring(string2.length()).trim();
                    SystemUtils.openFile(string2, string3);
                } else {
                    Runtime.getRuntime().exec(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long getStartFinishedTime() {
        return this.startFinishedTime;
    }

    @Override
    public boolean addShutdownItem(Thread thread) {
        if (this.shutdownBegin.get()) {
            return false;
        }
        this.SHUTDOWN_ITEMS.add(thread);
        return true;
    }

    private void doBackgroundTasks() {
        this.serviceRegistry.start("SuperEarly");
        this.serviceRegistry.start("EarlyBackground");
        this.limeCoreGlue.get().install();
        this.ipFilter.get().refreshHosts(new IPFilter.IPFilterCallback(){

            public void ipFiltersLoaded() {
                ((SpamServices)LifecycleManagerImpl.this.spamServices.get()).adjustSpamFilters();
            }
        });
        this.acceptor.get().init();
        this.backgroundDone.set(true);
    }

    private State getCurrentState() {
        if (this.shutdownBegin.get()) {
            return State.STOPPED;
        }
        if (this.startDone.get()) {
            return State.STARTED;
        }
        if (this.startBegin.get()) {
            return State.STARTING;
        }
        return State.NONE;
    }

    private void startManualGCThread() {
        Thread thread = ThreadExecutor.newManagedThread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace("Running GC");
                    System.gc();
                    LOG.trace("GC finished, running finalizers");
                    System.runFinalization();
                    LOG.trace("Finalizers finished.");
                }
            }
        }, "ManualGC");
        thread.setDaemon(true);
        thread.start();
        LOG.trace("Started manual GC thread.");
    }

    private void cleanupTorrentMetadataFiles() {
        if (!this.fileManager.get().isLoadFinished()) {
            return;
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return "torrent".equals(FileUtils.getFileExtension(file));
            }
        };
        File[] fileArray = SharingUtils.APPLICATION_SPECIAL_SHARE.listFiles(fileFilter);
        if (fileArray == null) {
            return;
        }
        long l = System.currentTimeMillis() - (long)SharingSettings.TORRENT_METADATA_PURGE_TIME.getValue() * 24L * 60L * 60L * 1000L;
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (this.fileManager.get().isFileShared(file) || file.lastModified() >= l) continue;
            file.delete();
        }
    }

    private void cleanupPreviewFiles() {
        File file = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            if (!string.startsWith("Preview-")) continue;
            fileArray[i].delete();
        }
    }

    public void addListener(org.limewire.listener.EventListener<LifeCycleEvent> eventListener) {
        this.listenerList.addListener(eventListener);
    }

    public boolean removeListener(org.limewire.listener.EventListener<LifeCycleEvent> eventListener) {
        return this.listenerList.removeListener(eventListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LifeCycleEvent {
        STARTING,
        STARTED,
        SHUTINGDOWN,
        SHUTDOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NONE,
        STARTING,
        STARTED,
        STOPPED;

    }
}

