/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.SocketProcessor;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UPnPListener;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.AsyncConnectionDispatcher;
import org.limewire.net.BlockingConnectionDispatcher;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.SocketFactory;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.AcceptObserver;
import org.limewire.service.MessageService;
import org.limewire.setting.SettingsGroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AcceptorImpl
implements ConnectionAcceptor,
SocketProcessor,
Acceptor {
    private static final Log LOG = LogFactory.getLog(AcceptorImpl.class);
    public static final long DEFAULT_INCOMING_EXPIRE_TIME = 1800000L;
    public static final long DEFAULT_WAIT_TIME_AFTER_REQUESTS = 30000L;
    public static final long DEFAULT_TIME_BETWEEN_VALIDATES = 600000L;
    private long incomingExpireTime = 1800000L;
    private long waitTimeAfterRequests = 30000L;
    private long timeBetweenValidates = 600000L;
    private final IncomingValidator incomingValidator = new IncomingValidator();
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private byte[] _address = new byte[4];
    private byte[] _externalAddress = new byte[4];
    @InspectablePrimitive(value="accepted incoming")
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastConnectBackTime = 0L;
    private volatile boolean _started;
    private final NetworkManager networkManager;
    private final Provider<UDPService> udpService;
    private final Provider<MulticastService> multicastService;
    private final Provider<ConnectionDispatcher> connectionDispatcher;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final ConnectionServices connectionServices;
    private final Provider<UPnPManager> upnpManager;
    @InspectablePrimitive(value="upnp enabled")
    private final boolean upnpEnabled;

    @Inject
    public AcceptorImpl(NetworkManager networkManager, Provider<UDPService> provider, Provider<MulticastService> provider2, @Named(value="global") Provider<ConnectionDispatcher> provider3, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<ActivityCallback> provider4, Provider<ConnectionManager> provider5, Provider<IPFilter> provider6, ConnectionServices connectionServices, Provider<UPnPManager> provider7) {
        this.networkManager = networkManager;
        this.udpService = provider;
        this.multicastService = provider2;
        this.connectionDispatcher = provider3;
        this.backgroundExecutor = scheduledExecutorService;
        this.activityCallback = provider4;
        this.connectionManager = provider5;
        this.ipFilter = provider6;
        this.connectionServices = connectionServices;
        this.upnpManager = provider7;
        this.upnpEnabled = !ConnectionSettings.DISABLE_UPNP.getValue();
    }

    private boolean isUPnPEnabled() {
        return this.upnpEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return;
        }
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean bl = false;
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            if (!Arrays.equals(this._address, byArray)) {
                this._address = byArray;
                bl = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl) {
                this.networkManager.addressChanged();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExternalAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            this._externalAddress = byArray;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void init() {
        int n;
        boolean bl;
        block17: {
            int n2;
            bl = ConnectionSettings.PORT.isDefault() && !ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue() && !ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            Random random = null;
            if (bl) {
                random = new Random();
                n2 = random.nextInt(50000) + 2000;
            } else {
                n2 = ConnectionSettings.PORT.getValue();
            }
            try {
                if (this.isUPnPEnabled()) {
                    this.setAddress(NetworkUtils.getLocalAddress());
                } else {
                    this.setAddress(InetAddress.getLocalHost());
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            n = n2;
            try {
                this.setListeningPort(n2);
                this._port = n2;
            }
            catch (IOException iOException) {
                LOG.warn("can't set initial port", iOException);
                int n3 = 20;
                for (int i = 0; i < n3; ++i) {
                    if (random == null) {
                        random = new Random();
                    }
                    n2 = random.nextInt(50000);
                    if ((n2 += 2000) == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++n3;
                        continue;
                    }
                    try {
                        this.setListeningPort(n2);
                        this._port = n2;
                        break;
                    }
                    catch (IOException iOException2) {
                        LOG.warn("can't set port", iOException2);
                    }
                }
                if (this._socket != null) break block17;
                MessageService.showError(I18nMarker.marktr("FrostWire was unable to set up a port to listen for incoming connections. Some features of FrostWire may not work as expected."));
            }
        }
        if (this._port != n || bl) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsGroupManager.instance().save();
            this.networkManager.addressChanged();
        }
        if (this.upnpManager.get().isNATPresent()) {
            this.setupUPnP();
        } else {
            this.upnpManager.get().addListener(new UPnPListener(){

                public void natFound() {
                    AcceptorImpl.this.setupUPnP();
                }
            });
        }
    }

    private void setupUPnP() {
        if (this._socket != null && this.isUPnPEnabled()) {
            boolean bl;
            boolean bl2 = this.upnpManager.get().isNATPresent();
            boolean bl3 = NetworkUtils.isValidPort(this._port);
            boolean bl4 = bl = ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Natted: " + bl2 + ", validPort: " + bl3 + ", forcedIP: " + bl);
            }
            if (bl2 && bl3 && !bl) {
                int n = this.upnpManager.get().mapPort(this._port, this.getAddress(false));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("UPNP port mapped: " + n);
                }
                if (n != 0) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                    ConnectionSettings.FORCED_PORT.setValue(n);
                    ConnectionSettings.UPNP_IN_USE.setValue(true);
                    if (n != this._port) {
                        this.networkManager.addressChanged();
                    }
                    this.resetLastConnectBackTime();
                    this.udpService.get().resetLastConnectBackTime();
                    if (!this.acceptedIncoming()) {
                        this.incomingValidator.run();
                    }
                }
            }
        }
    }

    @Override
    public void start() {
        this.multicastService.get().start();
        this.udpService.get().start();
        this.connectionDispatcher.get().addConnectionAcceptor(this, false, "CONNECT", "\n\n");
        this.backgroundExecutor.scheduleWithFixedDelay(this.incomingValidator, this.timeBetweenValidates, this.timeBetweenValidates, TimeUnit.MILLISECONDS);
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.equals(this.getAddress(true), this._externalAddress);
        }
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getExternalAddress() {
        Class<AcceptorImpl> clazz = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getAddress(boolean bl) {
        Object object;
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            object = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress inetAddress = InetAddress.getByName((String)object);
                byte[] byArray = inetAddress.getAddress();
                if (byArray != null) {
                    return byArray;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        object = AcceptorImpl.class;
        synchronized (AcceptorImpl.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this._address;
        }
    }

    public ConnectionDispatcher getConnectionDispatcher() {
        return this.connectionDispatcher.get();
    }

    @Override
    public int getPort(boolean bl) {
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    @Override
    public void setListeningPort(int n) throws IOException {
        Object object;
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            LOG.trace("shutting off service.");
            IOUtils.close(this._socket);
            this._socket = null;
            this._port = 0;
            this.udpService.get().setListeningSocket(null);
            this.multicastService.get().setListeningSocket(null);
            LOG.trace("service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changing port to " + n);
        }
        DatagramSocket datagramSocket = this.udpService.get().newListeningSocket(n);
        LOG.trace("UDP Service is ready.");
        MulticastSocket multicastSocket = null;
        try {
            object = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            multicastSocket = this.multicastService.get().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), (InetAddress)object);
            LOG.trace("multicast service setup");
        }
        catch (IOException iOException) {
            LOG.warn("can't create multicast socket", iOException);
        }
        object = null;
        try {
            object = SocketFactory.newServerSocket(n, new SocketListener());
        }
        catch (IOException iOException) {
            LOG.warn("can't create ServerSocket", iOException);
            datagramSocket.close();
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("can't create ServerSocket", illegalArgumentException);
            datagramSocket.close();
            throw new IOException("could not create a listening socket");
        }
        IOUtils.close(this._socket);
        this._socket = object;
        this._port = n;
        LOG.trace("Acceptor ready..");
        this.udpService.get().setListeningSocket(datagramSocket);
        if (multicastSocket != null) {
            this.multicastService.get().setListeningSocket(multicastSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("listening UDP/TCP on " + this._port);
        }
    }

    @Override
    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    protected void setAcceptedIncoming(boolean bl) {
        this._acceptedIncoming = bl;
    }

    boolean setIncoming(boolean bl) {
        if (bl) {
            this.incomingValidator.cancelReset();
        }
        if (this._acceptedIncoming == bl) {
            return false;
        }
        this._acceptedIncoming = bl;
        this.activityCallback.get().acceptedIncomingChanged(bl);
        return true;
    }

    @Override
    public void acceptConnection(String string, Socket socket) {
        this.checkFirewall(socket.getInetAddress());
        IOUtils.close(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkFirewall(InetAddress inetAddress) {
        boolean bl = false;
        if (this.isOutsideConnection(inetAddress)) {
            Class<AcceptorImpl> clazz = AcceptorImpl.class;
            // MONITORENTER : com.limegroup.gnutella.AcceptorImpl.class
            bl = this.setIncoming(true);
            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(true);
            // MONITOREXIT : clazz
        }
        if (!bl) return;
        this.networkManager.incomingStatusChanged();
    }

    @Override
    public void processSocket(Socket socket) {
        this.processSocket(socket, null);
    }

    @Override
    public void processSocket(Socket socket, String string) {
        if (!this._started) {
            IOUtils.close(socket);
            return;
        }
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress == null || !NetworkUtils.isValidAddress(inetAddress) || !NetworkUtils.isValidPort(socket.getPort())) {
            IOUtils.close(socket);
            LOG.warn("connection closed while accepting");
        } else if (!this.ipFilter.get().allow(inetAddress.getAddress())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring banned host: " + inetAddress);
            }
            IOUtils.close(socket);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching new client connecton: " + inetAddress);
            }
            InetAddress inetAddress2 = socket.getLocalAddress();
            this.setAddress(inetAddress2);
            try {
                socket.setSoTimeout(8000);
            }
            catch (SocketException socketException) {
                IOUtils.close(socket);
                return;
            }
            if (socket instanceof NIOMultiplexor) {
                ((NIOMultiplexor)((Object)socket)).setReadObserver(new AsyncConnectionDispatcher(this.connectionDispatcher.get(), socket, string));
            } else {
                ThreadExecutor.startThread(new BlockingConnectionDispatcher(this.connectionDispatcher.get(), socket, string), "ConnectionDispatchRunner");
            }
        }
    }

    private boolean isOutsideConnection(InetAddress inetAddress) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        return !this.connectionServices.isConnectedTo(inetAddress) && !NetworkUtils.isLocalAddress(inetAddress);
    }

    @Override
    public void resetLastConnectBackTime() {
        this._lastConnectBackTime = 0L;
    }

    @Override
    public void shutdown() {
        this.shutdownUPnP();
    }

    private void shutdownUPnP() {
        if (this.isUPnPEnabled() && this.upnpManager.get().isNATPresent() && this.upnpManager.get().mappingsExist() && ConnectionSettings.UPNP_IN_USE.getValue()) {
            ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
            ConnectionSettings.FORCED_PORT.revertToDefault();
            ConnectionSettings.UPNP_IN_USE.revertToDefault();
        }
    }

    @Override
    public long getIncomingExpireTime() {
        return this.incomingExpireTime;
    }

    void setIncomingExpireTime(long l) {
        this.incomingExpireTime = l;
    }

    @Override
    public long getWaitTimeAfterRequests() {
        return this.waitTimeAfterRequests;
    }

    void setWaitTimeAfterRequests(long l) {
        this.waitTimeAfterRequests = l;
    }

    @Override
    public long getTimeBetweenValidates() {
        return this.timeBetweenValidates;
    }

    void setTimeBetweenValidates(long l) {
        this.timeBetweenValidates = l;
    }

    private class IncomingValidator
    implements Runnable {
        private final AtomicBoolean validating = new AtomicBoolean(false);
        private AtomicReference<Future<?>> futureRef = new AtomicReference();

        private IncomingValidator() {
        }

        public void run() {
            if (this.validating.getAndSet(true)) {
                return;
            }
            long l = System.currentTimeMillis();
            if (l - AcceptorImpl.this._lastConnectBackTime > AcceptorImpl.this.incomingExpireTime && ((ConnectionManager)AcceptorImpl.this.connectionManager.get()).sendTCPConnectBackRequests()) {
                AcceptorImpl.this._lastConnectBackTime = l;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean bl = false;
                        Class<AcceptorImpl> clazz = AcceptorImpl.class;
                        synchronized (AcceptorImpl.class) {
                            bl = AcceptorImpl.this.setIncoming(false);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (bl) {
                                AcceptorImpl.this.networkManager.incomingStatusChanged();
                            }
                            return;
                        }
                    }
                };
                Future<?> future = this.futureRef.get();
                if (future != null) {
                    future.cancel(false);
                }
                this.futureRef.set(AcceptorImpl.this.backgroundExecutor.schedule(runnable, AcceptorImpl.this.waitTimeAfterRequests, TimeUnit.MILLISECONDS));
            }
            this.validating.set(false);
        }

        void cancelReset() {
            Future<?> future = this.futureRef.get();
            if (future != null) {
                future.cancel(false);
                this.futureRef.compareAndSet(future, null);
            }
        }
    }

    private class SocketListener
    implements AcceptObserver {
        private SocketListener() {
        }

        public void handleIOException(IOException iOException) {
            LOG.warn("IOX while accepting", iOException);
        }

        public void shutdown() {
            LOG.debug("shutdown one SocketListener");
        }

        public void handleAccept(Socket socket) {
            AcceptorImpl.this.processSocket(socket);
        }
    }
}

