/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.tracking;

import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrackerResponse {
    private static final Log LOG = LogFactory.getLog(TrackerResponse.class);
    public final List<TorrentLocation> PEERS;
    public final int INTERVAL;
    public final int NUM_PEERS;
    public final int DONE_PEERS;
    public final String FAILURE_REASON;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TrackerResponse(Object object) throws ValueException {
        if (!(object instanceof Map)) {
            throw new ValueException("bad tracker response");
        }
        Map map = (Map)object;
        if (map.containsKey("failure reason")) {
            void var4_9;
            byte[] byArray = (byte[])map.get("failure reason");
            String string = StringUtils.getASCIIString(byArray);
            if (string.length() > 256) {
                String string2 = string.substring(0, 255);
            }
            this.FAILURE_REASON = var4_9;
        } else {
            this.FAILURE_REASON = null;
        }
        if (map.containsKey("peers")) {
            Object v = map.get("peers");
            if (v instanceof List) {
                this.PEERS = TrackerResponse.parsePeers((List)v);
            } else {
                if (!(v instanceof byte[])) throw new ValueException("bad tracker response - bad peers " + v);
                this.PEERS = TrackerResponse.parsePeers((byte[])v);
            }
        } else {
            this.PEERS = Collections.emptyList();
        }
        Object v = map.get("interval");
        Object v2 = map.get("min_interval");
        int n = v instanceof Long ? (int)((Long)v).longValue() : (v2 instanceof Long ? (int)((Long)v).longValue() : BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue());
        this.INTERVAL = n < BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue() ? BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue() : (n > BittorrentSettings.TRACKER_MAX_REASK_INTERVAL.getValue() ? BittorrentSettings.TRACKER_MAX_REASK_INTERVAL.getValue() : n);
        Object v3 = map.get("num peers");
        this.NUM_PEERS = v3 instanceof Long ? (int)((Long)v3).longValue() : ((v3 = map.get("incomplete")) instanceof Long ? (int)((Long)v3).longValue() : 0);
        Object v4 = map.get("num done");
        this.DONE_PEERS = v4 instanceof Long ? (int)((Long)v4).longValue() : ((v4 = map.get("complete")) instanceof Long ? (int)((Long)v4).longValue() : 0);
    }

    TrackerResponse(List<TorrentLocation> list, int n, int n2, int n3, String string) {
        this.PEERS = list;
        this.INTERVAL = Math.min(Math.max(n, BittorrentSettings.TRACKER_MIN_REASK_INTERVAL.getValue()), BittorrentSettings.TRACKER_MAX_REASK_INTERVAL.getValue());
        this.NUM_PEERS = Math.max(0, n2);
        this.DONE_PEERS = Math.max(0, n3);
        this.FAILURE_REASON = string;
    }

    private static List<TorrentLocation> parsePeers(List list) throws ValueException {
        ArrayList<TorrentLocation> arrayList = new ArrayList<TorrentLocation>();
        for (Object e : list) {
            if (!(e instanceof Map)) {
                throw new ValueException("bad tracker response - bad peer " + e);
            }
            arrayList.add(TrackerResponse.parsePeer((Map)e));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static List<TorrentLocation> parsePeers(byte[] byArray) throws ValueException {
        boolean bl = false;
        ArrayList<TorrentLocation> arrayList = new ArrayList<TorrentLocation>();
        for (int i = 0; i < byArray.length - 5; i += 6) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, i, byArray2, 0, 4);
            int n = ByteOrder.beb2int(byArray, i + 4, 2);
            if (!NetworkUtils.isValidPort(n)) {
                bl = true;
                continue;
            }
            try {
                InetAddress inetAddress = InetAddress.getByAddress(byArray2);
                arrayList.add(TrackerResponse.parsePeer(inetAddress, n, null));
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                bl = true;
            }
        }
        if (arrayList.isEmpty() && bl) {
            throw new ValueException("no peers or all invalid");
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static TorrentLocation parsePeer(Map map) throws ValueException {
        InetAddress inetAddress;
        String string;
        Object v = map.get("ip");
        if (!(v instanceof byte[])) {
            throw new ValueException("bad tracker response - bad peer ip " + v);
        }
        try {
            string = new String((byte[])v, "ISO-8859-1");
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ValueException("bad tracker response - bad peer ip " + v);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
            return null;
        }
        string = map.get("port");
        if (!(string instanceof Long)) {
            throw new ValueException("bad tracker response - bad peer port " + string);
        }
        int n = (int)((Long)((Object)string)).longValue();
        Object v2 = map.get("peer id");
        if (!(v2 instanceof byte[])) {
            throw new ValueException("bad tracker response - bad peer id ");
        }
        byte[] byArray = (byte[])v2;
        if (byArray.length != 20) {
            throw new ValueException("bad tracker response - bad peer id ");
        }
        return TrackerResponse.parsePeer(inetAddress, n, byArray);
    }

    private static TorrentLocation parsePeer(InetAddress inetAddress, int n, byte[] byArray) throws ValueException {
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new ValueException("bad tracker response - bad peer ip " + inetAddress);
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new ValueException("bad tracker response - bad peer port " + n);
        }
        TorrentLocation torrentLocation = new TorrentLocation(inetAddress, n, byArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug("got peer " + torrentLocation);
        }
        return torrentLocation;
    }

    public String toString() {
        return "tracker response: min interval " + this.INTERVAL + "," + this.DONE_PEERS + "/" + this.NUM_PEERS + (this.FAILURE_REASON != null ? this.FAILURE_REASON : "") + ", num peers: " + this.PEERS.size();
    }
}

