/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.handshaking;

import com.limegroup.bittorrent.BTConnection;
import com.limegroup.bittorrent.BTConnectionFactory;
import com.limegroup.bittorrent.ManagedTorrent;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.handshaking.BTHandshakeObserver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;

abstract class BTHandshaker
implements ChannelWriter,
ChannelReadObserver,
IpPort {
    private static final Log LOG = LogFactory.getLog(BTHandshaker.class);
    protected ManagedTorrent torrent;
    protected BTHandshakeObserver observer;
    protected ByteBuffer outgoingHandshake;
    protected ByteBuffer[] incomingHandshake;
    protected int currentBufIndex;
    protected InterestWritableByteChannel writeChannel;
    protected InterestScatteringByteChannel readChannel;
    protected boolean incomingDone;
    protected boolean finishingHandshakes;
    protected volatile boolean shutdown;
    protected final TorrentLocation loc;
    protected final AbstractNBSocket sock;
    private final BTConnectionFactory btcFactory;

    protected BTHandshaker(TorrentLocation torrentLocation, AbstractNBSocket abstractNBSocket, BTConnectionFactory bTConnectionFactory) {
        this.loc = torrentLocation;
        this.sock = abstractNBSocket;
        this.btcFactory = bTConnectionFactory;
    }

    public abstract void startHandshaking();

    public void handleRead() throws IOException {
        if (this.shutdown) {
            return;
        }
        long l = 0L;
        while ((l = this.readChannel.read(this.incomingHandshake)) > 0L && this.incomingHandshake[this.incomingHandshake.length - 1].hasRemaining()) {
        }
        if (l == -1L || !this.verifyIncoming()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("bad incoming handshake on element " + this.currentBufIndex + " or channel closed " + l);
            }
            this.shutdown();
            return;
        }
        if (!this.incomingHandshake[this.incomingHandshake.length - 1].hasRemaining()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("incoming handshake finished " + this.sock.getInetAddress());
            }
            this.incomingDone = true;
        }
        this.tryToFinishHandshakes();
    }

    protected abstract boolean verifyIncoming();

    public boolean handleWrite() throws IOException {
        if (this.shutdown) {
            return false;
        }
        while (this.outgoingHandshake.hasRemaining() && this.writeChannel.write(this.outgoingHandshake) > 0) {
        }
        if (!this.outgoingHandshake.hasRemaining()) {
            this.writeChannel.interestWrite(this, false);
        }
        this.tryToFinishHandshakes();
        return true;
    }

    protected abstract void initIncomingHandshake();

    protected void initOutgoingHandshake() {
        this.outgoingHandshake = this.torrent.getFetcher().getOutgoingHandshake();
    }

    protected final void setReadInterest() {
        this.sock.setReadObserver(this);
        this.readChannel.interestRead(true);
    }

    protected final void setWriteInterest() {
        this.sock.setWriteObserver(this);
        this.writeChannel.interestWrite(this, true);
    }

    private void tryToFinishHandshakes() {
        if (this.finishingHandshakes || this.shutdown) {
            return;
        }
        if (this.incomingDone && !this.outgoingHandshake.hasRemaining()) {
            this.finishingHandshakes = true;
            if (this.torrent.shouldAddConnection(this.loc)) {
                BTConnection bTConnection = this.btcFactory.createBTConnection(this.torrent.getContext(), this.loc);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("created connection " + this.sock.getInetAddress().getHostAddress());
                }
                if (this.torrent.addConnection(bTConnection)) {
                    bTConnection.init(this.sock, this.torrent, this.torrent.getNetworkScheduledExecutorService());
                }
                this.observer.handshakerDone(this);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("have enough connections, remembering loc " + this.loc);
                }
                this.torrent.addEndpoint(this.loc);
                this.shutdown();
            }
        }
    }

    public void handleIOException(IOException iOException) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BTHandshaker bTHandshaker = this;
        synchronized (bTHandshaker) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (this.observer != null) {
            this.observer.handshakerDone(this);
        }
        this.sock.close();
    }

    public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
        this.writeChannel = interestWritableByteChannel;
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.writeChannel;
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this.readChannel = (InterestScatteringByteChannel)interestReadableByteChannel;
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.readChannel;
    }

    public String getAddress() {
        return this.loc.getAddress();
    }

    public InetAddress getInetAddress() {
        return this.loc.getInetAddress();
    }

    public int getPort() {
        return this.loc.getPort();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.loc.getInetSocketAddress();
    }

    public String toString() {
        return "shaker finishing handshakes " + this.finishingHandshakes + " incoming done " + this.incomingDone + " current buf " + this.currentBufIndex + " shutdown " + this.shutdown;
    }
}

