/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.gui;

import com.frostwire.GuiFrostWireUtils;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.gui.TorrentDownloadFactory;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.swing.SwingUtilities;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.limewire.io.IOUtils;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.util.FileUtils;

public class TorrentFileFetcher
implements HttpClientListener,
CoreDownloader {
    private static final int TIMEOUT = 5000;
    private final URI torrentURI;
    private volatile boolean stopped;
    private volatile boolean failed;
    private volatile URN urn;
    private volatile Shutdownable aborter;
    private volatile CoreDownloader delegate;

    public TorrentFileFetcher(URI uRI, SaveLocationManager saveLocationManager) {
        this.torrentURI = uRI;
    }

    public void fetch() {
        HttpGet httpGet = new HttpGet(this.torrentURI);
        httpGet.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        httpGet.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(basicHttpParams, 5000);
        HttpConnectionParams.setSoTimeout(basicHttpParams, 5000);
        HttpClientParams.setRedirecting(basicHttpParams, true);
        this.aborter = GuiCoreMediator.getHttpExecutor().execute(httpGet, basicHttpParams, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestComplete(HttpUriRequest httpUriRequest, HttpResponse httpResponse) {
        Object object;
        Object object2;
        this.aborter = null;
        if (this.stopped) {
            return false;
        }
        Object object3 = null;
        byte[] byArray = null;
        try {
            if (httpResponse.getEntity() != null) {
                byArray = IOUtils.readFully(httpResponse.getEntity().getContent());
            }
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, downloading .torrent file " + httpResponse.getStatusLine().getStatusCode());
            }
            if (byArray == null || byArray.length == 0) {
                throw new IOException("invalid response");
            }
            object3 = BTMetaInfo.readFromBytes(byArray);
            object2 = this;
            synchronized (object2) {
                this.urn = ((BTMetaInfo)object3).getURN();
            }
        }
        catch (SaveLocationException saveLocationException) {
            GUIMediator.showWarning(I18n.tr("The selected .torrent file may contain a security hazard."));
        }
        catch (IOException iOException) {
            GUIMediator.showWarning(I18n.tr("FrostWire could not download a .torrent file from the provided URL."));
        }
        finally {
            GuiCoreMediator.getHttpExecutor().releaseResources(httpResponse);
        }
        if (object3 == null) {
            this.removeDataLine();
            return false;
        }
        if (SharingSettings.SHARE_TORRENT_META_FILES.getValue()) {
            object2 = GuiCoreMediator.getTorrentManager().getSharedTorrentMetaDataFile((BTMetaInfo)object3);
            GuiCoreMediator.getFileManager().stopSharingFile((File)object2);
            object = null;
            if (((File)object2).exists()) {
                object = new File(((File)object2).getParent(), ((File)object2).getName().concat(".bak"));
                FileUtils.forceRename((File)object2, (File)object);
            }
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object2));
                ((OutputStream)bufferedOutputStream).write(byArray);
                ((OutputStream)bufferedOutputStream).flush();
                if (object != null) {
                    ((File)object).delete();
                }
                IOUtils.close(bufferedOutputStream);
            }
            catch (IOException iOException) {
                if (object != null && FileUtils.forceRename((File)object, (File)object2)) {
                    GuiCoreMediator.getFileManager().addFileIfShared((File)object2);
                }
            }
            finally {
                IOUtils.close(bufferedOutputStream);
            }
        }
        object2 = object3;
        object = new Runnable((BTMetaInfo)object2){
            final /* synthetic */ BTMetaInfo val$toDownload;
            {
                this.val$toDownload = bTMetaInfo;
            }

            public void run() {
                TorrentDownloadFactory torrentDownloadFactory = new TorrentDownloadFactory(this.val$toDownload);
                CoreDownloader coreDownloader = (CoreDownloader)DownloaderUtils.createDownloader(torrentDownloadFactory);
                if (coreDownloader != null) {
                    TorrentFileFetcher.this.delegate = coreDownloader;
                } else {
                    TorrentFileFetcher.this.stopped = true;
                    TorrentFileFetcher.this.removeDataLine();
                }
            }
        };
        GuiFrostWireUtils.shareTorrent((BTMetaInfo)object3, byArray);
        SwingUtilities.invokeLater((Runnable)object);
        return false;
    }

    private synchronized void removeDataLine() {
        this.failed = true;
        this.urn = null;
        GuiCoreMediator.getActivityCallback().removeDownload(this);
    }

    public boolean requestFailed(HttpUriRequest httpUriRequest, HttpResponse httpResponse, IOException iOException) {
        assert (this.delegate == null);
        this.failed = true;
        return false;
    }

    public void discardCorruptDownload(boolean bl) {
    }

    public long getAmountLost() {
        return this.delegate == null ? 0L : this.delegate.getAmountLost();
    }

    public int getAmountPending() {
        return this.delegate == null ? 0 : this.delegate.getAmountPending();
    }

    public long getAmountRead() {
        return this.delegate == null ? 0L : this.delegate.getAmountRead();
    }

    public long getAmountVerified() {
        return this.delegate == null ? 0L : this.delegate.getAmountVerified();
    }

    public Object getAttribute(String string) {
        return this.delegate == null ? null : this.delegate.getAttribute(string);
    }

    public RemoteFileDesc getBrowseEnabledHost() {
        return this.delegate == null ? null : this.delegate.getBrowseEnabledHost();
    }

    public int getBusyHostCount() {
        return this.delegate == null ? 0 : this.delegate.getBusyHostCount();
    }

    public Endpoint getChatEnabledHost() {
        return this.delegate == null ? null : this.delegate.getChatEnabledHost();
    }

    public int getChunkSize() {
        return this.delegate == null ? 1 : this.delegate.getChunkSize();
    }

    public long getContentLength() {
        return this.delegate == null ? 0L : this.delegate.getContentLength();
    }

    public File getDownloadFragment() {
        return this.delegate == null ? null : this.delegate.getDownloadFragment();
    }

    public File getFile() {
        return this.delegate == null ? null : this.delegate.getFile();
    }

    public int getInactivePriority() {
        return this.delegate == null ? 0 : this.delegate.getInactivePriority();
    }

    public int getNumHosts() {
        return this.delegate == null ? 0 : this.delegate.getNumHosts();
    }

    public int getNumberOfAlternateLocations() {
        return this.delegate == null ? 0 : this.delegate.getNumberOfAlternateLocations();
    }

    public int getNumberOfInvalidAlternateLocations() {
        return this.delegate == null ? 0 : this.delegate.getNumberOfInvalidAlternateLocations();
    }

    public int getPossibleHostCount() {
        return this.delegate == null ? 0 : this.delegate.getPossibleHostCount();
    }

    public int getQueuePosition() {
        return this.delegate == null ? 0 : this.delegate.getQueuePosition();
    }

    public int getQueuedHostCount() {
        return this.delegate == null ? 0 : this.delegate.getQueuedHostCount();
    }

    public int getRemainingStateTime() {
        return this.delegate == null ? 0 : this.delegate.getRemainingStateTime();
    }

    public URN getSha1Urn() {
        return this.delegate == null ? null : this.delegate.getSha1Urn();
    }

    public File getSaveFile() {
        int n;
        if (this.delegate != null) {
            return this.delegate.getSaveFile();
        }
        String string = this.torrentURI.toString();
        String string2 = null;
        if (string.endsWith(".torrent") && (n = string.lastIndexOf("/")) != -1) {
            string2 = string.substring(n);
        }
        if (string2 == null) {
            string2 = string;
        }
        return new File(string);
    }

    public Downloader.DownloadStatus getState() {
        if (this.stopped) {
            return Downloader.DownloadStatus.ABORTED;
        }
        if (this.failed) {
            return Downloader.DownloadStatus.GAVE_UP;
        }
        if (this.delegate == null) {
            return Downloader.DownloadStatus.FETCHING;
        }
        return this.delegate.getState();
    }

    public String getVendor() {
        return this.delegate == null ? null : this.delegate.getVendor();
    }

    public boolean hasBrowseEnabledHost() {
        return this.delegate == null ? false : this.delegate.hasBrowseEnabledHost();
    }

    public boolean hasChatEnabledHost() {
        return this.delegate == null ? false : this.delegate.hasChatEnabledHost();
    }

    public boolean isCompleted() {
        return this.delegate == null ? this.failed || this.stopped : this.delegate.isCompleted();
    }

    public boolean isInactive() {
        return this.delegate == null ? false : this.delegate.isInactive();
    }

    public boolean isLaunchable() {
        return this.delegate == null ? false : this.delegate.isLaunchable();
    }

    public boolean isPausable() {
        return this.delegate == null ? false : this.delegate.isPausable();
    }

    public boolean isPaused() {
        return this.delegate == null ? false : this.delegate.isPaused();
    }

    public boolean isRelocatable() {
        return this.delegate == null ? false : this.delegate.isRelocatable();
    }

    public boolean isResumable() {
        return this.delegate == null ? false : this.delegate.isResumable();
    }

    public void pause() {
        if (this.delegate != null) {
            this.delegate.pause();
        }
    }

    public Object removeAttribute(String string) {
        return this.delegate == null ? null : this.delegate.removeAttribute(string);
    }

    public boolean resume() {
        return this.delegate == null ? false : this.delegate.resume();
    }

    public Object setAttribute(String string, Object object, boolean bl) {
        return this.delegate == null ? null : this.delegate.setAttribute(string, object, bl);
    }

    public void setSaveFile(File file, String string, boolean bl) throws SaveLocationException {
        if (this.delegate != null) {
            this.delegate.setSaveFile(file, string, bl);
        }
    }

    public void stop() {
        if (this.delegate != null) {
            this.delegate.stop();
        } else {
            this.stopped = true;
            if (this.aborter != null) {
                this.aborter.shutdown();
                this.aborter = null;
            }
        }
    }

    public float getAverageBandwidth() {
        return this.delegate == null ? 0.0f : this.delegate.getAverageBandwidth();
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.delegate == null ? 0.0f : this.delegate.getMeasuredBandwidth();
    }

    public void measureBandwidth() {
        if (this.delegate != null) {
            this.delegate.measureBandwidth();
        }
    }

    public synchronized boolean equals(Object object) {
        if (this.urn == null) {
            return super.equals(object);
        }
        if (!(object instanceof Downloader)) {
            return false;
        }
        Downloader downloader = (Downloader)object;
        return this.urn.equals(downloader.getSha1Urn());
    }

    public int getTriedHostCount() {
        return -1;
    }

    public String getCustomIconDescriptor() {
        return this.delegate == null ? null : this.delegate.getCustomIconDescriptor();
    }

    public boolean conflicts(URN uRN, long l, File ... fileArray) {
        return this.delegate.conflicts(uRN, l, fileArray);
    }

    public boolean conflictsSaveFile(File file) {
        return this.delegate.conflictsSaveFile(file);
    }

    public boolean conflictsWithIncompleteFile(File file) {
        return this.delegate.conflictsWithIncompleteFile(file);
    }

    public void finish() {
        this.delegate.finish();
    }

    public GUID getQueryGUID() {
        return this.delegate.getQueryGUID();
    }

    public void handleInactivity() {
        this.delegate.handleInactivity();
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public boolean isAlive() {
        return this.delegate.isAlive();
    }

    public boolean isQueuable() {
        return this.delegate.isQueuable();
    }

    public void setInactivePriority(int n) {
        this.delegate.setInactivePriority(n);
    }

    public boolean shouldBeRemoved() {
        return this.delegate.shouldBeRemoved();
    }

    public boolean shouldBeRestarted() {
        return this.delegate.shouldBeRestarted();
    }

    public void startDownload() {
        this.delegate.startDownload();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public DownloaderType getDownloadType() {
        return DownloaderType.TORRENTFETCHER;
    }

    public DownloadMemento toMemento() {
        throw new IllegalStateException("should not be serializing!");
    }

    public void initFromMemento(DownloadMemento downloadMemento) {
        throw new IllegalStateException("should not be deserialized!");
    }

    public void setOverwrite(boolean bl) {
    }
}

