/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.choking;

import com.limegroup.bittorrent.Chokable;
import com.limegroup.bittorrent.settings.BittorrentSettings;
import com.limegroup.gnutella.UploadServices;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NECallable;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Choker
implements Runnable,
Shutdownable {
    private static final Log LOG = LogFactory.getLog(Choker.class);
    private static final int RECHOKE_TIMEOUT = 10000;
    protected final ScheduledExecutorService invoker;
    protected final NECallable<List<? extends Chokable>> chokablesSource;
    protected int round;
    private volatile Future periodic;
    private final Runnable immediateChoker = new ImmediateChoker();
    private final UploadServices uploadServices;

    Choker(NECallable<List<? extends Chokable>> nECallable, ScheduledExecutorService scheduledExecutorService, UploadServices uploadServices) {
        this.invoker = scheduledExecutorService;
        this.chokablesSource = nECallable;
        this.uploadServices = uploadServices;
    }

    @Override
    public void shutdown() {
        if (this.periodic != null) {
            this.periodic.cancel(false);
        }
    }

    public void start() {
        this.shutdown();
        this.periodic = this.invoker.schedule(this, 10000L, TimeUnit.MILLISECONDS);
    }

    public final void rechoke() {
        this.invoker.execute(this.immediateChoker);
    }

    protected abstract void rechokeImpl(boolean var1);

    @Override
    public void run() {
        ++this.round;
        if (LOG.isDebugEnabled()) {
            LOG.debug("scheduling rechoke");
        }
        this.rechokeImpl(true);
        this.periodic = this.invoker.schedule(this, 10000L, TimeUnit.MILLISECONDS);
    }

    protected int getNumUploads() {
        int n = BittorrentSettings.TORRENT_MAX_UPLOADS.getValue();
        if (n > 0) {
            return n;
        }
        float f = this.uploadServices.getRequestedUploadSpeed();
        if (f == Float.MAX_VALUE) {
            return 7;
        }
        if (f < 9000.0f) {
            return 2;
        }
        if (f < 15000.0f) {
            return 3;
        }
        if (f < 42000.0f) {
            return 4;
        }
        return (int)Math.sqrt(f * 0.6f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpeedComparator
    implements Comparator<Chokable> {
        private final boolean download;

        public SpeedComparator(boolean bl) {
            this.download = bl;
        }

        @Override
        public int compare(Chokable chokable, Chokable chokable2) {
            float f;
            if (chokable == chokable2) {
                return 0;
            }
            float f2 = chokable.getMeasuredBandwidth(this.download, false);
            if (f2 == (f = chokable2.getMeasuredBandwidth(this.download, false))) {
                return 0;
            }
            if (f2 > f) {
                return -1;
            }
            return 1;
        }
    }

    private class ImmediateChoker
    implements Runnable {
        private ImmediateChoker() {
        }

        public void run() {
            Choker.this.rechokeImpl(false);
        }
    }
}

