/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.bencoding;

import com.limegroup.bittorrent.bencoding.BEBoolean;
import com.limegroup.bittorrent.bencoding.BEDictionary;
import com.limegroup.bittorrent.bencoding.BEList;
import com.limegroup.bittorrent.bencoding.BELong;
import com.limegroup.bittorrent.bencoding.BEString;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.util.BEncoder;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Token<T> {
    protected static final int INTERNAL = -1;
    public static final int LONG = 0;
    public static final int STRING = 1;
    public static final int LIST = 2;
    public static final int DICTIONARY = 3;
    public static final int BOOLEAN = 4;
    protected static final String ASCII = "ISO-8859-1";
    protected static final byte ZERO;
    protected static final byte NINE;
    protected final ReadableByteChannel chan;
    protected T result;
    static final EndElement TERMINATOR;

    public Token(ReadableByteChannel readableByteChannel) {
        this.chan = readableByteChannel;
    }

    public abstract void handleRead() throws IOException;

    protected abstract boolean isDone();

    public int getType() {
        return -1;
    }

    public T getResult() {
        if (!this.isDone()) {
            return null;
        }
        return this.result;
    }

    public static Token<?> getNextToken(ReadableByteChannel readableByteChannel) throws IOException {
        byte[] byArray = new byte[1];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = readableByteChannel.read(byteBuffer);
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            throw new EOFException("Could not read next Token");
        }
        if (byArray[0] == BEncoder.I) {
            return new BELong(readableByteChannel);
        }
        if (byArray[0] == BEncoder.D) {
            return new BEDictionary(readableByteChannel);
        }
        if (byArray[0] == BEncoder.L) {
            return new BEList(readableByteChannel);
        }
        if (byArray[0] == BEncoder.E) {
            return TERMINATOR;
        }
        if (byArray[0] >= ZERO && byArray[0] <= NINE) {
            return new BEString(byArray[0], readableByteChannel);
        }
        if (byArray[0] == BEncoder.TRUE || byArray[0] == BEncoder.FALSE) {
            return byArray[0] == BEncoder.TRUE ? BEBoolean.TRUE : BEBoolean.FALSE;
        }
        throw new IOException("unrecognized token type " + (char)byArray[0]);
    }

    public static Object parse(byte[] byArray) throws IOException {
        Token<?> token = Token.getNextToken(new BufferChannel(byArray));
        if (token == null) {
            return null;
        }
        token.handleRead();
        return token.getResult();
    }

    static {
        byte by = 0;
        byte by2 = 0;
        try {
            by = "0".getBytes(ASCII)[0];
            by2 = "9".getBytes(ASCII)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ZERO = by;
        NINE = by2;
        TERMINATOR = new EndElement();
    }

    private static class BufferChannel
    implements ReadableByteChannel {
        private final ByteBuffer src;

        BufferChannel(byte[] byArray) {
            this.src = ByteBuffer.wrap(byArray);
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            int n = BufferUtils.transfer(this.src, byteBuffer, false);
            if (n == 0 && !this.src.hasRemaining()) {
                return -1;
            }
            return n;
        }

        public void close() throws IOException {
        }

        public boolean isOpen() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndElement
    extends Token<EndElement> {
        EndElement() {
            super(null);
            this.result = this;
        }

        @Override
        public void handleRead() throws IOException {
        }

        @Override
        protected boolean isDone() {
            return true;
        }
    }
}

