/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTLink;
import com.limegroup.bittorrent.Chokable;
import com.limegroup.bittorrent.TorrentLocation;
import com.limegroup.bittorrent.messages.BTHave;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.limewire.collection.NECallable;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTLinkManager
implements Shutdownable,
NECallable<List<? extends Chokable>> {
    private final List<BTLink> _connections = new ArrayList<BTLink>();
    private final Set<TorrentLocation> endpoints = new StrictIpPortSet<TorrentLocation>();

    BTLinkManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ArrayList<BTLink> arrayList;
        BTLinkManager bTLinkManager = this;
        synchronized (bTLinkManager) {
            this.endpoints.clear();
            arrayList = new ArrayList<BTLink>(this._connections);
            this._connections.clear();
        }
        for (BTLink bTLink : arrayList) {
            bTLink.shutdown();
        }
    }

    @Override
    public synchronized List<? extends Chokable> call() {
        return new ArrayList<BTLink>(this._connections);
    }

    public synchronized void sendHave(BTHave bTHave) {
        for (BTLink bTLink : this._connections) {
            bTLink.sendHave(bTHave);
        }
    }

    public synchronized int getNumConnections() {
        return this._connections.size();
    }

    public synchronized void addLink(BTLink bTLink) {
        this._connections.add(bTLink);
        this.endpoints.add(bTLink.getEndpoint());
    }

    public synchronized void removeLink(BTLink bTLink) {
        this._connections.remove(bTLink);
        this.endpoints.remove(bTLink.getEndpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSeedsChokeRest() {
        ArrayList<BTLink> arrayList = new ArrayList<BTLink>(this._connections.size());
        ArrayList<BTLink> arrayList2 = new ArrayList<BTLink>(this._connections.size());
        Iterator iterator = this;
        synchronized (iterator) {
            for (BTLink bTLink : this._connections) {
                if (bTLink.isSeed()) {
                    arrayList.add(bTLink);
                    continue;
                }
                arrayList2.add(bTLink);
            }
        }
        for (BTLink bTLink : arrayList) {
            bTLink.shutdown();
        }
        for (BTLink bTLink : arrayList2) {
            bTLink.suspendTraffic();
        }
    }

    public synchronized boolean isConnectedTo(TorrentLocation torrentLocation) {
        return this.endpoints.contains(torrentLocation);
    }

    public synchronized int getNumNonInterestingPeers() {
        int n = 0;
        for (BTLink bTLink : this._connections) {
            if (bTLink.isInteresting()) continue;
            ++n;
        }
        return n;
    }

    public synchronized int getNumChockingPeers() {
        int n = 0;
        for (BTLink bTLink : this._connections) {
            if (!bTLink.isChoking()) continue;
            ++n;
        }
        return n;
    }

    public List<BTLink> getConnections() {
        return this._connections;
    }

    public synchronized void measureBandwidth() {
        for (BTLink bTLink : this._connections) {
            bTLink.measureBandwidth();
        }
    }

    public synchronized float getMeasuredBandwidth(boolean bl) {
        float f = 0.0f;
        for (BTLink bTLink : this._connections) {
            f += bTLink.getMeasuredBandwidth(bl, true);
        }
        return f;
    }

    public synchronized boolean hasUploading() {
        for (BTLink bTLink : this._connections) {
            if (!bTLink.isUploading()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasUnchoked() {
        if (this._connections.isEmpty()) {
            return false;
        }
        for (BTLink bTLink : this._connections) {
            if (bTLink.isChoked()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean hasInterested() {
        if (this._connections.isEmpty()) {
            return false;
        }
        for (BTLink bTLink : this._connections) {
            if (bTLink.isInterested()) continue;
            return true;
        }
        return false;
    }
}

