/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.disk.DiskManagerFactory;
import com.limegroup.bittorrent.disk.TorrentDiskManager;
import org.limewire.collection.BitField;
import org.limewire.collection.BitFieldSet;
import org.limewire.collection.BitSet;

public class BTContext
implements TorrentContext {
    private final BTMetaInfo info;
    private final BitSet fullSet = new FullBitSet();
    private final BitField fullBitField;
    private TorrentDiskManager diskManager;
    private final DiskManagerFactory diskManagerFactory;

    BTContext(BTMetaInfo bTMetaInfo, DiskManagerFactory diskManagerFactory) {
        this.diskManagerFactory = diskManagerFactory;
        this.info = bTMetaInfo;
        bTMetaInfo.setContext(this);
        this.fullBitField = new BitFieldSet(this.fullSet, bTMetaInfo.getNumBlocks());
        this.initializeDiskManager(false);
    }

    public TorrentDiskManager getDiskManager() {
        return this.diskManager;
    }

    public TorrentFileSystem getFileSystem() {
        return this.info.getFileSystem();
    }

    public BitField getFullBitField() {
        return this.fullBitField;
    }

    public BitSet getFullBitSet() {
        return this.fullSet;
    }

    public BTMetaInfo getMetaInfo() {
        return this.info;
    }

    public void initializeDiskManager(boolean bl) {
        this.diskManager = this.diskManagerFactory.getManager(this, this.info.getDiskManagerData(), bl);
    }

    private class FullBitSet
    extends BitSet {
        private static final long serialVersionUID = -2621319856548383315L;

        private FullBitSet() {
        }

        public void set(int n) {
        }

        public void clear(int n) {
        }

        public boolean get(int n) {
            return true;
        }

        public int cardinality() {
            return BTContext.this.info.getNumBlocks();
        }

        public int length() {
            return BTContext.this.info.getNumBlocks();
        }

        public int nextSetBit(int n) {
            if (n >= this.cardinality()) {
                return -1;
            }
            return n;
        }
    }
}

