/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonEngine {
    private Gson _gson;

    public JsonEngine() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this._gson = gsonBuilder.create();
    }

    public String toJson(Object object) {
        return this._gson.toJson(object);
    }

    public <T> T toObject(String string, Class<T> clazz) {
        return this._gson.fromJson(string, clazz);
    }

    public <T, L extends List<?>> List<T> toList(String string, Class<T> clazz, TypeToken<L> typeToken) {
        return (List)this._gson.fromJson(string, typeToken.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TypeToken<T> {
        final Class<? super T> rawType;
        final Type type;

        protected TypeToken() {
            this.type = TypeToken.getSuperclassTypeParameter(this.getClass());
            this.rawType = TypeToken.getRawType(this.type);
        }

        private TypeToken(Type type) {
            this.rawType = TypeToken.getRawType(TypeToken.nonNull(type, "type"));
            this.type = type;
        }

        private static <T> T nonNull(T t, String string) {
            if (t == null) {
                throw new NullPointerException(string);
            }
            return t;
        }

        static Type getSuperclassTypeParameter(Class<?> clazz) {
            Type type = clazz.getGenericSuperclass();
            if (type instanceof Class) {
                throw new RuntimeException("Missing type parameter.");
            }
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }

        static TypeToken<?> fromSuperclassTypeParameter(Class<?> clazz) {
            return new SimpleTypeToken(clazz);
        }

        private static Class<?> getRawType(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type type2 = parameterizedType.getRawType();
                if (type2 instanceof Class) {
                    return (Class)type2;
                }
                throw TypeToken.buildUnexpectedTypeError(type2, Class.class);
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                Object object = Array.newInstance(TypeToken.getRawType(genericArrayType.getGenericComponentType()), 0);
                return object.getClass();
            }
            throw TypeToken.buildUnexpectedTypeError(type, ParameterizedType.class, GenericArrayType.class);
        }

        public Class<? super T> getRawType() {
            return this.rawType;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isAssignableFrom(Class<?> clazz) {
            return this.isAssignableFrom((Type)clazz);
        }

        public boolean isAssignableFrom(Type type) {
            if (type == null) {
                return false;
            }
            if (this.type.equals(type)) {
                return true;
            }
            if (this.type instanceof Class) {
                return this.rawType.isAssignableFrom(TypeToken.getRawType(type));
            }
            if (this.type instanceof ParameterizedType) {
                return TypeToken.isAssignableFrom(type, (ParameterizedType)this.type, new HashMap<String, Type>());
            }
            if (this.type instanceof GenericArrayType) {
                return this.rawType.isAssignableFrom(TypeToken.getRawType(type)) && TypeToken.isAssignableFrom(type, (GenericArrayType)this.type);
            }
            throw TypeToken.buildUnexpectedTypeError(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
        }

        public boolean isAssignableFrom(TypeToken<?> typeToken) {
            return this.isAssignableFrom(typeToken.getType());
        }

        private static boolean isAssignableFrom(Type type, GenericArrayType genericArrayType) {
            Type type2 = genericArrayType.getGenericComponentType();
            if (type2 instanceof ParameterizedType) {
                Type type3 = type;
                if (type instanceof GenericArrayType) {
                    type3 = ((GenericArrayType)type).getGenericComponentType();
                } else if (type instanceof Class) {
                    Class<?> clazz = (Class<?>)type;
                    while (clazz.isArray()) {
                        clazz = clazz.getComponentType();
                    }
                    type3 = clazz;
                }
                return TypeToken.isAssignableFrom(type3, (ParameterizedType)type2, new HashMap<String, Type>());
            }
            return true;
        }

        private static boolean isAssignableFrom(Type type, ParameterizedType parameterizedType, Map<String, Type> map) {
            if (type == null) {
                return false;
            }
            if (parameterizedType.equals(type)) {
                return true;
            }
            Class<?> clazz = TypeToken.getRawType(type);
            ParameterizedType parameterizedType2 = null;
            if (type instanceof ParameterizedType) {
                parameterizedType2 = (ParameterizedType)type;
            }
            if (parameterizedType2 != null) {
                Type[] object = parameterizedType2.getActualTypeArguments();
                TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
                for (int i = 0; i < object.length; ++i) {
                    Type type2 = object[i];
                    TypeVariable<Class<?>> typeVariable = typeVariableArray[i];
                    while (type2 instanceof TypeVariable) {
                        TypeVariable typeVariable2 = (TypeVariable)type2;
                        type2 = map.get(typeVariable2.getName());
                    }
                    map.put(typeVariable.getName(), type2);
                }
                if (TypeToken.typeEquals(parameterizedType2, parameterizedType, map)) {
                    return true;
                }
            }
            for (Type type2 : clazz.getGenericInterfaces()) {
                if (!TypeToken.isAssignableFrom(type2, parameterizedType, new HashMap<String, Type>(map))) continue;
                return true;
            }
            Type type3 = clazz.getGenericSuperclass();
            return TypeToken.isAssignableFrom(type3, parameterizedType, new HashMap<String, Type>(map));
        }

        private static boolean typeEquals(ParameterizedType parameterizedType, ParameterizedType parameterizedType2, Map<String, Type> map) {
            if (parameterizedType.getRawType().equals(parameterizedType2.getRawType())) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Type[] typeArray2 = parameterizedType2.getActualTypeArguments();
                for (int i = 0; i < typeArray.length; ++i) {
                    if (TypeToken.matches(typeArray[i], typeArray2[i], map)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static boolean matches(Type type, Type type2, Map<String, Type> map) {
            if (type2.equals(type)) {
                return true;
            }
            if (type instanceof TypeVariable) {
                return type2.equals(map.get(((TypeVariable)type).getName()));
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TypeToken)) {
                return false;
            }
            TypeToken typeToken = (TypeToken)object;
            return this.type.equals(typeToken.type);
        }

        public String toString() {
            return this.type instanceof Class ? ((Class)this.type).getName() : this.type.toString();
        }

        private static AssertionError buildUnexpectedTypeError(Type type, Class<?> ... classArray) {
            StringBuilder stringBuilder = new StringBuilder("Unexpected type. Expected one of: ");
            for (Class<?> clazz : classArray) {
                stringBuilder.append(clazz.getName()).append(", ");
            }
            stringBuilder.append("but got: ").append(type.getClass().getName()).append(", for type token: ").append(type.toString()).append('.');
            return new AssertionError((Object)stringBuilder.toString());
        }

        public static TypeToken<?> get(Type type) {
            return new SimpleTypeToken(type);
        }

        public static <T> TypeToken<T> get(Class<T> clazz) {
            return new SimpleTypeToken(clazz);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class SimpleTypeToken<T>
        extends TypeToken<T> {
            public SimpleTypeToken(Type type) {
                super(type);
            }
        }
    }
}

