/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.limegroup.gnutella.gui.I18n;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class UITool {
    private static String[] BYTE_UNITS = new String[]{"b", "KB", "Mb", "Gb", "Tb"};
    private static HashMap<String, Integer> FILE_TYPES;

    public UITool() {
        UITool.initFileTypes();
    }

    public BufferedImage loadImage(String string) {
        String string2 = "images" + File.separator + string + ".png";
        if (string.endsWith(".jpg") || string.endsWith(".gif")) {
            string2 = "images" + File.separator + string;
        }
        URL uRL = this.getClass().getResource(string2);
        try {
            UITool.initFileTypes();
            return ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getImageNameByFileType(int n) {
        switch (n) {
            case 4: {
                return "application";
            }
            case 3: {
                return "document";
            }
            case 1: {
                return "picture";
            }
            case 2: {
                return "video";
            }
            case 5: {
                return "ringtone";
            }
            case 0: {
                return "audio";
            }
        }
        return "";
    }

    public String getBytesInHuman(long l) {
        int n = 0;
        float f = l;
        n = 0;
        while (l > 1024L) {
            l /= 1024L;
            f /= 1024.0f;
            ++n;
        }
        return String.format("%.2f ", Float.valueOf(f)) + BYTE_UNITS[n];
    }

    public int getFileTypeByExt(String string) {
        if (string == null) {
            return 3;
        }
        Integer n = FILE_TYPES.get(string = string.replace("\\.", "").trim().toLowerCase());
        if (n != null) {
            return n;
        }
        return 3;
    }

    public static String getFileTypeAsString(int n) {
        switch (n) {
            case 4: {
                return I18n.tr("Applications");
            }
            case 0: {
                return I18n.tr("Audio");
            }
            case 3: {
                return I18n.tr("Documents");
            }
            case 1: {
                return I18n.tr("Pictures");
            }
            case 5: {
                return I18n.tr("Ringtones");
            }
            case 2: {
                return I18n.tr("Video");
            }
        }
        return "Unkown file type";
    }

    private static void initFileTypes() {
        if (FILE_TYPES != null) {
            return;
        }
        FILE_TYPES = new HashMap();
        FILE_TYPES.put("mp3", 0);
        FILE_TYPES.put("wma", 0);
        FILE_TYPES.put("wav", 0);
        FILE_TYPES.put("flac", 0);
        FILE_TYPES.put("ogg", 0);
        FILE_TYPES.put("aac", 0);
        FILE_TYPES.put("aa3", 0);
        FILE_TYPES.put("ac3", 0);
        FILE_TYPES.put("cdr", 0);
        FILE_TYPES.put("midi", 0);
        FILE_TYPES.put("f4a", 0);
        FILE_TYPES.put("m4a", 0);
        FILE_TYPES.put("m4b", 0);
        FILE_TYPES.put("m4p", 0);
        FILE_TYPES.put("mid", 0);
        FILE_TYPES.put("mka", 0);
        FILE_TYPES.put("mp1", 0);
        FILE_TYPES.put("mp2", 0);
        FILE_TYPES.put("mpa", 0);
        FILE_TYPES.put("mpga", 0);
        FILE_TYPES.put("au", 0);
        FILE_TYPES.put("oga", 0);
        FILE_TYPES.put("omf", 0);
        FILE_TYPES.put("pcast", 0);
        FILE_TYPES.put("pls", 0);
        FILE_TYPES.put("ra", 0);
        FILE_TYPES.put("ram", 0);
        FILE_TYPES.put("aa", 0);
        FILE_TYPES.put("at3", 0);
        FILE_TYPES.put("3gp", 2);
        FILE_TYPES.put("3g2", 2);
        FILE_TYPES.put("asf", 2);
        FILE_TYPES.put("asx", 2);
        FILE_TYPES.put("avi", 2);
        FILE_TYPES.put("bdm", 2);
        FILE_TYPES.put("bsf", 2);
        FILE_TYPES.put("cpi", 2);
        FILE_TYPES.put("divx", 2);
        FILE_TYPES.put("dmsm", 2);
        FILE_TYPES.put("dream", 2);
        FILE_TYPES.put("dvdmedia", 2);
        FILE_TYPES.put("dvr-ms", 2);
        FILE_TYPES.put("dzm", 2);
        FILE_TYPES.put("dzp", 2);
        FILE_TYPES.put("f4v", 2);
        FILE_TYPES.put("fbr", 2);
        FILE_TYPES.put("flv", 2);
        FILE_TYPES.put("hdmov", 2);
        FILE_TYPES.put("imovieproj", 2);
        FILE_TYPES.put("m2p", 2);
        FILE_TYPES.put("m4v", 2);
        FILE_TYPES.put("mkv", 2);
        FILE_TYPES.put("mod", 2);
        FILE_TYPES.put("moi", 2);
        FILE_TYPES.put("mov", 2);
        FILE_TYPES.put("mp4", 2);
        FILE_TYPES.put("mpeg", 2);
        FILE_TYPES.put("mpeg4", 2);
        FILE_TYPES.put("mts", 2);
        FILE_TYPES.put("mxf", 2);
        FILE_TYPES.put("ogm", 2);
        FILE_TYPES.put("ogv", 2);
        FILE_TYPES.put("pds", 2);
        FILE_TYPES.put("prproj", 2);
        FILE_TYPES.put("psh", 2);
        FILE_TYPES.put("rsproject", 2);
        FILE_TYPES.put("rm", 2);
        FILE_TYPES.put("rmvb", 2);
        FILE_TYPES.put("scm", 2);
        FILE_TYPES.put("smil", 2);
        FILE_TYPES.put("srt", 2);
        FILE_TYPES.put("stx", 2);
        FILE_TYPES.put("swf", 2);
        FILE_TYPES.put("tix", 2);
        FILE_TYPES.put("trp", 2);
        FILE_TYPES.put("ts", 2);
        FILE_TYPES.put("veg", 2);
        FILE_TYPES.put("fv", 2);
        FILE_TYPES.put("vob", 2);
        FILE_TYPES.put("vro", 2);
        FILE_TYPES.put("wmv", 2);
        FILE_TYPES.put("wtv", 2);
        FILE_TYPES.put("xvid", 2);
        FILE_TYPES.put("yuv", 2);
        FILE_TYPES.put("afx", 1);
        FILE_TYPES.put("arw", 1);
        FILE_TYPES.put("bmp", 1);
        FILE_TYPES.put("cpt", 1);
        FILE_TYPES.put("cr2", 1);
        FILE_TYPES.put("dcm", 1);
        FILE_TYPES.put("dds", 1);
        FILE_TYPES.put("dib", 1);
        FILE_TYPES.put("dng", 1);
        FILE_TYPES.put("dt2", 1);
        FILE_TYPES.put("gif", 1);
        FILE_TYPES.put("hdp", 1);
        FILE_TYPES.put("ipx", 1);
        FILE_TYPES.put("itc2", 1);
        FILE_TYPES.put("jpe", 1);
        FILE_TYPES.put("jpeg", 1);
        FILE_TYPES.put("jpg", 1);
        FILE_TYPES.put("jps", 1);
        FILE_TYPES.put("jpx", 1);
        FILE_TYPES.put("max", 1);
        FILE_TYPES.put("mng", 1);
        FILE_TYPES.put("nef", 1);
        FILE_TYPES.put("pictclipping", 1);
        FILE_TYPES.put("png", 1);
        FILE_TYPES.put("ppm", 1);
        FILE_TYPES.put("psd", 1);
        FILE_TYPES.put("psp", 1);
        FILE_TYPES.put("pspimage", 1);
        FILE_TYPES.put("raw", 1);
        FILE_TYPES.put("rw2", 1);
        FILE_TYPES.put("sdr", 1);
        FILE_TYPES.put("srf", 1);
        FILE_TYPES.put("tga", 1);
        FILE_TYPES.put("thm", 1);
        FILE_TYPES.put("tif", 1);
        FILE_TYPES.put("tiff", 1);
        FILE_TYPES.put("wb1", 1);
        FILE_TYPES.put("wbc", 1);
        FILE_TYPES.put("wbd", 1);
        FILE_TYPES.put("wbz", 1);
        FILE_TYPES.put("rng", 5);
        FILE_TYPES.put("m4r", 5);
        FILE_TYPES.put("nrt", 5);
        FILE_TYPES.put("rng", 5);
        FILE_TYPES.put("apk", 4);
    }
}

