/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;

public class MultilineLabel
extends JLabel {
    private static final long serialVersionUID = -6265191318434960684L;
    private String _originalText;
    private String _calculatedText;

    public void setText(String string) {
        super.setText(string);
        this._originalText = string;
        this._calculatedText = null;
    }

    public void paint(Graphics graphics) {
        if (this._calculatedText == null) {
            this.calculateText((Graphics2D)graphics);
        }
        super.paint(graphics);
    }

    private void calculateText(Graphics2D graphics2D) {
        try {
            String string;
            String string2;
            int n;
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getFont());
            int n2 = this.getWidth() - fontMetrics.stringWidth(" ") - 6;
            char[] cArray = this._originalText.toCharArray();
            for (n = 0; n < cArray.length && fontMetrics.charsWidth(cArray, 0, n) < n2; ++n) {
            }
            if (n == this._originalText.length()) {
                string2 = this._originalText;
                string = " ";
            } else {
                int n3 = this._originalText.lastIndexOf(" ");
                if (n3 == -1) {
                    n3 = n;
                }
                string2 = this._originalText.substring(0, n3);
                string = this._originalText.substring(n3);
                if (string.length() >= n - 1) {
                    n = 0;
                    while (fontMetrics.stringWidth(string.substring(0, n) + "... ") < n2) {
                        ++n;
                    }
                    string = string.substring(0, n) + "...";
                }
            }
            this._calculatedText = "<html>" + this.makeParagraph(this.fillText(fontMetrics, string2, n2)) + this.makeParagraph(this.fillText(fontMetrics, string, n2)) + "<html>";
        }
        catch (Exception exception) {
            this._calculatedText = this._originalText;
        }
        this.setText(this._calculatedText);
    }

    private String fillText(FontMetrics fontMetrics, String string, int n) {
        boolean bl = true;
        while (fontMetrics.stringWidth(string + " ") < n) {
            string = bl ? string + " " : " " + string;
            bl = !bl;
        }
        return string.replace(" ", "&nbsp;");
    }

    private String makeParagraph(String string) {
        return "<p>" + string + "</p>";
    }
}

