/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.GuiFrostWireUtils;
import com.frostwire.gnutella.gui.android.UITool;
import java.io.File;
import java.io.Serializable;

public class LocalFile
implements Serializable {
    private static final long serialVersionUID = -2596345342420014651L;
    private File _file;
    private transient OnOpenListener _listener;

    public LocalFile() {
    }

    public LocalFile(File file) {
        this._file = file;
    }

    public String getName() {
        return this._file.getName();
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public OnOpenListener getOnOpenListener() {
        return this._listener;
    }

    public void setOnOpenListener(OnOpenListener onOpenListener) {
        this._listener = onOpenListener;
    }

    public String getExt() {
        String string = this._file.getName();
        int n = string.lastIndexOf(".");
        String string2 = n != -1 ? string.substring(n + 1, string.length()).toLowerCase() : null;
        return string2;
    }

    public int getFileType() {
        String string = this.getExt();
        return new UITool().getFileTypeByExt(string);
    }

    public void open() {
        if (this._file.isDirectory()) {
            this.fireOnOpen();
        } else {
            GuiFrostWireUtils.launchFile(this._file);
        }
    }

    public void rename(String string) {
        File file = new File(this._file.getParentFile(), string);
        this._file.renameTo(file);
        this._file.delete();
        this._file = file;
    }

    public String toString() {
        return this._file.toString();
    }

    protected void fireOnOpen() {
        if (this._listener != null) {
            this._listener.onOpen(this);
        }
    }

    public static interface OnOpenListener {
        public void onOpen(LocalFile var1);
    }
}

