/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.GraphicPanel;
import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.CopyToDesktopTask;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.UITool;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.LimeWirePlayer;
import com.limegroup.gnutella.gui.mp3.PlayerState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public class FileDescriptorRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 8978172363548823491L;
    private static final Color COLOR_LIGHTER_BLUE = new Color(196, 238, 254);
    private static UITool UI_TOOL = new UITool();
    private static LimeWirePlayer PLAYER = new LimeWirePlayer();
    private static FileDescriptor LAST_PLAY;
    private static Map<Integer, Image> IMAGE_TYPES;
    private static Image IMAGE_COPY;
    private static Image IMAGE_PLAY;
    private static Image IMAGE_STOP;
    private GraphicPanel _imagePanel;
    private JLabel _labelTitle;
    private JLabel _labelSize;
    private JLabel _labelExtra;
    private JRadioButton _buttonPlay;
    private JRadioButton _buttonCopy;
    private FileDescriptor _fileDescriptor;
    private JList _list;
    private int _index;

    public FileDescriptorRenderer() {
        this.setupUI();
        this._index = -1;
        this._list = null;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setComponentOrientation(jList.getComponentOrientation());
        this._fileDescriptor = (FileDescriptor)object;
        this._list = jList;
        this._index = n;
        if (bl) {
            this.setBackground(COLOR_LIGHTER_BLUE);
        } else {
            this.setBackground(Color.WHITE);
        }
        this._imagePanel.setImage(this.loadImageType(this._fileDescriptor.fileType));
        this._labelTitle.setText(this._fileDescriptor.title);
        this._labelSize.setText(UI_TOOL.getBytesInHuman(this._fileDescriptor.fileSize));
        if (this._fileDescriptor.fileType == 0 || this._fileDescriptor.fileType == 4) {
            this._labelExtra.setText(this._fileDescriptor.artist);
        } else {
            this._labelExtra.setText("");
        }
        if (this._fileDescriptor.fileType == 0) {
            this._buttonPlay.setVisible(true);
            this._buttonPlay.setIcon(new ImageIcon(this._fileDescriptor.equals(LAST_PLAY) ? this.loadImageStop() : this.loadImagePlay()));
        } else {
            this._buttonPlay.setVisible(false);
        }
        return this;
    }

    public Component getComponentAt(int n, int n2) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!this.getComponent(i).getBounds().contains(n, n2)) continue;
            return this.getComponent(i);
        }
        if (this.getBounds().contains(n, n2)) {
            return this;
        }
        return null;
    }

    protected void setupUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this._imagePanel = new GraphicPanel();
        Dimension dimension = new Dimension(24, 24);
        this._imagePanel.setPreferredSize(dimension);
        this._imagePanel.setMinimumSize(dimension);
        this._imagePanel.setMaximumSize(dimension);
        this._imagePanel.setSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this._imagePanel, gridBagConstraints);
        this._labelTitle = new JLabel();
        Font font = this._labelTitle.getFont();
        font = new Font(font.getName(), font.getStyle() | 1, font.getSize() + 2);
        this._labelTitle.setFont(font);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this._labelTitle, gridBagConstraints);
        this._labelSize = new JLabel();
        this._labelSize.setForeground(new Color(233, 165, 76));
        this._labelSize.setAlignmentY(0.5f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        this.add((Component)this._labelSize, gridBagConstraints);
        this._labelExtra = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._labelExtra, gridBagConstraints);
        this._buttonCopy = new JRadioButton();
        this._buttonCopy.setBorder(null);
        this._buttonCopy.setBackground(null);
        this._buttonCopy.setFocusable(false);
        this._buttonCopy.setFocusPainted(false);
        this._buttonCopy.setContentAreaFilled(false);
        this._buttonCopy.setIcon(new ImageIcon(this.loadImageCopy()));
        this._buttonCopy.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                FileDescriptorRenderer.this.buttonCopy_mouseReleased(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this._buttonCopy, gridBagConstraints);
        this._buttonPlay = new JRadioButton();
        this._buttonPlay.setBorder(null);
        this._buttonPlay.setBackground(null);
        this._buttonPlay.setFocusable(false);
        this._buttonPlay.setFocusPainted(false);
        this._buttonPlay.setContentAreaFilled(false);
        this._buttonPlay.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                FileDescriptorRenderer.this.buttonPlay_mouseReleased(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this._buttonPlay, gridBagConstraints);
    }

    protected void buttonPlay_mouseReleased(MouseEvent mouseEvent) {
        Device device = AndroidMediator.instance().getDeviceBar().getSelectedDevice();
        if (device != null && this._fileDescriptor != null) {
            FileDescriptorRenderer.play(device, this._fileDescriptor);
        }
    }

    protected void buttonCopy_mouseReleased(MouseEvent mouseEvent) {
        Device device = AndroidMediator.instance().getDeviceBar().getSelectedDevice();
        File file = AndroidMediator.instance().getDesktopExplorer().getRootFolder();
        List<FileDescriptor> list = null;
        int[] nArray = this._list.getSelectedIndices();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != this._index) continue;
            bl = true;
            break;
        }
        if (bl) {
            list = AndroidMediator.instance().getDeviceExplorer().getSelectedFileDescriptors();
        } else {
            list = new ArrayList<FileDescriptor>(1);
            list.add((FileDescriptor)this._list.getModel().getElementAt(this._index));
            this._list.clearSelection();
            this._list.setSelectedIndex(this._index);
        }
        if (device != null && file != null && this._fileDescriptor != null) {
            FileDescriptor[] fileDescriptorArray = list.toArray(new FileDescriptor[0]);
            int n = AndroidMediator.instance().getDeviceExplorer().getSelectedFileType();
            AndroidMediator.addTask(new CopyToDesktopTask(device, file, fileDescriptorArray, n));
        }
    }

    private static void play(Device device, FileDescriptor fileDescriptor) {
        if (PLAYER.getStatus() == PlayerState.PLAYING && fileDescriptor.equals(LAST_PLAY)) {
            LAST_PLAY = null;
            AndroidMediator.instance().getDeviceExplorer().getModel().update(fileDescriptor);
            PLAYER.stop();
        } else {
            AndroidMediator.instance().getDeviceExplorer().getModel().update(fileDescriptor);
            URL uRL = device.getDownloadURL(fileDescriptor.fileType, fileDescriptor.id);
            LAST_PLAY = fileDescriptor;
            PLAYER.loadSong(new AudioSource(uRL));
            PLAYER.playSong();
        }
    }

    private Image loadImageType(int n) {
        if (IMAGE_TYPES.containsKey(n)) {
            return IMAGE_TYPES.get(n);
        }
        Image image = UI_TOOL.loadImage(UI_TOOL.getImageNameByFileType(this._fileDescriptor.fileType)).getScaledInstance(24, 24, 4);
        IMAGE_TYPES.put(n, image);
        return image;
    }

    private Image loadImageCopy() {
        if (IMAGE_COPY != null) {
            return IMAGE_COPY;
        }
        IMAGE_COPY = UI_TOOL.loadImage("copy_device").getScaledInstance(32, 32, 4);
        return IMAGE_COPY;
    }

    private Image loadImagePlay() {
        if (IMAGE_PLAY != null) {
            return IMAGE_PLAY;
        }
        IMAGE_PLAY = UI_TOOL.loadImage("play").getScaledInstance(32, 32, 4);
        return IMAGE_PLAY;
    }

    private Image loadImageStop() {
        if (IMAGE_STOP != null) {
            return IMAGE_STOP;
        }
        IMAGE_STOP = UI_TOOL.loadImage("stop").getScaledInstance(32, 32, 4);
        return IMAGE_STOP;
    }

    static {
        IMAGE_TYPES = new HashMap<Integer, Image>();
    }
}

