/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.CopyToDesktopTask;
import com.frostwire.gnutella.gui.android.DesktopListTransferable;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.DeviceListTransferable;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.LocalFile;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class DesktopListTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 7212838569016925166L;

    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return transferSupport.isDataFlavorSupported(DeviceListTransferable.FILE_DESCRIPTOR_ARRAY);
    }

    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        Device device = AndroidMediator.instance().getDeviceBar().getSelectedDevice();
        if (device == null) {
            return false;
        }
        File file = AndroidMediator.instance().getDesktopExplorer().getSelectedFolder();
        if (file == null) {
            file = AndroidMediator.instance().getDesktopExplorer().getRootFolder();
        }
        if (file == null || !file.exists() || !file.isDirectory()) {
            return false;
        }
        Transferable transferable = transferSupport.getTransferable();
        FileDescriptor[] fileDescriptorArray = null;
        try {
            fileDescriptorArray = (FileDescriptor[])transferable.getTransferData(DeviceListTransferable.FILE_DESCRIPTOR_ARRAY);
        }
        catch (Exception exception) {
            return false;
        }
        int n = AndroidMediator.instance().getDeviceExplorer().getSelectedFileType();
        AndroidMediator.addTask(new CopyToDesktopTask(device, file, fileDescriptorArray, n));
        return true;
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        JList jList = (JList)jComponent;
        Object[] objectArray = jList.getSelectedValues();
        ArrayList<LocalFile> arrayList = new ArrayList<LocalFile>();
        for (Object object : objectArray) {
            arrayList.add((LocalFile)object);
        }
        return new DesktopListTransferable(arrayList);
    }
}

