/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui;

import com.frostwire.gnutella.gui.SlideshowPanel;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class FadeSlideTransition {
    private SlideshowPanel _panel;
    private BufferedImage _imageStart;
    private BufferedImage _imageEnd;
    private int _cycles = 100;
    private long _sleepTime = 20L;
    private int _counter = 0;
    private boolean _running;

    public FadeSlideTransition(SlideshowPanel slideshowPanel, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this._panel = slideshowPanel;
        this._imageStart = bufferedImage;
        this._imageEnd = bufferedImage2;
    }

    public void start() {
        this._running = true;
        this._counter = 0;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FadeSlideTransition.this._counter = 0;
                while (FadeSlideTransition.this._counter < FadeSlideTransition.this._cycles) {
                    try {
                        Thread.sleep(FadeSlideTransition.this._sleepTime);
                        FadeSlideTransition.this._panel.repaint();
                        FadeSlideTransition.this._panel.getToolkit().sync();
                    }
                    catch (Throwable throwable) {
                        break;
                    }
                    FadeSlideTransition.this._counter++;
                }
                FadeSlideTransition.this._running = false;
            }
        });
        thread.start();
    }

    public synchronized void paint(Graphics graphics) {
        if (!this._running) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = (float)this._counter / 100.0f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - f));
        graphics2D.drawImage(this._imageStart, null, 0, 0);
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.drawImage(this._imageEnd, null, 0, 0);
        graphics2D.setComposite(composite);
    }

    public boolean isRunning() {
        return this._running;
    }

    public long getEstimatedDuration() {
        return (long)this._cycles * this._sleepTime + 50L;
    }
}

