/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.connectiondoctor;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.CommonUtils;

public final class ConnectionDoctor {
    public static int WAITING_TIME = System.getProperty("debug") != null ? 6 : 15;
    private int MAXTRY = 4;
    private int CURRTRY = 0;
    private static final Log LOG = LogFactory.getLog(ConnectionDoctor.class);
    private Thread _initializer;
    private boolean failed;
    private static final String CONNECTION_DR_URL = "http://doctor.frostwire.com/hosts/";
    private static final int CONNECT_TIMEOUT = 3000;

    public synchronized boolean loadHosts() throws Exception {
        return this.loadHosts(CONNECTION_DR_URL);
    }

    public synchronized boolean loadHosts(String string) throws Exception {
        this.failed = false;
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setReadTimeout(3000);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string2 = bufferedReader.readLine().trim();
            if (!string2.startsWith("http://")) {
                this.failed = true;
                ++this.CURRTRY;
                throw new Exception("ConnectionDoctor.loadHosts() - " + string2 + " not a valid gnutella.net location");
            }
            bufferedReader.close();
            httpURLConnection.disconnect();
            httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (!string3.matches("(.*)\\:(.*)\\,(.*)")) {
                    this.failed = true;
                    bufferedReader.close();
                    httpURLConnection.disconnect();
                    throw new Exception("ConnectionDoctor.loadHosts() - invalid gnutella.net from server");
                }
                stringBuffer.append(string3 + "\n");
                string3 = bufferedReader.readLine();
            }
            FileWriter fileWriter = new FileWriter(CommonUtils.getUserSettingsDir() + "/gnutella.net");
            fileWriter.write(stringBuffer.toString());
            fileWriter.flush();
            System.out.println("Got Gnutella");
            this.failed = false;
            fileWriter.close();
            bufferedReader.close();
            httpURLConnection.disconnect();
            httpURLConnection = null;
            bufferedReader = null;
            GUIMediator.instance().disconnect();
            GUIMediator.instance().connect();
            System.gc();
            ++this.CURRTRY;
        }
        catch (Exception exception) {
            ++this.CURRTRY;
            this.failed = true;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw exception;
        }
        return true;
    }

    public boolean failed() {
        return this.failed;
    }

    public void initialize() {
        this._initializer = new Thread(new Runnable(){

            public void run() {
                boolean bl = false;
                if (GuiCoreMediator.getConnectionServices().isConnected()) {
                    bl = true;
                }
                int n = 0;
                while (!GUIMediator.isConstructed() || GuiCoreMediator.getCore() == null || !GuiCoreMediator.getLifecycleManager().isLoaded() || !bl && !GuiCoreMediator.getConnectionServices().isConnected() && ConnectionDoctor.this.CURRTRY < ConnectionDoctor.this.MAXTRY) {
                    if (GuiCoreMediator.getConnectionServices().isConnecting() && !GuiCoreMediator.getConnectionServices().isConnected()) {
                        ++n;
                        if (ConnectionDoctor.this.CURRTRY >= ConnectionDoctor.this.MAXTRY) {
                            GUIMediator.showError(I18n.tr("FrostWire could not detect an internet connection. Please, check your firewall settings and try to restart FrostWire."));
                            bl = true;
                            return;
                        }
                        if (n >= WAITING_TIME) {
                            try {
                                bl = ConnectionDoctor.this.loadHosts();
                            }
                            catch (Exception exception) {
                                bl = false;
                            }
                            n = 0;
                        }
                        if (GuiCoreMediator.getConnectionServices().isConnected()) {
                            bl = true;
                        }
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this._initializer.start();
    }
}

