/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.actions;

import com.frostwire.gnutella.connectiondoctor.ConnectionDoctor;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import java.awt.event.ActionEvent;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;

public class ConnectionDoctorAction
extends AbstractAction
implements ConnectionLifecycleListener {
    private final short MAX_USES = (short)3;
    private short timesUsed = 0;
    private ConnectionDoctor doctor;
    private boolean loadingHosts = false;
    private static ConnectionDoctorAction INSTANCE = null;

    public static ConnectionDoctorAction getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionDoctorAction();
        }
        return INSTANCE;
    }

    private ConnectionDoctorAction() {
        super(I18n.tr("&Refresh Connections"));
        this.putValue("LongDescription", I18nMarker.marktr("Fix Connection Problems. Get a fresh list of peers"));
        GuiCoreMediator.getConnectionManager().addEventListener(this);
        this.doctor = new ConnectionDoctor();
    }

    private void refreshMenuName() {
        this.putValue("Name", I18nMarker.marktr("&Refresh Connections (" + (3 - this.timesUsed) + " attempts left)"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.timesUsed = (short)(this.timesUsed + 1);
        this.putValue("Name", I18nMarker.marktr("&Refreshing Connections (" + (3 - this.timesUsed) + " attempts left)"));
        this.setEnabled(false);
        ThreadExecutor.startThread(new Runnable(){

            public void run() {
                ConnectionDoctorAction.this.loadingHosts = true;
                try {
                    ConnectionDoctorAction.this.doctor.loadHosts();
                }
                catch (Exception exception) {
                    ConnectionDoctorAction.this.refreshMenuName();
                    ConnectionDoctorAction.access$310(ConnectionDoctorAction.this);
                    ConnectionDoctorAction.this.setEnabled(true);
                    ConnectionDoctorAction.this.loadingHosts = false;
                    return;
                }
                ConnectionDoctorAction.this.loadingHosts = false;
                ConnectionDoctorAction.this.setEnabled(false);
            }
        }, "CONNECTION_DOCTOR_FROM_MENU");
    }

    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        this.refreshMenuName();
        if (this.timesUsed == 3 || this.loadingHosts || GuiCoreMediator.getConnectionServices().isConnecting() || GuiCoreMediator.getConnectionManager().isConnecting()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.timesUsed < 3);
    }

    static /* synthetic */ short access$310(ConnectionDoctorAction connectionDoctorAction) {
        short s = connectionDoctorAction.timesUsed;
        connectionDoctorAction.timesUsed = (short)(s - 1);
        return s;
    }
}

