/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.limegroup.gnutella.http.HTTPHeaderName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpFetcher {
    private static final int TIMEOUT = 10000;
    private URI _uri;
    private String _userAgent;
    private byte[] body = null;

    public HttpFetcher(URI uRI, String string) {
        this._uri = uRI;
        this._userAgent = string;
    }

    public HttpFetcher(URI uRI) {
        this(uRI, "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] fetch(boolean bl) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (bl) {
            defaultHttpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    if (!httpRequest.containsHeader("Accept-Encoding")) {
                        httpRequest.addHeader("Accept-Encoding", "gzip");
                    }
                }
            });
            defaultHttpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    Header header = httpEntity.getContentEncoding();
                    if (header != null) {
                        HeaderElement[] headerElementArray = header.getElements();
                        for (int i = 0; i < headerElementArray.length; ++i) {
                            if (!headerElementArray[i].getName().equalsIgnoreCase("gzip")) continue;
                            httpResponse.setEntity(new GzipDecompressingEntity(httpResponse.getEntity()));
                            return;
                        }
                    }
                }
            });
        }
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpGet httpGet = new HttpGet(this._uri);
        httpGet.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        HttpParams httpParams = httpGet.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);
        HttpConnectionParams.setSoTimeout(httpParams, 10000);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, this._userAgent);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HttpResponse httpResponse = defaultHttpClient.execute(httpHost, httpGet);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, downloading file " + httpResponse.getStatusLine().getStatusCode());
            }
            Long l = 0L;
            Header[] headerArray = httpResponse.getAllHeaders();
            for (int i = 0; i < headerArray.length; ++i) {
                if (!headerArray[i].getName().startsWith("Last-Modified")) continue;
                try {
                    l = DateUtils.parseDate(headerArray[i].getValue()).getTime();
                }
                catch (Exception exception) {}
                break;
            }
            if (httpResponse.getEntity() != null) {
                if (bl) {
                    String string = EntityUtils.toString(httpResponse.getEntity());
                    byteArrayOutputStream.write(string.getBytes());
                } else {
                    httpResponse.getEntity().writeTo(byteArrayOutputStream);
                }
            }
            this.body = byteArrayOutputStream.toByteArray();
            if (this.body == null || this.body.length == 0) {
                throw new IOException("invalid response");
            }
            Object[] objectArray = new Object[]{this.body, l};
            return objectArray;
        }
        catch (Exception exception) {
            System.out.println("Http error: " + exception.getMessage());
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public byte[] fetch() {
        return (byte[])this.fetch(false)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(File file) throws IOException {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpPost httpPost = new HttpPost(this._uri);
        FileEntity fileEntity = new FileEntity(file, "binary/octet-stream");
        fileEntity.setChunked(true);
        httpPost.setEntity(fileEntity);
        HttpParams httpParams = httpPost.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);
        HttpConnectionParams.setSoTimeout(httpParams, 10000);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506");
        try {
            HttpResponse httpResponse = defaultHttpClient.execute(httpHost, httpPost);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, upload file " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            new IOException("Http error: " + exception.getMessage(), exception);
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(FileEntity fileEntity) throws IOException {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
        HttpHost httpHost = new HttpHost(this._uri.getHost(), this._uri.getPort());
        HttpPost httpPost = new HttpPost(this._uri);
        httpPost.setEntity(fileEntity);
        HttpParams httpParams = httpPost.getParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);
        HttpConnectionParams.setSoTimeout(httpParams, 10000);
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        HttpClientParams.setRedirecting(httpParams, true);
        HttpProtocolParams.setUseExpectContinue(httpParams, false);
        HttpProtocolParams.setUserAgent(httpParams, "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506");
        try {
            HttpResponse httpResponse = defaultHttpClient.execute(httpHost, httpPost);
            if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new IOException("bad status code, upload file " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            new IOException("Http error: " + exception.getMessage(), exception);
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    private static final class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

