/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.frostwire.HttpFetcher;
import com.frostwire.bittorrent.AzureusStarter;
import com.frostwire.guice.FrostWireCoreModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.limegroup.bittorrent.BTMetaInfo;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.limewire.util.CommonUtils;
import org.limewire.util.Version;

public class CoreFrostWireUtils {
    private static Injector INJECTOR;

    public static final File getPreferencesFolder() {
        return LimeWireUtils.getRequestedUserSettingsLocation();
    }

    public static final String getMD5(File file) throws Exception {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = new byte[65536];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        ((InputStream)bufferedInputStream).close();
        String string = new BigInteger(1, messageDigest.digest()).toString(16);
        if (string.length() < 32) {
            int n2 = 32 - string.length();
            for (int i = 0; i < n2; ++i) {
                string = "0" + string;
            }
        }
        System.out.println("MD5: " + string);
        return string;
    }

    public static final byte[] getSHA1(File file) {
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = new byte[65536];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            ((InputStream)bufferedInputStream).close();
            return messageDigest.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final boolean checkMD5(File file, String string) throws Exception {
        if (string == null) {
            throw new Exception("Expected MD5 is null");
        }
        if (string.length() != 32) {
            throw new Exception("Invalid Expected MD5, not 32 chars long");
        }
        return CoreFrostWireUtils.getMD5(file).trim().equalsIgnoreCase(string.trim());
    }

    public static final void deleteFolderRecursively(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    CoreFrostWireUtils.deleteFolderRecursively(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public static final byte[] downloadHttpFile(String string) {
        try {
            return new HttpFetcher(new URI(string)).fetch();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    public static final String getInstallationFolder() {
        Properties properties = System.getProperties();
        return properties.getProperty("user.dir");
    }

    public static void printDiskManagerPieces(DiskManager diskManager) {
        DiskManagerPiece[] diskManagerPieceArray;
        if (diskManager == null) {
            return;
        }
        for (DiskManagerPiece diskManagerPiece : diskManagerPieceArray = diskManager.getPieces()) {
            System.out.print(diskManagerPiece.isDone() ? "1" : "0");
        }
        System.out.println();
    }

    public static void printDownloadManagerStatus(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Completed:");
        DownloadManagerStats downloadManagerStats = downloadManager.getStats();
        int n = downloadManagerStats.getCompleted();
        stringBuffer.append(n / 10);
        stringBuffer.append('.');
        stringBuffer.append(n % 10);
        stringBuffer.append('%');
        stringBuffer.append(" Seeds:");
        stringBuffer.append(downloadManager.getNbSeeds());
        stringBuffer.append(" Peers:");
        stringBuffer.append(downloadManager.getNbPeers());
        stringBuffer.append(" Downloaded:");
        stringBuffer.append(DisplayFormatters.formatDownloaded(downloadManagerStats));
        stringBuffer.append(" Uploaded:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(downloadManagerStats.getTotalDataBytesSent()));
        stringBuffer.append(" DSpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataReceiveRate()));
        stringBuffer.append(" USpeed:");
        stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadManagerStats.getDataSendRate()));
        stringBuffer.append(" TrackerStatus:");
        stringBuffer.append(downloadManager.getTrackerStatus());
        while (stringBuffer.length() < 80) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(" TO:");
        stringBuffer.append(downloadManager.getSaveLocation().getAbsolutePath());
        System.out.println(stringBuffer.toString());
    }

    public static final void unzip(File file, File file2) throws Exception {
        ZipEntry zipEntry;
        int n = 2048;
        BufferedOutputStream bufferedOutputStream = null;
        File file3 = new File(file2.getCanonicalPath(), file.getName());
        if (file3.exists()) {
            file3.delete();
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n2;
            byte[] byArray = new byte[n];
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2.getPath() + "/" + zipEntry.getName()), n);
            while ((n2 = zipInputStream.read(byArray, 0, n)) != -1) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        zipInputStream.close();
    }

    public static final DownloadManager startTorrentDownload(String string, String string2, DownloadManagerListener downloadManagerListener) throws Exception {
        CoreFrostWireUtils.waitForAzureusCoreToStart();
        DownloadManager downloadManager = AzureusStarter.getAzureusCore().getGlobalManager().addDownloadManager(string, string2);
        downloadManager.addListener(downloadManagerListener);
        downloadManager.initialize();
        return downloadManager;
    }

    public static final void waitForAzureusCoreToStart() throws InterruptedException {
        if (AzureusStarter.getAzureusCore().isStarted()) {
            return;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        AzureusStarter.getAzureusCore().addLifecycleListener(new AzureusCoreLifecycleListener(){

            public void componentCreated(AzureusCore azureusCore, AzureusCoreComponent azureusCoreComponent) {
            }

            public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                return false;
            }

            public boolean restartRequested(AzureusCore azureusCore) throws AzureusCoreException {
                return false;
            }

            public void started(AzureusCore azureusCore) {
                countDownLatch.countDown();
            }

            public void stopped(AzureusCore azureusCore) {
            }

            public void stopping(AzureusCore azureusCore) {
            }

            public boolean stopRequested(AzureusCore azureusCore) throws AzureusCoreException {
                return false;
            }

            public boolean syncInvokeRequired() {
                return false;
            }
        });
        if (!AzureusStarter.getAzureusCore().isStarted()) {
            System.out.println("FrostWireUtils.waitForAzureusCoreToStart() - Waiting for azureus core...");
            countDownLatch.await();
            System.out.println("FrostWireUtils.waitForAzureusCoreToStart() - Azureus core has started, let's do this.");
        }
    }

    public static final BTMetaInfo downloadTorrentFile(String string, File file) throws IOException {
        BTMetaInfo bTMetaInfo = null;
        byte[] byArray = CoreFrostWireUtils.downloadHttpFile(string);
        try {
            bTMetaInfo = BTMetaInfo.readFromBytes(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (file != null && byArray != null && byArray.length > 0) {
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            file.createNewFile();
            file.setWritable(true);
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        return bTMetaInfo;
    }

    public static final BTMetaInfo downloadTorrentFile(String string) throws IOException {
        return CoreFrostWireUtils.downloadTorrentFile(string, null);
    }

    public static final void main(String[] stringArray) throws Exception {
        AzureusStarter.start();
        AzureusCore azureusCore = AzureusStarter.getAzureusCore();
        CoreFrostWireUtils.waitForAzureusCoreToStart();
        azureusCore.getGlobalManager().resumeDownloads();
        CoreFrostWireUtils.downloadTorrentFile("http://dl.frostwire.com/torrents/hostiles/hostiles.txt.2.zip.torrent", new File(SharingUtils.APPLICATION_SPECIAL_SHARE, "hostiles.txt.2.zip.torrent"));
        DownloadManager downloadManager = CoreFrostWireUtils.startTorrentDownload(SharingUtils.APPLICATION_SPECIAL_SHARE + File.separator + "hostiles.txt.2.zip.torrent", CommonUtils.getUserSettingsDir().getAbsolutePath(), new DownloadManagerListener(){

            public void completionChanged(DownloadManager downloadManager, boolean bl) {
                System.out.println("completionChanged: completed:" + bl);
            }

            public void downloadComplete(DownloadManager downloadManager) {
                System.out.println("downloadComplete()!");
            }

            public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
                System.out.println("filePriorityChanged() " + diskManagerFileInfo.getIndex());
            }

            public void positionChanged(DownloadManager downloadManager, int n, int n2) {
                System.out.println("positionChanged() oldPos:" + n + " newPos:" + n2);
            }

            public void stateChanged(DownloadManager downloadManager, int n) {
                System.out.println("State Changed (" + n + ")");
                if (n == 60) {
                    System.out.println("SEEDING");
                } else if (n == 65) {
                    System.out.println("STOPPING");
                } else if (n == 70) {
                    System.out.println("STOPPED");
                    System.out.println("Trying to restart...");
                    downloadManager.startDownload();
                } else if (n == 100) {
                    System.out.println("ERROR");
                    System.out.println(downloadManager.getErrorDetails());
                } else if (n == 40 && downloadManager.getDiskManager().getPercentDone() < 1000) {
                    System.out.println("Ready but getPercentage() < 1000 [" + downloadManager.getDiskManager().getPercentDone() + "]");
                    downloadManager.startDownload();
                } else if (n == 40) {
                    System.out.println("Ready - getPercentage()=" + downloadManager.getDiskManager().getPercentDone());
                    System.out.println(downloadManager.getSaveLocation().getAbsolutePath());
                    downloadManager.startDownload();
                }
            }
        });
        downloadManager.addDiskListener(new DownloadManagerDiskListener(){

            public void diskManagerAdded(DiskManager diskManager) {
                System.out.print("Added a diskManager: " + diskManager.getNbPieces() + " pieces -> ");
                CoreFrostWireUtils.printDiskManagerPieces(diskManager);
            }

            public void diskManagerRemoved(DiskManager diskManager) {
                System.out.print("Removed a diskManager: " + diskManager.getNbPieces() + " pieces -> ");
                CoreFrostWireUtils.printDiskManagerPieces(diskManager);
            }
        });
    }

    public static Injector getInjector() {
        if (INJECTOR == null) {
            INJECTOR = Guice.createInjector(new FrostWireCoreModule());
        }
        return INJECTOR;
    }

    public static HttpExecutor getHTTPExecutor() {
        return CoreFrostWireUtils.getInjector().getInstance(HttpExecutor.class);
    }

    public static boolean isJavaMinorVersionEqualOrGreaterThan(String string) {
        if (string == null) {
            return false;
        }
        Version version = null;
        Version version2 = null;
        try {
            version = new Version(string);
            version2 = new Version(System.getProperty("java.version"));
        }
        catch (Exception exception) {
            return false;
        }
        return version2.compareMajorMinorTo(version) >= 0;
    }
}

