/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.ogg.OggVorbisTagReader;
import org.jaudiotagger.audio.ogg.util.OggInfoReader;
import org.jaudiotagger.audio.ogg.util.OggPageHeader;
import org.jaudiotagger.tag.Tag;

public class OggFileReader
extends AudioFileReader {
    private OggInfoReader ir = new OggInfoReader();
    private OggVorbisTagReader vtr = new OggVorbisTagReader();

    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        return this.ir.read(raf);
    }

    protected Tag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        return this.vtr.read(raf);
    }

    public OggPageHeader readOggPageHeader(RandomAccessFile raf, int count) throws CannotReadException, IOException {
        OggPageHeader pageHeader = OggPageHeader.read(raf);
        while (count > 0) {
            raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
            pageHeader = OggPageHeader.read(raf);
            --count;
        }
        return pageHeader;
    }

    public void summarizeOggPageHeaders(File oggFile) throws CannotReadException, IOException {
        RandomAccessFile raf = new RandomAccessFile(oggFile, "r");
        while (raf.getFilePointer() < raf.length()) {
            OggPageHeader pageHeader = OggPageHeader.read(raf);
            raf.seek(raf.getFilePointer() + (long)pageHeader.getPageLength());
        }
    }
}

