/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;

public class ModificationHandler
implements AudioFileModificationListener {
    private Vector listeners = new Vector();

    public void addAudioFileModificationListener(AudioFileModificationListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void fileModified(AudioFile original, File temporary) throws ModifyVetoException {
        Enumeration enumer = this.listeners.elements();
        while (enumer.hasMoreElements()) {
            AudioFileModificationListener current = (AudioFileModificationListener)enumer.nextElement();
            try {
                current.fileModified(original, temporary);
            }
            catch (ModifyVetoException e) {
                this.vetoThrown(current, original, e);
                throw e;
            }
        }
    }

    public void fileOperationFinished(File result) {
        Enumeration enumer = this.listeners.elements();
        while (enumer.hasMoreElements()) {
            AudioFileModificationListener current = (AudioFileModificationListener)enumer.nextElement();
            current.fileOperationFinished(result);
        }
    }

    public void fileWillBeModified(AudioFile file, boolean delete) throws ModifyVetoException {
        Enumeration enumer = this.listeners.elements();
        while (enumer.hasMoreElements()) {
            AudioFileModificationListener current = (AudioFileModificationListener)enumer.nextElement();
            try {
                current.fileWillBeModified(file, delete);
            }
            catch (ModifyVetoException e) {
                this.vetoThrown(current, file, e);
                throw e;
            }
        }
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void vetoThrown(AudioFileModificationListener cause, AudioFile original, ModifyVetoException veto) {
        Enumeration enumer = this.listeners.elements();
        while (enumer.hasMoreElements()) {
            AudioFileModificationListener current = (AudioFileModificationListener)enumer.nextElement();
            current.vetoThrown(cause, original, veto);
        }
    }
}

