/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.Tag;

public class AudioFile {
    protected File file;
    protected AudioHeader audioHeader;
    protected Tag tag;

    public AudioFile() {
    }

    public AudioFile(File f, AudioHeader audioHeader, Tag tag) {
        this.file = f;
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public AudioFile(String s, AudioHeader audioHeader, Tag tag) {
        this.file = new File(s);
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public void commit() throws CannotWriteException {
        AudioFileIO.write(this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public AudioHeader getAudioHeader() {
        return this.audioHeader;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "AudioFile " + this.getFile().getAbsolutePath() + "  --------\n" + this.audioHeader.toString() + "\n" + (this.tag == null ? "" : this.tag.toString()) + "\n-------------------";
    }

    protected RandomAccessFile checkFilePermissions(File file, boolean readOnly) throws ReadOnlyFileException, FileNotFoundException {
        RandomAccessFile newFile;
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to find:" + file.getPath());
        }
        if (readOnly) {
            newFile = new RandomAccessFile(file, "r");
        } else {
            if (!file.canWrite()) {
                throw new ReadOnlyFileException("Unable to write to:" + file.getPath());
            }
            newFile = new RandomAccessFile(file, "rw");
        }
        return newFile;
    }

    public String displayStructureAsXML() {
        return "";
    }

    public String displayStructureAsPlainText() {
        return "";
    }
}

