/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import java.io.PrintWriter;
import java.util.Vector;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentAttributeImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentImpl;
import org.w3c.dom.Node;

public class SimpleXMLParserDocumentNodeImpl
implements SimpleXMLParserDocumentNode {
    protected SimpleXMLParserDocumentImpl document;
    protected Node node;
    protected SimpleXMLParserDocumentNode[] kids;

    protected SimpleXMLParserDocumentNodeImpl(SimpleXMLParserDocumentImpl simpleXMLParserDocumentImpl, Node node) {
        this.document = simpleXMLParserDocumentImpl;
        this.node = node;
    }

    protected Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.node.getLocalName();
    }

    public String getFullName() {
        return this.node.getNodeName();
    }

    public String getNameSpaceURI() {
        return this.node.getNamespaceURI();
    }

    public String getValue() {
        if (this.node.getNodeType() == 7) {
            return this.node.getNodeValue();
        }
        String string = "";
        for (Node node = this.node.getFirstChild(); node != null; node = node.getNextSibling()) {
            short s = node.getNodeType();
            if (s != 4 && s != 3 && s != 12) continue;
            String string2 = node.getNodeValue();
            string = string + string2;
        }
        return string;
    }

    public SimpleXMLParserDocumentAttribute getAttribute(String string) {
        SimpleXMLParserDocumentAttribute[] simpleXMLParserDocumentAttributeArray = this.getAttributes();
        for (int i = 0; i < simpleXMLParserDocumentAttributeArray.length; ++i) {
            if (!simpleXMLParserDocumentAttributeArray[i].getName().equalsIgnoreCase(string)) continue;
            return simpleXMLParserDocumentAttributeArray[i];
        }
        return null;
    }

    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        int n;
        Object object;
        Vector<SimpleXMLParserDocumentAttributeImpl> vector = new Vector<SimpleXMLParserDocumentAttributeImpl>();
        if (this.node.getNodeType() == 1) {
            object = this.node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node = object.item(n);
                vector.addElement(new SimpleXMLParserDocumentAttributeImpl(node.getNodeName(), node.getNodeValue()));
            }
        }
        for (object = this.node.getFirstChild(); object != null; object = object.getNextSibling()) {
            n = object.getNodeType();
            if (n != 2) continue;
            vector.addElement(new SimpleXMLParserDocumentAttributeImpl(object.getNodeName(), object.getNodeValue()));
        }
        object = new SimpleXMLParserDocumentAttributeImpl[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public SimpleXMLParserDocumentNode[] getChildren() {
        if (this.kids == null) {
            this.kids = this.document.parseNode(this.node, true);
        }
        return this.kids;
    }

    public SimpleXMLParserDocumentNode getChild(String string) {
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = this.getChildren();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            if (!simpleXMLParserDocumentNodeArray[i].getName().equalsIgnoreCase(string)) continue;
            return simpleXMLParserDocumentNodeArray[i];
        }
        return null;
    }

    public void print() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.print(printWriter);
        printWriter.flush();
    }

    public void print(PrintWriter printWriter) {
        this.print(printWriter, "");
    }

    protected void print(PrintWriter printWriter, String string) {
        String string2 = "";
        SimpleXMLParserDocumentAttribute[] simpleXMLParserDocumentAttributeArray = this.getAttributes();
        for (int i = 0; i < simpleXMLParserDocumentAttributeArray.length; ++i) {
            string2 = string2 + (i == 0 ? "" : ",") + simpleXMLParserDocumentAttributeArray[i].getName() + "=" + simpleXMLParserDocumentAttributeArray[i].getValue();
        }
        printWriter.println(string + this.getName() + ":" + string2 + " -> " + this.getValue());
        SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = this.getChildren();
        for (int i = 0; i < simpleXMLParserDocumentNodeArray.length; ++i) {
            ((SimpleXMLParserDocumentNodeImpl)simpleXMLParserDocumentNodeArray[i]).print(printWriter, string + "  ");
        }
    }
}

