/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.net.URL;
import java.util.Date;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class RSSItemImpl
implements RSSItem {
    private boolean is_atom;
    private SimpleXMLParserDocumentNode node;

    protected RSSItemImpl(SimpleXMLParserDocumentNode simpleXMLParserDocumentNode, boolean bl) {
        this.is_atom = bl;
        this.node = simpleXMLParserDocumentNode;
    }

    public String getTitle() {
        if (this.node.getChild("title") != null) {
            return this.node.getChild("title").getValue();
        }
        return null;
    }

    public String getDescription() {
        if (this.node.getChild("description") != null) {
            return this.node.getChild("description").getValue();
        }
        return null;
    }

    public URL getLink() {
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = this.node.getChild("link");
        if (simpleXMLParserDocumentNode != null) {
            try {
                if (this.is_atom) {
                    SimpleXMLParserDocumentAttribute simpleXMLParserDocumentAttribute = simpleXMLParserDocumentNode.getAttribute("href");
                    if (simpleXMLParserDocumentAttribute == null) {
                        return null;
                    }
                    String string = simpleXMLParserDocumentAttribute.getValue().trim();
                    if (string.length() == 0) {
                        return null;
                    }
                    return new URL(string);
                }
                String string = simpleXMLParserDocumentNode.getValue().trim();
                if (string.length() == 0) {
                    return null;
                }
                return new URL(string);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return null;
            }
        }
        return null;
    }

    public Date getPublicationDate() {
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = this.node.getChild(this.is_atom ? "published" : "pubdate");
        if (simpleXMLParserDocumentNode != null) {
            if (this.is_atom) {
                return RSSUtils.parseAtomDate(simpleXMLParserDocumentNode.getValue());
            }
            return RSSUtils.parseRSSDate(simpleXMLParserDocumentNode.getValue());
        }
        return null;
    }

    public String getUID() {
        String string;
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = this.node.getChild(this.is_atom ? "id" : "guid");
        if (simpleXMLParserDocumentNode != null && (string = simpleXMLParserDocumentNode.getValue().trim()).length() > 0) {
            return string;
        }
        return null;
    }

    public SimpleXMLParserDocumentNode getNode() {
        return this.node;
    }
}

