/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderTorrentImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    public static final int MAX_FOLLOWS = 1;
    protected ResourceDownloaderBaseImpl delegate;
    protected boolean persistent;
    protected File download_dir;
    protected long size = -2L;
    protected TOTorrent[] torrent_holder = new TOTorrent[1];
    protected DownloadManager download_manager;
    protected Download download;
    protected boolean cancelled;
    protected boolean completed;
    protected ResourceDownloader current_downloader;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTorrent");

    public ResourceDownloaderTorrentImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, ResourceDownloader resourceDownloader, boolean bl, File file) {
        super(resourceDownloaderBaseImpl);
        this.persistent = bl;
        this.download_dir = file;
        this.delegate = (ResourceDownloaderBaseImpl)resourceDownloader;
        this.delegate.setParent(this);
        this.download_manager = PluginInitializer.getDefaultInterface().getDownloadManager();
    }

    public String getName() {
        return this.delegate.getName() + ": torrent";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                this.size = this.getSizeSupport();
                Object var2_1 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
        this.delegate.setProperty(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            Object object;
            block10: {
                if (this.torrent_holder[0] != null) break block10;
                object = this.delegate.getClone(this);
                this.addReportListener((ResourceDownloader)object);
                InputStream inputStream = object.download();
                try {
                    this.torrent_holder[0] = TOTorrentFactory.deserialiseFromBEncodedInputStream(inputStream);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                if (!this.torrent_holder[0].isSimpleTorrent()) {
                    throw new ResourceDownloaderException(this, "Only simple torrents supported");
                }
            }
            try {
                object = new String(this.torrent_holder[0].getName());
                int n = ((String)object).lastIndexOf(".");
                String string = n != -1 ? ((String)object).substring(n + 1) : null;
                this.setProperty("ContentType", HTTPUtils.guessContentTypeFromFileType(string));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            return this.torrent_holder[0].getSize();
        }
        catch (TOTorrentException tOTorrentException) {
            throw new ResourceDownloaderException(this, "Torrent deserialisation failed", tOTorrentException);
        }
    }

    protected void setSizeAndTorrent(long l, TOTorrent[] tOTorrentArray) {
        this.size = l;
        this.torrent_holder = tOTorrentArray;
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloaderTorrentImpl resourceDownloaderTorrentImpl = new ResourceDownloaderTorrentImpl(resourceDownloaderBaseImpl, this.delegate.getClone(this), this.persistent, this.download_dir);
        resourceDownloaderTorrentImpl.setSizeAndTorrent(this.size, this.torrent_holder);
        resourceDownloaderTorrentImpl.setProperties(this);
        return resourceDownloaderTorrentImpl;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else if (this.torrent_holder[0] == null) {
                this.current_downloader = this.delegate.getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            } else {
                this.downloadTorrent();
            }
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void downloadTorrent() {
        try {
            Object object;
            String string = new String(this.torrent_holder[0].getName(), "UTF8");
            this.informActivity(this.getLogIndent() + "Downloading: " + string);
            final File file = File.createTempFile("AZU", null);
            if (this.download_dir != null && !this.download_dir.exists()) {
                FileUtil.mkdirs(this.download_dir);
            }
            final File file2 = this.download_dir == null ? file.getParentFile() : this.download_dir;
            final TOTorrent tOTorrent = this.torrent_holder[0];
            TorrentUtils.setFlag(tOTorrent, 1, true);
            tOTorrent.serialiseToBEncodedFile(file);
            try {
                int n;
                object = this.download_manager.getDownload(tOTorrent.getHash());
                if (object != null && ((n = object.getState()) == 8 || n == 7)) {
                    this.informActivity(this.getLogIndent() + "Deleting existing stopped/error state download for " + string);
                    object.remove(true, true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.download = this.persistent ? this.download_manager.addDownload(new TorrentImpl(tOTorrent), file, file2) : this.download_manager.addNonPersistentDownload(new TorrentImpl(tOTorrent), file, file2);
            this.download.moveTo(1);
            this.download.setForceStart(true);
            this.download.setFlag(4L, true);
            this.download_manager.addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                }

                public void downloadRemoved(Download download) {
                    if (ResourceDownloaderTorrentImpl.this.download == download) {
                        ResourceDownloaderTorrentImpl.this.downloadRemoved(file, file2);
                    }
                }
            });
            this.download.addListener(new DownloadListener(){

                public void stateChanged(final Download download, int n, int n2) {
                    if (n2 == 5) {
                        download.removeListener(this);
                        PluginInitializer.getDefaultInterface().getUtilities().createThread("resource complete event dispatcher", new Runnable(){

                            public void run() {
                                ResourceDownloaderTorrentImpl.this.downloadSucceeded(download, file, file2);
                            }
                        });
                    }
                }

                public void positionChanged(Download download, int n, int n2) {
                }
            });
            object = new AEThread("RDTorrent percentage checker"){

                public void runSupport() {
                    int n = 0;
                    while (ResourceDownloaderTorrentImpl.this.result == null) {
                        int n2 = ResourceDownloaderTorrentImpl.this.download.getStats().getDownloadCompleted(false) / 10;
                        long l = tOTorrent.getSize();
                        if (n2 != n) {
                            ResourceDownloaderTorrentImpl.this.reportPercentComplete(ResourceDownloaderTorrentImpl.this, n2);
                            n = n2;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            };
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            if (this.download.getState() == 5) {
                this.downloadSucceeded(this.download, file, file2);
            }
        }
        catch (Throwable throwable) {
            this.failed(this, new ResourceDownloaderException(this, "Torrent download failed", throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadSucceeded(Download download, File file, File file2) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.reportActivity("Torrent download complete");
        object2 = new File(file2, new String(this.torrent_holder[0].getFiles()[0].getPathComponents()[0]));
        if (!((File)object2).exists()) {
            object = new File(download.getSavePath());
            try {
                if (this.download_dir != null && ((File)object).exists()) {
                    FileUtil.copyFile((File)object, (File)object2);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            object2 = object;
        }
        try {
            if (!((File)object2).exists()) {
                throw new Exception("File '" + ((File)object2).toString() + "' not found");
            }
            object = new FileInputStream((File)object2);
            this.informComplete((InputStream)object);
            this.result = object;
            this.done_sem.release();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            this.failed(this, new ResourceDownloaderException(this, "Failed to read downloaded torrent data: " + throwable.getMessage(), throwable));
        }
    }

    protected void downloadRemoved(File file, File file2) {
        this.reportActivity("Torrent removed");
        if (!(this.result instanceof InputStream)) {
            this.failed(this, new ResourceDownloaderException(this, "Download did not complete"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException(this);
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        block10: {
            block9: {
                this.torrent_holder[0] = TOTorrentFactory.deserialiseFromBEncodedInputStream(inputStream);
                if (this.torrent_holder[0].isSimpleTorrent()) {
                    this.downloadTorrent();
                    break block9;
                }
                this.failed(this, new ResourceDownloaderException(this, "Only simple torrents supported"));
            }
            Object var5_3 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            break block10;
            {
                catch (TOTorrentException tOTorrentException) {
                    this.failed(resourceDownloader, new ResourceDownloaderException(this, "Torrent deserialisation failed", tOTorrentException));
                    Object var5_4 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.done_sem.release();
        this.informFailed(resourceDownloaderException);
    }

    public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
        if (resourceDownloader == this) {
            this.informPercentDone(n);
        }
    }
}

