/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public abstract class ResourceDownloaderBaseImpl
implements ResourceDownloader {
    private static final String PR_PROPERTIES_SET = "!!!! properties set !!!!";
    private List listeners = new ArrayList();
    private boolean result_informed;
    private Object result_informed_data;
    private ResourceDownloaderBaseImpl parent;
    private List children = new ArrayList();
    private boolean download_cancelled;
    private Map lc_key_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("ResourceDownloader");

    protected ResourceDownloaderBaseImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        this.parent = resourceDownloaderBaseImpl;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public abstract ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl var1);

    protected abstract void setSize(long var1);

    public Object getProperty(String string) throws ResourceDownloaderException {
        Object object = this.getPropertySupport(string);
        if (object != null || this.getPropertySupport(PR_PROPERTIES_SET) != null) {
            return object;
        }
        this.getSize();
        return this.getPropertySupport(string);
    }

    protected Object getPropertySupport(String string) {
        return this.lc_key_properties.get(string.toLowerCase(MessageText.LOCALE_ENGLISH));
    }

    protected Map getLCKeyProperties() {
        return this.lc_key_properties;
    }

    protected String getStringPropertySupport(String string) {
        Object v = this.lc_key_properties.get(string.toLowerCase(MessageText.LOCALE_ENGLISH));
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }

    protected void setPropertiesSet() throws ResourceDownloaderException {
        this.setProperty(PR_PROPERTIES_SET, "true");
    }

    protected void setPropertySupport(String string, Object object) {
        boolean bl;
        boolean bl2 = bl = this.lc_key_properties.put(string.toLowerCase(MessageText.LOCALE_ENGLISH), object) == object;
        if (this.parent != null && !bl) {
            try {
                this.parent.setProperty(string, object);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void setProperties(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        Map map = resourceDownloaderBaseImpl.lc_key_properties;
        for (String string : map.keySet()) {
            try {
                this.setProperty(string, map.get(string));
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void setParent(ResourceDownloader resourceDownloader) {
        ResourceDownloaderBaseImpl resourceDownloaderBaseImpl = this.parent;
        this.parent = (ResourceDownloaderBaseImpl)resourceDownloader;
        if (resourceDownloaderBaseImpl != null) {
            resourceDownloaderBaseImpl.removeChild(this);
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    protected ResourceDownloaderBaseImpl getParent() {
        return this.parent;
    }

    protected void addChild(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        this.children.add(resourceDownloaderBaseImpl);
    }

    protected void removeChild(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        this.children.remove(resourceDownloaderBaseImpl);
    }

    protected List getChildren() {
        return this.children;
    }

    protected String getLogIndent() {
        String string = "";
        for (ResourceDownloaderBaseImpl resourceDownloaderBaseImpl = this.parent; resourceDownloaderBaseImpl != null; resourceDownloaderBaseImpl = resourceDownloaderBaseImpl.getParent()) {
            string = string + "  ";
        }
        return string;
    }

    protected void addReportListener(ResourceDownloader resourceDownloader) {
        resourceDownloader.addListener(new ResourceDownloaderAdapter(){

            public void reportActivity(ResourceDownloader resourceDownloader, String string) {
                ResourceDownloaderBaseImpl.this.informActivity(string);
            }

            public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                ResourceDownloaderBaseImpl.this.informActivity(resourceDownloader.getName() + ":" + resourceDownloaderException.getMessage());
            }
        });
    }

    protected void informPercentDone(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ResourceDownloaderListener)this.listeners.get(i)).reportPercentComplete(this, n);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void informAmountComplete(long l) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ResourceDownloaderListener)this.listeners.get(i)).reportAmountComplete(this, l);
                continue;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                continue;
            }
            catch (AbstractMethodError abstractMethodError) {
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void reportActivity(String string) {
        this.informActivity(string);
    }

    protected void informActivity(String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ResourceDownloaderListener)this.listeners.get(i)).reportActivity(this, string);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected boolean informComplete(InputStream inputStream) {
        if (!this.result_informed) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    if (((ResourceDownloaderListener)this.listeners.get(i)).completed(this, inputStream)) continue;
                    return false;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    return false;
                }
            }
            this.result_informed = true;
            this.result_informed_data = inputStream;
        }
        return true;
    }

    protected void informFailed(ResourceDownloaderException resourceDownloaderException) {
        if (!this.result_informed) {
            this.result_informed = true;
            this.result_informed_data = resourceDownloaderException;
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((ResourceDownloaderListener)this.listeners.get(i)).failed(this, resourceDownloaderException);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void reportActivity(ResourceDownloader resourceDownloader, String string) {
        this.informActivity(string);
    }

    public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
        this.informPercentDone(n);
    }

    public void reportAmountComplete(ResourceDownloader resourceDownloader, long l) {
        this.informAmountComplete(l);
    }

    protected void setCancelled() {
        this.download_cancelled = true;
    }

    public boolean isCancelled() {
        return this.download_cancelled;
    }

    public void addListener(ResourceDownloaderListener resourceDownloaderListener) {
        this.listeners.add(resourceDownloaderListener);
        if (this.result_informed) {
            if (this.result_informed_data instanceof InputStream) {
                resourceDownloaderListener.completed(this, (InputStream)this.result_informed_data);
            } else {
                resourceDownloaderListener.failed(this, (ResourceDownloaderException)this.result_informed_data);
            }
        }
    }

    public void removeListener(ResourceDownloaderListener resourceDownloaderListener) {
        this.listeners.remove(resourceDownloaderListener);
    }
}

