/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;

public class TrackerWebPageRequestImpl
implements TrackerWebPageRequest {
    private Tracker tracker;
    private TrackerWebContext context;
    private TRTrackerServerListener2.ExternalRequest request;

    protected TrackerWebPageRequestImpl(Tracker tracker, TrackerWebContext trackerWebContext, TRTrackerServerListener2.ExternalRequest externalRequest) {
        this.tracker = tracker;
        this.context = trackerWebContext;
        this.request = externalRequest;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public TrackerWebContext getContext() {
        return this.context;
    }

    public String getURL() {
        return this.request.getURL();
    }

    public URL getAbsoluteURL() {
        return this.request.getAbsoluteURL();
    }

    public String getClientAddress() {
        return this.request.getClientAddress().getAddress().getHostAddress();
    }

    public InetSocketAddress getClientAddress2() {
        return this.request.getClientAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.request.getLocalAddress();
    }

    public String getUser() {
        return this.request.getUser();
    }

    public InputStream getInputStream() {
        return this.request.getInputStream();
    }

    protected OutputStream getOutputStream() {
        return this.request.getOutputStream();
    }

    protected AsyncController getAsyncController() {
        return this.request.getAsyncController();
    }

    public boolean canKeepAlive() {
        return this.request.canKeepAlive();
    }

    public void setKeepAlive(boolean bl) {
        this.request.setKeepAlive(bl);
    }

    public String getHeader() {
        return this.request.getHeader();
    }

    public Map getHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.request.getHeader().split("\r\n");
        hashMap.put("status", stringArray[0].trim());
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":", 2);
            hashMap.put(stringArray2[0].trim().toLowerCase(MessageText.LOCALE_ENGLISH), stringArray2[1].trim());
        }
        return hashMap;
    }
}

