/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareResourceDirContentsImpl
extends ShareResourceImpl
implements ShareResourceDirContents {
    protected File root;
    protected boolean recursive;
    protected ShareResource[] children = new ShareResource[0];

    protected ShareResourceDirContentsImpl(ShareManagerImpl shareManagerImpl, File file, boolean bl, boolean bl2) throws ShareException {
        super(shareManagerImpl, 3);
        this.root = file;
        this.recursive = bl;
        if (!this.root.exists()) {
            throw new ShareException("Dir '".concat(this.root.getName()).concat("' not found"));
        }
        if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        if (bl2) {
            new AEThread2("SM:asyncCheck", true){

                public void run() {
                    try {
                        ShareResourceDirContentsImpl.this.checkConsistency();
                    }
                    catch (Throwable throwable) {
                        Debug.out("Failed to update consistency", throwable);
                    }
                }
            }.start();
        } else {
            this.checkConsistency();
        }
    }

    protected ShareResourceDirContentsImpl(ShareManagerImpl shareManagerImpl, File file, boolean bl, Map map) throws ShareException {
        super(shareManagerImpl, 3, map);
        this.root = file;
        this.recursive = bl;
        if (!this.root.exists()) {
            Debug.out("Dir '" + this.root.getName() + "' not found");
        } else if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
    }

    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].canBeDeleted()) continue;
            return false;
        }
        return true;
    }

    protected void checkConsistency() throws ShareException {
        List list = this.checkConsistency(this.root);
        if (list != null) {
            this.children = new ShareResource[list.size()];
            list.toArray(this.children);
        } else {
            this.children = new ShareResource[0];
        }
    }

    protected List checkConsistency(File file) throws ShareException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File[] fileArray = file.listFiles();
        if (fileArray == null || !file.exists()) {
            if (file == this.root) {
                return null;
            }
            this.manager.delete(this, true);
        } else {
            File file2;
            int n;
            for (n = 0; n < fileArray.length; ++n) {
                Object object;
                file2 = fileArray[n];
                String string = file2.getName();
                if (string.equals(".") || string.equals("..")) continue;
                if (file2.isDirectory()) {
                    if (this.recursive) {
                        object = this.checkConsistency(file2);
                        arrayList.add(new shareNode(this, file2, (List)object));
                        continue;
                    }
                    try {
                        object = this.manager.getDir(file2);
                        if (object == null) {
                            object = this.manager.addDir(this, file2);
                        }
                        arrayList.add(object);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                    continue;
                }
                try {
                    object = this.manager.getFile(file2);
                    if (object == null) {
                        object = this.manager.addFile(this, file2);
                    }
                    arrayList.add(object);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            for (n = 0; n < arrayList.size(); ++n) {
                file2 = arrayList.get(n);
                if (file2 instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)((Object)file2)).setParent(this);
                    continue;
                }
                ((shareNode)((Object)file2)).setParent(this);
            }
        }
        return arrayList;
    }

    protected void deleteInternal() {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (this.children[i] instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)this.children[i]).delete(true);
                    continue;
                }
                ((shareNode)this.children[i]).delete(true);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        map.put("recursive", new Long(this.recursive ? 1L : 0L));
        try {
            map.put("file", this.root.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl shareManagerImpl, Map map) throws ShareException {
        try {
            File file = new File(new String((byte[])map.get("file"), "UTF8"));
            boolean bl = (Long)map.get("recursive") == 1L;
            ShareResourceDirContentsImpl shareResourceDirContentsImpl = new ShareResourceDirContentsImpl(shareManagerImpl, file, bl, map);
            return shareResourceDirContentsImpl;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ShareException("internal error", unsupportedEncodingException);
        }
    }

    public String getName() {
        return this.root.toString();
    }

    public File getRoot() {
        return this.root;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public ShareResource[] getChildren() {
        return this.children;
    }

    protected class shareNode
    implements ShareResourceDirContents {
        protected ShareResourceDirContents node_parent;
        protected File node;
        protected ShareResource[] node_children;

        protected shareNode(ShareResourceDirContents shareResourceDirContents, File file, List list) {
            this.node_parent = shareResourceDirContents;
            this.node = file;
            this.node_children = new ShareResource[list.size()];
            list.toArray(this.node_children);
            for (int i = 0; i < this.node_children.length; ++i) {
                ShareResource shareResource = this.node_children[i];
                if (shareResource instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)shareResource).setParent(this);
                    continue;
                }
                ((shareNode)shareResource).setParent(this);
            }
        }

        public ShareResourceDirContents getParent() {
            return this.node_parent;
        }

        protected void setParent(ShareResourceDirContents shareResourceDirContents) {
            this.node_parent = shareResourceDirContents;
        }

        public int getType() {
            return 3;
        }

        public String getName() {
            return this.node.toString();
        }

        public void setAttribute(TorrentAttribute torrentAttribute, String string) {
            for (int i = 0; i < this.node_children.length; ++i) {
                this.node_children[i].setAttribute(torrentAttribute, string);
            }
        }

        public String getAttribute(TorrentAttribute torrentAttribute) {
            return null;
        }

        public TorrentAttribute[] getAttributes() {
            return new TorrentAttribute[0];
        }

        public void delete() throws ShareResourceDeletionVetoException {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }

        public void delete(boolean bl) throws ShareException, ShareResourceDeletionVetoException {
            for (int i = 0; i < this.node_children.length; ++i) {
                ShareResource shareResource = this.node_children[i];
                if (shareResource instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)shareResource).delete(bl);
                    continue;
                }
                ((shareNode)shareResource).delete(bl);
            }
        }

        public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
            for (int i = 0; i < this.node_children.length; ++i) {
                this.node_children[i].canBeDeleted();
            }
            return true;
        }

        public File getRoot() {
            return this.node;
        }

        public boolean isRecursive() {
            return ShareResourceDirContentsImpl.this.recursive;
        }

        public ShareResource[] getChildren() {
            return this.node_children;
        }

        public void addChangeListener(ShareResourceListener shareResourceListener) {
        }

        public void removeChangeListener(ShareResourceListener shareResourceListener) {
        }

        public void addDeletionListener(ShareResourceWillBeDeletedListener shareResourceWillBeDeletedListener) {
        }

        public void removeDeletionListener(ShareResourceWillBeDeletedListener shareResourceWillBeDeletedListener) {
        }
    }
}

