/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;

public class PeerManagerStatsImpl
implements PeerManagerStats {
    protected PEPeerManager manager;
    protected PEPeerManagerStats stats;

    protected PeerManagerStatsImpl(PEPeerManager pEPeerManager) {
        this.manager = pEPeerManager;
        this.stats = this.manager.getStats();
    }

    public int getConnectedSeeds() {
        return this.manager.getNbSeeds();
    }

    public int getConnectedLeechers() {
        return this.manager.getNbPeers();
    }

    public long getDownloaded() {
        return this.stats.getTotalDataBytesReceived();
    }

    public long getUploaded() {
        return this.stats.getTotalDataBytesSent();
    }

    public long getDownloadAverage() {
        return this.stats.getDataReceiveRate();
    }

    public long getUploadAverage() {
        return this.stats.getDataSendRate();
    }

    public long getDiscarded() {
        return this.stats.getTotalDiscarded();
    }

    public long getHashFailBytes() {
        return this.stats.getTotalHashFailBytes();
    }

    public int getPermittedBytesToReceive() {
        return this.stats.getPermittedBytesToReceive();
    }

    public void permittedReceiveBytesUsed(int n) {
        this.stats.permittedReceiveBytesUsed(n);
    }

    public int getPermittedBytesToSend() {
        return this.stats.getPermittedBytesToSend();
    }

    public void permittedSendBytesUsed(int n) {
        this.stats.permittedSendBytesUsed(n);
    }
}

