/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.peers.Piece;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class PeerManagerImpl
implements PeerManager {
    private static final String PEPEER_DATA_KEY = PeerManagerImpl.class.getName();
    protected PEPeerManager manager;
    protected static AEMonitor pm_map_mon = new AEMonitor("PeerManager:Map");
    private Map foreign_map = new HashMap();
    private Map<PeerManagerListener, PEPeerManagerListener> listener_map1 = new HashMap<PeerManagerListener, PEPeerManagerListener>();
    private Map<PeerManagerListener2, CoreListener> listener_map2 = new HashMap<PeerManagerListener2, CoreListener>();
    protected AEMonitor this_mon = new AEMonitor("PeerManager");
    private final DiskManagerPiece[] dm_pieces;
    private final PEPiece[] pe_pieces;
    private pieceFacade[] piece_facades;
    private boolean destroyed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerManagerImpl getPeerManager(PEPeerManager pEPeerManager) {
        try {
            pm_map_mon.enter();
            PeerManagerImpl peerManagerImpl = (PeerManagerImpl)pEPeerManager.getData("PluginPeerManager");
            if (peerManagerImpl == null) {
                peerManagerImpl = new PeerManagerImpl(pEPeerManager);
                pEPeerManager.setData("PluginPeerManager", peerManagerImpl);
            }
            PeerManagerImpl peerManagerImpl2 = peerManagerImpl;
            Object var4_3 = null;
            pm_map_mon.exit();
            return peerManagerImpl2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            pm_map_mon.exit();
            throw throwable;
        }
    }

    protected PeerManagerImpl(PEPeerManager pEPeerManager) {
        this.manager = pEPeerManager;
        this.dm_pieces = pEPeerManager.getDiskManager().getPieces();
        this.pe_pieces = pEPeerManager.getPieces();
        this.manager.addListener(new PEPeerManagerListener(){

            public void peerAdded(PEPeerManager pEPeerManager, PEPeer pEPeer) {
            }

            public void peerRemoved(PEPeerManager pEPeerManager, PEPeer pEPeer) {
                PeerImpl peerImpl = PeerManagerImpl.getPeerForPEPeer(pEPeer);
                if (peerImpl != null) {
                    peerImpl.closed();
                }
            }

            public void peerDiscovered(PEPeerManager pEPeerManager, PeerItem peerItem, PEPeer pEPeer) {
            }

            public void peerSentBadData(PEPeerManager pEPeerManager, PEPeer pEPeer, int n) {
            }

            public void pieceAdded(PEPeerManager pEPeerManager, PEPiece pEPiece, PEPeer pEPeer) {
            }

            public void pieceRemoved(PEPeerManager pEPeerManager, PEPiece pEPiece) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void destroyed() {
                Map map = PeerManagerImpl.this.foreign_map;
                synchronized (map) {
                    PeerManagerImpl.this.destroyed = true;
                    Iterator iterator = PeerManagerImpl.this.foreign_map.values().iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((PeerForeignDelegate)iterator.next()).stop();
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }
        });
    }

    public PEPeerManager getDelegate() {
        return this.manager;
    }

    public DiskManager getDiskManager() {
        return new DiskManagerImpl(this.manager.getDiskManager());
    }

    public PeerManagerStats getStats() {
        return new PeerManagerStatsImpl(this.manager);
    }

    public boolean isSeeding() {
        return this.manager.getDiskManager().getRemainingExcludingDND() == 0L;
    }

    public boolean isSuperSeeding() {
        return this.manager.isSuperSeedMode();
    }

    public Download getDownload() throws DownloadException {
        return DownloadManagerImpl.getDownloadStatic(this.manager.getDiskManager().getTorrent());
    }

    public Piece[] getPieces() {
        if (this.piece_facades == null) {
            pieceFacade[] pieceFacadeArray = new pieceFacade[this.manager.getDiskManager().getNbPieces()];
            for (int i = 0; i < pieceFacadeArray.length; ++i) {
                pieceFacadeArray[i] = new pieceFacade(i);
            }
            this.piece_facades = pieceFacadeArray;
        }
        return this.piece_facades;
    }

    public PeerStats createPeerStats(Peer peer) {
        PEPeer pEPeer = this.mapForeignPeer(peer);
        return new PeerStatsImpl(this, peer, this.manager.createPeerStats(pEPeer));
    }

    public void requestComplete(PeerReadRequest peerReadRequest, PooledByteBuffer pooledByteBuffer, Peer peer) {
        this.manager.writeBlock(peerReadRequest.getPieceNumber(), peerReadRequest.getOffset(), ((PooledByteBufferImpl)pooledByteBuffer).getBuffer(), this.mapForeignPeer(peer), false);
        PeerForeignDelegate peerForeignDelegate = this.lookupForeignPeer(peer);
        if (peerForeignDelegate != null) {
            peerForeignDelegate.dataReceived();
        }
    }

    public void requestCancelled(PeerReadRequest peerReadRequest, Peer peer) {
        this.manager.requestCanceled((DiskManagerReadRequest)peerReadRequest);
    }

    protected int getPartitionID() {
        return this.manager.getPartitionID();
    }

    public void addPeer(Peer peer) {
        this.manager.addPeer(this.mapForeignPeer(peer));
    }

    public void removePeer(Peer peer) {
        this.manager.removePeer(this.mapForeignPeer(peer));
    }

    protected void removePeer(Peer peer, String string) {
        this.manager.removePeer(this.mapForeignPeer(peer), string);
    }

    public void addPeer(String string, int n) {
        this.addPeer(string, n, 0, NetworkManager.getCryptoRequired(0));
    }

    public void addPeer(String string, int n, boolean bl) {
        this.addPeer(string, n, 0, bl);
    }

    public void addPeer(String string, int n, int n2, boolean bl) {
        this.addPeer(string, n, n2, bl, (Map)null);
    }

    public void addPeer(String string, int n, int n2, boolean bl, Map map) {
        this.checkIfPrivate();
        if (this.pluginPeerSourceEnabled()) {
            this.manager.addPeer(string, n, n2, bl, map);
        }
    }

    protected boolean pluginPeerSourceEnabled() {
        if (this.manager.isPeerSourceEnabled("Plugin")) {
            return true;
        }
        Debug.out("Plugin peer source disabled for " + this.manager.getDisplayName());
        return false;
    }

    protected void checkIfPrivate() {
        Download download;
        try {
            download = this.getDownload();
        }
        catch (Throwable throwable) {
            return;
        }
        Torrent torrent = download.getTorrent();
        if (torrent != null && TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
            throw new RuntimeException("Torrent is private, peer addition not permitted");
        }
    }

    public Peer[] getPeers() {
        List<PEPeer> list = this.manager.getPeers();
        Peer[] peerArray = new Peer[list.size()];
        for (int i = 0; i < peerArray.length; ++i) {
            peerArray[i] = PeerManagerImpl.getPeerForPEPeer(list.get(i));
        }
        return peerArray;
    }

    public Peer[] getPeers(String string) {
        List<PEPeer> list = this.manager.getPeers(string);
        Peer[] peerArray = new Peer[list.size()];
        for (int i = 0; i < peerArray.length; ++i) {
            peerArray[i] = PeerManagerImpl.getPeerForPEPeer(list.get(i));
        }
        return peerArray;
    }

    public PeerDescriptor[] getPendingPeers() {
        return this.manager.getPendingPeers();
    }

    public PeerDescriptor[] getPendingPeers(String string) {
        return this.manager.getPendingPeers(string);
    }

    public long getTimeSinceConnectionEstablished(Peer peer) {
        if (peer instanceof PeerImpl) {
            return ((PeerImpl)peer).getDelegate().getTimeSinceConnectionEstablished();
        }
        PeerForeignDelegate peerForeignDelegate = this.lookupForeignPeer(peer);
        if (peerForeignDelegate != null) {
            return peerForeignDelegate.getTimeSinceConnectionEstablished();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPeer mapForeignPeer(Peer peer) {
        if (peer instanceof PeerImpl) {
            return ((PeerImpl)peer).getDelegate();
        }
        Map map = this.foreign_map;
        synchronized (map) {
            PEPeer pEPeer = (PEPeer)this.foreign_map.get(peer);
            if (pEPeer == null) {
                if (this.destroyed) {
                    Debug.out("Peer added to destroyed peer manager");
                    return null;
                }
                pEPeer = new PeerForeignDelegate(this, peer);
                peer.setUserData(PeerManagerImpl.class, pEPeer);
                this.foreign_map.put(peer, pEPeer);
            }
            return pEPeer;
        }
    }

    protected PeerForeignDelegate lookupForeignPeer(Peer peer) {
        return (PeerForeignDelegate)peer.getUserData(PeerManagerImpl.class);
    }

    public List mapForeignPeers(Peer[] peerArray) {
        ArrayList<PEPeer> arrayList = new ArrayList<PEPeer>();
        for (int i = 0; i < peerArray.length; ++i) {
            PEPeer pEPeer = this.mapForeignPeer(peerArray[i]);
            if (arrayList.contains(pEPeer)) continue;
            arrayList.add(pEPeer);
        }
        return arrayList;
    }

    public static PeerImpl getPeerForPEPeer(PEPeer pEPeer) {
        PeerImpl peerImpl = (PeerImpl)pEPeer.getData(PEPEER_DATA_KEY);
        if (peerImpl == null) {
            peerImpl = new PeerImpl(pEPeer);
            pEPeer.setData(PEPEER_DATA_KEY, peerImpl);
        }
        return peerImpl;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.manager.getUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.manager.getDownloadRateLimitBytesPerSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(final PeerManagerListener peerManagerListener) {
        try {
            this.this_mon.enter();
            final HashMap hashMap = new HashMap();
            PEPeerManagerListener pEPeerManagerListener = new PEPeerManagerListener(){

                public void peerAdded(PEPeerManager pEPeerManager, PEPeer pEPeer) {
                    PeerImpl peerImpl = PeerManagerImpl.getPeerForPEPeer(pEPeer);
                    hashMap.put(pEPeer, peerImpl);
                    peerManagerListener.peerAdded(PeerManagerImpl.this, peerImpl);
                }

                public void peerRemoved(PEPeerManager pEPeerManager, PEPeer pEPeer) {
                    PeerImpl peerImpl = (PeerImpl)hashMap.remove(pEPeer);
                    if (peerImpl != null) {
                        peerManagerListener.peerRemoved(PeerManagerImpl.this, peerImpl);
                    }
                }

                public void peerDiscovered(PEPeerManager pEPeerManager, PeerItem peerItem, PEPeer pEPeer) {
                }

                public void pieceAdded(PEPeerManager pEPeerManager, PEPiece pEPiece, PEPeer pEPeer) {
                }

                public void pieceRemoved(PEPeerManager pEPeerManager, PEPiece pEPiece) {
                }

                public void peerSentBadData(PEPeerManager pEPeerManager, PEPeer pEPeer, int n) {
                }

                public void destroyed() {
                }
            };
            this.listener_map1.put(peerManagerListener, pEPeerManagerListener);
            this.manager.addListener(pEPeerManagerListener);
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerManagerListener peerManagerListener) {
        try {
            this.this_mon.enter();
            PEPeerManagerListener pEPeerManagerListener = this.listener_map1.remove(peerManagerListener);
            if (pEPeerManagerListener != null) {
                this.manager.removeListener(pEPeerManagerListener);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerManagerListener2 peerManagerListener2) {
        try {
            this.this_mon.enter();
            CoreListener coreListener = new CoreListener(peerManagerListener2);
            this.listener_map2.put(peerManagerListener2, coreListener);
            this.manager.addListener(coreListener);
            this.manager.getDiskManager().addListener(coreListener);
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerManagerListener2 peerManagerListener2) {
        try {
            this.this_mon.enter();
            CoreListener coreListener = this.listener_map2.remove(peerManagerListener2);
            if (coreListener != null) {
                this.manager.removeListener(coreListener);
                this.manager.getDiskManager().removeListener(coreListener);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private class CoreListener
    implements PEPeerManagerListener,
    DiskManagerListener {
        private PeerManagerListener2 listener;
        private Map<PEPeer, Peer> peer_map = new HashMap<PEPeer, Peer>();

        private CoreListener(PeerManagerListener2 peerManagerListener2) {
            this.listener = peerManagerListener2;
        }

        public void peerAdded(PEPeerManager pEPeerManager, PEPeer pEPeer) {
            PeerImpl peerImpl = PeerManagerImpl.getPeerForPEPeer(pEPeer);
            this.peer_map.put(pEPeer, peerImpl);
            this.fireEvent(1, peerImpl, null, null);
        }

        public void peerRemoved(PEPeerManager pEPeerManager, PEPeer pEPeer) {
            PeerImpl peerImpl = (PeerImpl)this.peer_map.remove(pEPeer);
            if (peerImpl != null) {
                this.fireEvent(2, peerImpl, null, null);
            }
        }

        public void peerDiscovered(PEPeerManager pEPeerManager, PeerItem peerItem, PEPeer pEPeer) {
            PeerImpl peerImpl;
            if (pEPeer != null) {
                peerImpl = PeerManagerImpl.getPeerForPEPeer(pEPeer);
                this.peer_map.put(pEPeer, peerImpl);
            } else {
                peerImpl = null;
            }
            this.fireEvent(3, peerImpl, peerItem, null);
        }

        public void pieceAdded(PEPeerManager pEPeerManager, PEPiece pEPiece, PEPeer pEPeer) {
            PeerImpl peerImpl = pEPeer == null ? null : PeerManagerImpl.getPeerForPEPeer(pEPeer);
            this.fireEvent(5, peerImpl, null, new pieceFacade(pEPiece.getPieceNumber()));
        }

        public void pieceRemoved(PEPeerManager pEPeerManager, PEPiece pEPiece) {
            this.fireEvent(6, null, null, new pieceFacade(pEPiece.getPieceNumber()));
        }

        public void peerSentBadData(PEPeerManager pEPeerManager, PEPeer pEPeer, int n) {
            PeerImpl peerImpl = PeerManagerImpl.getPeerForPEPeer(pEPeer);
            this.peer_map.put(pEPeer, peerImpl);
            this.fireEvent(4, peerImpl, null, new Integer(n));
        }

        public void stateChanged(int n, int n2) {
        }

        public void filePriorityChanged(DiskManagerFileInfo diskManagerFileInfo) {
        }

        public void pieceDoneChanged(DiskManagerPiece diskManagerPiece) {
            this.fireEvent(7, null, null, new pieceFacade(diskManagerPiece.getPieceNumber()));
        }

        public void fileAccessModeChanged(DiskManagerFileInfo diskManagerFileInfo, int n, int n2) {
        }

        protected void fireEvent(final int n, final Peer peer, final PeerItem peerItem, final Object object) {
            this.listener.eventOccurred(new PeerManagerEvent(){

                public PeerManager getPeerManager() {
                    return PeerManagerImpl.this;
                }

                public int getType() {
                    return n;
                }

                public Peer getPeer() {
                    return peer;
                }

                public PeerDescriptor getPeerDescriptor() {
                    return peerItem;
                }

                public Object getData() {
                    return object;
                }
            });
        }

        public void destroyed() {
        }
    }

    protected class pieceFacade
    implements Piece {
        private final int index;

        protected pieceFacade(int n) {
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return PeerManagerImpl.this.dm_pieces[this.index].getLength();
        }

        public boolean isDone() {
            return PeerManagerImpl.this.dm_pieces[this.index].isDone();
        }

        public boolean isNeeded() {
            return PeerManagerImpl.this.dm_pieces[this.index].isNeeded();
        }

        public boolean isDownloading() {
            return PeerManagerImpl.this.pe_pieces[this.index] != null;
        }

        public boolean isFullyAllocatable() {
            if (PeerManagerImpl.this.pe_pieces[this.index] != null) {
                return false;
            }
            return PeerManagerImpl.this.dm_pieces[this.index].isInteresting();
        }

        public int getAllocatableRequestCount() {
            PEPiece pEPiece = PeerManagerImpl.this.pe_pieces[this.index];
            if (pEPiece != null) {
                return pEPiece.getNbUnrequested();
            }
            if (PeerManagerImpl.this.dm_pieces[this.index].isInteresting()) {
                return PeerManagerImpl.this.dm_pieces[this.index].getNbBlocks();
            }
            return 0;
        }

        public Peer getReservedFor() {
            List<PEPeer> list;
            String string;
            PEPiece pEPiece = PeerManagerImpl.this.pe_pieces[this.index];
            if (pEPiece != null && (string = pEPiece.getReservedBy()) != null && (list = PeerManagerImpl.this.manager.getPeers(string)).size() > 0) {
                return PeerManagerImpl.getPeerForPEPeer(list.get(0));
            }
            return null;
        }

        public void setReservedFor(Peer peer) {
            PEPiece pEPiece = PeerManagerImpl.this.pe_pieces[this.index];
            PEPeer pEPeer = PeerManagerImpl.this.mapForeignPeer(peer);
            if (pEPiece != null && pEPeer != null) {
                pEPiece.setReservedBy(peer.getIp());
                pEPeer.addReservedPieceNumber(this.index);
            }
        }
    }
}

